#include <stdio.h>
#include "amiga.h"
#include "ccBank.h"

#include	"X.h"
#include	"Xmd.h"
#include	"Xproto.h"
#include	"mfb.h"
#include	"gcstruct.h"
#include	"windowstr.h"
#include	"scrnintstr.h"
#include	"pixmapstr.h"
#include	"regionstr.h"
#include	"maskbits.h"
#include	"fastblt.h"
#include	"mergerop.h"

extern int bplcfb;
extern int mapsize;
extern int bplmfb;
Bool WriteFlag;

unsigned char masktab[4][2][65536];

unsigned char **addrtab1;
unsigned char *OldAdr = NULL;
int OldSize = 0;

void inittab(bmap_t *bm)
{
    int i;
    unsigned int v[4];
    int x, y;
    unsigned char *base;
    unsigned char **conv1, **conv2, **conv3, **conv4;

    for (i = 0; i < 65536; i++) {
	int j;

	bzero(v, sizeof(v));
	for (j = 15; j >= 0; j--)
	    v[j%4] = (v[j%4] << 1) | ((i & (1 << j)) ? 1 : 0);

	masktab[0][0][i] = v[0];
	masktab[1][0][i] = v[1];
	masktab[2][0][i] = v[2];
	masktab[3][0][i] = v[3];

	masktab[0][1][i] = v[0] << 4;
	masktab[1][1][i] = v[1] << 4;
	masktab[2][1][i] = v[2] << 4;
	masktab[3][1][i] = v[3] << 4;
    }
  
    addrtab1 = (unsigned char **) malloc(bplcfb * bm->rows * sizeof(char *));
    for (y = 0; y < bm->rows; y++) {
	base = mapaddr + bplmfb * y;
	conv1 = addrtab1 + bplcfb * y;
	for (x = 0; x < bplcfb * 2; x += 2) {
	    *conv1 = base + (x >> 3);
	    conv1++;
	}
    }
}

void CCWriteOld(unsigned char *a, int i)
{ 
    register unsigned short *w;
    int offset;
    register unsigned char *addr1, *addr2, *addr3, *addr4;
    register unsigned short c, c2;

    if (a >= maptop || a < mapbottom )	/* dans l'ecran ? */
	return;
    offset = OldAdr - mapbottom;
    w = (unsigned short *) OldAdr;
  
    if (OldSize) {
	OldSize >>= 2;
	addr1 = addrtab1[offset];
	asm("\n\
| mystart\n\
	moveml a0-a6/d4/d5/d6,sp@- \n\
	movel %1,a1 \n\
	movel %2,a2 \n\
| a3=bitplane 1 \n\
	movel %3,a3 \n\
| a4=bitplane 2 \n\
	movel a3,a4 \n\
	addal %4,a4 \n\
| a5=bitplane 3 \n\
	movel a4,a5 \n\
	addal %4,a5 \n\
| a6=bitplane 4\n\
	movel a5,a6 \n\
        addal %4,a6 \n\
	moveq #0,d5 \n\
	moveq #0,d6 \n\
\n\
Loop1: \n\
	movew a2@+,d5		| c2 = *w++ \n\
	movew a2@+,d6		| c = *w++ \n\
| 0 et 1 \n\
	moveb a1@(65536,d5),d4	| masktab2[c2] \n\
	orb   a1@(00000,d6),d4	| masktab1[c] \n\
	moveb d4,a3@+		| *addr++ \n\
| 2 et 3 \n\
        moveb a1@(196608,d5),d4	| masktab2[c2] \n\
        orb   a1@(131072,d6),d4	| masktab1[c] \n\
        moveb d4,a4@+		| *addr++ \n\
| 4 et 5 \n\
        moveb a1@(327680,d5),d4	| masktab2[c2] \n\
        orb   a1@(262144,d6),d4	| masktab1[c] \n\
        moveb d4,a5@+		| *addr++ \n\
| 6 et 7 \n\
        moveb a1@(458752,d5),d4	| masktab2[c2] \n\
        orb   a1@(393216,d6),d4	| masktab1[c] \n\
        moveb d4,a6@+		| *addr++ \n\
        dbf  %0,Loop1 \n\
        moveml sp@+,a0-a6/d4/d5/d6 \n"
	:
	: "d" ((int) OldSize),				/* %0 */ 
	  "d" ((unsigned char *) &masktab[0][0][0]),	/* %1 */
	  "d" ((unsigned short *) w),			/* %2 */
 	  "d" ((unsigned char *) addr1),		/* %3 */
	  "d" ((int) mapsize)				/* %4 */
	: "a3" "a4" "a5" "a6" "d6" "d4" "d5");
    }
    OldAdr = a;
    OldSize = i;
}


CCFlush()
{
    CCWriteOld(mapbottom,0);
}

int GetDepth()
{
    return(4);
}
