/*
 * Copyright 1990,91 by Thomas Roell, Dinkelscherben, Germany.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Thomas Roell not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Thomas Roell makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * THOMAS ROELL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THOMAS ROELL BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Thomas Roell, roell@informatik.tu-muenchen.de
 *
 * $Header: /proj/X11/mit/server/ddx/x386/vga/RCS/vgaBank.h,v 1.1 1991/06/02 22:36:37 root Exp $
 */

#ifndef BANK_H
#define BANK_H

extern int ReadFlag, WriteFlag;

extern unsigned char *mapaddr;
extern unsigned char *mapbottom;
extern unsigned char *maptop;
extern unsigned char *OldAdr;
extern int OldSize;

#define BASE ((long)mapbottom)
#define BOTTOM ((long)mapbottom)
#define TOP ((long)maptop) /* vga board installed memory */


#define INSCREEN(x) ((((unsigned long)x >= BOTTOM) && (((unsigned long)x <TOP))))
#define BANK_FLAG(a) \
   WriteFlag = (INSCREEN(a) ? TRUE : FALSE);

#define BANK_FLAG_BOTH(a,b) \
   WriteFlag = (INSCREEN(b) ? TRUE : FALSE); 


#define SETR(x)
#define SETW(x) { CCWriteOld(x,sizeof(*x)); }
#define SETRW(x) { CCWriteOld(x,sizeof(*x)); }
#define CHECKRO(x)
#define CHECKRU(x)
#if 0
#define CHECKWO(x) { if(WriteFlag) OldSize+=sizeof(*x); }

#define CHECKWU(x) { if(WriteFlag) {OldAdr-=sizeof(*x);OldSize+=sizeof(*x);}}
#endif
#if 1
#define CHECKWO(x) { if(WriteFlag) { if (((char *)x)==(char *)(OldAdr+OldSize)) \
			{ OldSize+=sizeof(*x); } \
				else \
			CCWriteOld(x,sizeof(*x)); } }

#define CHECKWU(x) { if(WriteFlag) { if (x==(void *)(OldAdr-sizeof(*x))) \
			{ OldAdr-=sizeof(*x);OldSize+=sizeof(*x); } \
				else \
			CCWriteOld(x,sizeof(*x)); } }


#define FCHECKWO(x) OldSize+=sizeof(*x);

#define FCHECKWU(x) {OldAdr-=sizeof(*x);OldSize+=sizeof(*x);}
#endif
#if 0
#define CHECKWO(x)  { if(WriteFlag)  CCWriteOld(x,sizeof(*x));  }

#define CHECKWU(x)  { if(WriteFlag)  CCWriteOld(x,sizeof(*x));  }
#endif
#define CHECKRWU(x) CHECKWU(x)
#define CHECKRWO(x) CHECKWO(x)

#define SAVE_BANK()
#define RESTORE_BANK()

#define PUSHR()
#define POPR()


#endif
