#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <sys/signal.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/queue.h>
#include <sys/device.h>
#ifndef VIOCREMOVE	/* not protected against multiple inclusion */
#include    "/sys/arch/amiga/dev/viewioctl.h"
#endif
#include    "/sys/arch/amiga/dev/grfabs_reg.h"

caddr_t mapaddr;

u_char bits[] = {
    0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01
};

u_char planebits[6][5] = {
    { /* dummy */ },
    { 0x01 },
    { 0x02, 0x01 },
    { 0x04, 0x02, 0x01 },
    { 0x08, 0x04, 0x02, 0x01 },
    { 0x10, 0x08, 0x04, 0x02, 0x01 }
};

void
ecs_drawpoint(int x, int y, struct view_size *vs, bmap_t *bm)
{
    int index;
    u_char old_byte;
    int color = 1;
    int i;

    index = y * (vs->width / 8) + (x / 8);
    for (i = 0; i < vs->depth; i++) {
	if (color & planebits[vs->depth][i]) {
	    old_byte = ((u_char *) mapaddr)[index] | bits[x % 8];
	    ((u_char *) mapaddr)[index] = old_byte;
	}
	index += bm->bytes_per_row * bm->rows;
    }
}

unsigned long ECSStdPalette[16] = {
    0x000c0c0c,
    0x00000000,
    0x00080000,
    0x00000800,
    0x00000008,
    0x00080800,
    0x00000808,
    0x00080008,
    0x00040404,
    0x000f0f0f,
    0x000f0000,
    0x00000f00,
    0x0000000f,
    0x000f0f00,
    0x00000f0f,
    0x000f000f
};

int
xopen_view (void)
{
    u_char buffer[13];
    int i, fd;
    
    for (i = 0; i < 100; i++) {
	sprintf(buffer, "/dev/view%02d", i);
	fd = open(buffer, O_RDWR);
	if (fd == -1) {
	    if (errno != EBUSY) {
		perror("xopen_view()");
		return(-1);
	    }
	    /* keep trying */
	} else {
	    /* found one */
	    return(fd);
	}
    }
    fprintf(stderr, "Ran out of views");
    return(-1);
}

main(argc, argv)
    int argc;
    char *argv;
{
    int fd;
    int bufsize, i;
    int nplanes;
    int planesize;
    struct view_size vs;
    bmap_t bm;
    colormap_t cmap;

    if ((fd = xopen_view()) == -1)
	exit(1);

    if (ioctl(fd, VIOCGSIZE, &vs) == -1) {
	perror("ioctl VIOCGSIZE");
	exit(1);
    }

    vs.depth = 2;
    if (ioctl(fd, VIOCSSIZE, &vs) == -1) {
	perror("ioctl VIOCSSIZE");
	exit(1);
    }

    if (ioctl(fd, VIOCGBMAP, &bm) == -1) {
	perror("ioctl VIOCGBMAP");
	exit(1);
    }

    printf("x %d y %d width %d height %d depth %d\n",
	   vs.x, vs.y, vs.width, vs.height, vs.depth);
    printf("bytes_per_row %d row_mod %d rows %d depth %d flags %x "
	   "blit_temp %x\nplane %x hardware_address %x\n",
	   bm.bytes_per_row, bm.row_mod, bm.rows, bm.depth, bm.flags,
	   bm.blit_temp, bm.plane, bm.hardware_address);

    planesize = bm.bytes_per_row * bm.rows;

    if ((mapaddr = mmap(0, bm.bytes_per_row * bm.rows * bm.depth,
        PROT_READ | PROT_WRITE, MAP_FILE, fd, (off_t) 0)) == (caddr_t) -1) {
	perror("mmap");
	close(fd);
	exit(1);
    }

    for (i = 0; i < bm.depth; i++)
	bzero(mapaddr + (i * planesize), planesize);

    if (ioctl(fd, VIOCGCMAP, &cmap) == -1) {
	perror("ioctl VIOCGCMAP");
	exit(1);
    }

printf("type %d red_mask %x green_mask %x blue_mask %x first %d size %d entry %x\n",
       cmap.type, cmap.red_mask, cmap.green_mask, cmap.blue_mask, cmap.first,
       cmap.size, cmap.entry);
    cmap.size = 1 << vs.depth;
    cmap.entry = ECSStdPalette;
    if (ioctl(fd, VIOCSCMAP, &cmap) == -1) {
	perror("ioctl VIOCSCMAP");
	exit(1);
    }

    if (ioctl(fd, VIOCDISPLAY, 0)) {
        perror("ioctl VIOCDISPLAY");
	exit(1);
    }

printf("display up\n");
getchar();
    {
	int x;

	for (x = 0; x < vs.height; x++) {
	    ecs_drawpoint(x, x, &vs, &bm);
	    ecs_drawpoint(vs.width - x, x, &vs, &bm);
	}
    }
getchar();

    close(fd);
    exit(0);
}
