/* G13.C - Functions for arithmetic in G(2^4) reduced modulo x^4 + x + 1.
Author: Peter Pearson
Version of 93.02.15.

Revision history:
        87.05.19 - Initial version.
        93.02.15 - Adapted to Turbo C.
*/

#include <stdio.h>
#include "g13.h"


int Offset[16] = { 0,1,3,6,10,15,21,28,36,45,55,66,78,91,105,120 } ;
int Product[136] = {
0x0, 
0x0, 0x1, 
0x0, 0x2, 0x4, 
0x0, 0x3, 0x6, 0x5, 
0x0, 0x4, 0x8, 0xc, 0x3, 
0x0, 0x5, 0xa, 0xf, 0x7, 0x2, 
0x0, 0x6, 0xc, 0xa, 0xb, 0xd, 0x7, 
0x0, 0x7, 0xe, 0x9, 0xf, 0x8, 0x1, 0x6, 
0x0, 0x8, 0x3, 0xb, 0x6, 0xe, 0x5, 0xd, 0xc, 
0x0, 0x9, 0x1, 0x8, 0x2, 0xb, 0x3, 0xa, 0x4, 0xd, 
0x0, 0xa, 0x7, 0xd, 0xe, 0x4, 0x9, 0x3, 0xf, 0x5, 0x8, 
0x0, 0xb, 0x5, 0xe, 0xa, 0x1, 0xf, 0x4, 0x7, 0xc, 0x2, 0x9, 
0x0, 0xc, 0xb, 0x7, 0x5, 0x9, 0xe, 0x2, 0xa, 0x6, 0x1, 0xd, 0xf, 
0x0, 0xd, 0x9, 0x4, 0x1, 0xc, 0x8, 0x5, 0x2, 0xf, 0xb, 0x6, 0x3, 0xe, 
0x0, 0xe, 0xf, 0x1, 0xd, 0x3, 0x2, 0xc, 0x9, 0x7, 0x6, 0x8, 0x4, 0xa, 0xb, 
0x0, 0xf, 0xd, 0x2, 0x9, 0x6, 0x4, 0xb, 0x1, 0xe, 0xc, 0x3, 0x8, 0x7, 0x5, 0xa
} ;
int Reciprocal[16] = {  0, 1, 9, 0xe, 0xd, 0xb, 7, 6,
                        0xf, 2, 0xc, 5, 0xa, 4, 3, 8 } ;

G13 Add( G13 a, G13 b )
{
    return a^b ;
}

G13 Div( G13 a, G13 b )
{
    if ( ( a | b ) > 15 )
        fprintf( stderr, "Illegal argument in G13 Divide.\n" ) ;

    return Mult( a, Reciprocal[b] ) ;
}

G13 Mult( G13 a, G13 b )
{
    if ( ( a | b ) > 15 )
        fprintf( stderr, "Illegal argument in G13 Multiply.\n" ) ;

    return ( a < b ) ? Product[ Offset[ b ] + a ]
                     : Product[ Offset[ a ] + b ] ;
}
