/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.bean;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import sunw.hotjava.bean.DisplayOnlyEditor;
import sunw.hotjava.bean.PoolEntry;
import sunw.hotjava.misc.Globals;

public class URLPool
implements DisplayOnlyEditor.Displayable {
    private Hashtable pool;
    private String urlChanged;
    private Date oldDate;
    private Date newDate;

    public URLPool(PoolEntry[] poolEntryArray) {
        Hashtable<String, Date> hashtable = new Hashtable<String, Date>();
        if (poolEntryArray != null) {
            int n = 0;
            while (n < poolEntryArray.length) {
                hashtable.put(poolEntryArray[n].url, poolEntryArray[n].lastTouched);
                ++n;
            }
        }
        this.pool = hashtable;
    }

    URLPool(Hashtable hashtable) {
        this(hashtable, null, null, null);
    }

    URLPool(Hashtable hashtable, String string, Date date, Date date2) {
        this.pool = hashtable;
        this.urlChanged = string;
        this.oldDate = date;
        this.newDate = date2;
    }

    void setSystemPool() {
        Globals.pool.setPoolFromBean(this.pool);
    }

    public PoolEntry[] getEntries() {
        PoolEntry[] poolEntryArray;
        Hashtable hashtable = this.pool;
        synchronized (hashtable) {
            int n = 0;
            if (this.urlChanged != null && this.newDate != null && this.oldDate == null) {
                poolEntryArray = new PoolEntry[this.pool.size() + 1];
                poolEntryArray[n++] = new PoolEntry(this.newDate, this.urlChanged);
            } else {
                poolEntryArray = new PoolEntry[this.pool.size()];
            }
            Enumeration enumeration = this.pool.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Date date = (Date)this.pool.get(string);
                poolEntryArray[n++] = string.equals(this.urlChanged) ? new PoolEntry(this.newDate, string) : new PoolEntry(date, string);
            }
        }
        return poolEntryArray;
    }

    public boolean isIncrementalChange(URLPool uRLPool) {
        return this.pool == uRLPool.pool;
    }

    public PoolEntry entryAdded(URLPool uRLPool) {
        if (this == uRLPool) {
            return null;
        }
        if (this.urlChanged != null) {
            if (this.newDate != null) {
                return new PoolEntry(this.newDate, this.urlChanged);
            }
            return null;
        }
        if (uRLPool.urlChanged != null) {
            return uRLPool.entryRemoved(this);
        }
        return null;
    }

    public PoolEntry entryRemoved(URLPool uRLPool) {
        if (this == uRLPool) {
            return null;
        }
        if (this.urlChanged != null) {
            if (this.oldDate != null) {
                return new PoolEntry(this.oldDate, this.urlChanged);
            }
            return null;
        }
        if (uRLPool.urlChanged != null) {
            return uRLPool.entryAdded(this);
        }
        return null;
    }

    public String toDisplayString() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.toString()) + ":\n\n");
        PoolEntry[] poolEntryArray = this.getEntries();
        int n = 0;
        while (n < poolEntryArray.length) {
            stringBuffer.append(poolEntryArray[n].toDisplayString());
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

