/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

public class RequestProcessor
implements Runnable {
    private static RequestNode requestQueue;
    private static Thread dispatcher;
    private static Object lock;
    private static RequestNode nodeSave;

    public static void postRequest(Request request) {
        RequestProcessor.postRequest(request, 0);
    }

    public static void postRequest(Request request, int n) {
        long l = (long)n + System.currentTimeMillis();
        Object object = lock;
        synchronized (object) {
            RequestNode requestNode = nodeSave;
            nodeSave = null;
            if (requestNode == null) {
                requestNode = new RequestNode();
            }
            requestNode.request = request;
            requestNode.when = l;
            if (requestQueue == null) {
                requestQueue = requestNode;
            } else if (RequestProcessor.requestQueue.when > requestNode.when) {
                requestNode.next = requestQueue;
                requestQueue = requestNode;
            } else {
                RequestNode requestNode2 = requestQueue;
                while (requestNode2.next != null && requestNode2.next.when <= requestNode.when) {
                    requestNode2 = requestNode2.next;
                }
                requestNode.next = requestNode2.next;
                requestNode2.next = requestNode;
            }
            lock.notifyAll();
            return;
        }
    }

    public void run() {
        try {
            while (true) {
                RequestNode requestNode;
                Object object = lock;
                synchronized (object) {
                    while (requestQueue == null) {
                        lock.wait();
                    }
                    long l = System.currentTimeMillis();
                    while (RequestProcessor.requestQueue.when > l) {
                        lock.wait(RequestProcessor.requestQueue.when - l);
                        l = System.currentTimeMillis();
                    }
                    requestNode = requestQueue;
                    requestQueue = RequestProcessor.requestQueue.next;
                }
                requestNode.request.execute();
                requestNode.request = null;
                requestNode.next = null;
                nodeSave = requestNode;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static synchronized void startProcessing() {
        if (dispatcher == null) {
            dispatcher = new Thread((Runnable)new RequestProcessor(), "Request Processor");
            dispatcher.setPriority(7);
            dispatcher.start();
        }
    }

    static {
        lock = new Object();
        nodeSave = null;
    }

    public static abstract class Request {
        public abstract void execute();
    }

    private static final class RequestNode {
        Request request;
        long when;
        RequestNode next;

        RequestNode() {
        }
    }
}

