/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.EventListener;
import java.util.EventObject;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.net.www.ApplicationLaunchException;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.StreamCopier;

public class URLApplicationLauncher
implements Runnable {
    private static final int ID_BASE = 2000;
    public static final int FILE_NOT_FOUND = 2001;
    public static final int FILE_NOT_EXECUTABLE = 2002;
    public static final int LAUNCH_FAILED = 2003;
    private static final boolean showChildOutput = Boolean.getBoolean("urlapplicationlauncher.showchildoutput");
    private URL url;
    private String application;
    private String tempFileTemplate;
    private String tempFile;
    private Thread launcher;
    private int exitStatus;
    private Vector errorListeners = new Vector(1);

    public URLApplicationLauncher(URL uRL, String string) {
        this(uRL, string, null);
    }

    public URLApplicationLauncher(URL uRL, String string, String string2) {
        this(uRL, string, string2, null);
    }

    public URLApplicationLauncher(URL uRL, String string, String string2, String string3) {
        this.url = uRL;
        this.application = string;
        this.tempFile = string2;
        if (string3 == null) {
            this.tempFileTemplate = this.getTempFileTemplate();
            return;
        }
        this.tempFileTemplate = string3;
    }

    public int getStatus() {
        return this.exitStatus;
    }

    public void start() {
        this.launcher = new Thread(this);
        this.launcher.start();
    }

    public void stop() {
        this.launcher.interrupt();
    }

    public URL getURL() {
        return this.url;
    }

    public String getApplication() {
        return this.application;
    }

    public String getTempFileName() {
        String string = this.tempFileTemplate;
        int n = string.lastIndexOf("%s");
        String string2 = string.substring(0, n);
        String string3 = "";
        if (n < string.length() - 2) {
            string3 = string.substring(n + 2);
        }
        long l = System.currentTimeMillis() / 1000L;
        int n2 = 0;
        while ((n2 = string2.indexOf("%s")) >= 0) {
            string2 = String.valueOf(string2.substring(0, n2)) + l + string2.substring(n2 + 2);
        }
        String string4 = Globals.getFileNameFromURL(this.url);
        String string5 = "";
        int n3 = string4.lastIndexOf(46);
        if (n3 >= 0) {
            string5 = string4.substring(n3);
            string4 = string4.substring(0, n3);
        }
        File file = new File(string4.replace('/', File.separatorChar));
        string4 = file.getName();
        string = String.valueOf(string2) + string4 + l + string5 + string3;
        return string;
    }

    public String getExecutablePath(String string) throws ApplicationLaunchException {
        return this.getExecutablePath(string, null);
    }

    public String getExecutablePath(String string, String string2) throws ApplicationLaunchException {
        int n = string.indexOf(32);
        String string3 = n != -1 ? string.substring(0, n) : string;
        File file = new File(string3);
        if (file.isFile()) {
            return string;
        }
        String string4 = System.getProperty("exec.path");
        if (string4 == null) {
            throw new ApplicationLaunchException("No path to search for " + string);
        }
        String string5 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "|");
        while (stringTokenizer.hasMoreElements()) {
            String string6 = (String)stringTokenizer.nextElement();
            String string7 = String.valueOf(string6) + File.separator + string3;
            file = new File(string7);
            if (!file.isFile()) continue;
            string5 = String.valueOf(string6) + File.separator + string;
            break;
        }
        if (string5 == null) {
            throw new ApplicationLaunchException("Not on exec.path: " + string);
        }
        if (string2 != null) {
            int n2;
            while ((n2 = string5.indexOf("%t")) >= 0) {
                string5 = String.valueOf(string5.substring(0, n2)) + string2 + string5.substring(n2 + 2);
            }
        }
        return string5;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        block21: {
            if (this.tempFile == null) {
                this.tempFile = this.getTempFileName();
            }
            try {
                try {
                    var3_1 = null;
                    var4_6 = null;
                    try {
                        var5_7 = this.url.openConnection();
                        var3_1 = var5_7.getInputStream();
                        var4_6 = new BufferedOutputStream(new FileOutputStream(this.tempFile));
                    }
                    catch (IOException var5_8) {
                        var5_8.printStackTrace();
                    }
                    var5_7 = new StreamCopier((InputStream)var3_1, var4_6);
                    var5_7.transfer();
                    var4_6.flush();
                    try {
                        var3_1.close();
                    }
                    catch (Exception v0) {}
                    try {
                        var4_6.close();
                    }
                    catch (Exception v1) {}
                    var6_9 = String.valueOf(this.getExecutablePath(this.application)) + " " + this.tempFile;
                    var7_10 = Runtime.getRuntime().exec(var6_9);
                    if (URLApplicationLauncher.showChildOutput) {
                        var8_11 = var7_10.getErrorStream();
                        while (true) {
                            if ((var9_12 = var8_11.read()) == -1) {
                                var8_11.close();
                                break;
                            }
                            System.out.print((char)var9_12);
                        }
                    }
                    try {
                        var7_10.waitFor();
                    }
                    catch (InterruptedException v2) {}
                    this.exitStatus = var7_10.exitValue();
                    if (this.exitStatus == 0) break block21;
                    this.dispatchLauncherError(2003);
                    var2_13 = null;
                }
                catch (ApplicationLaunchException var3_2) {
                    System.err.println("URLApplicationLauncher run failed: " + (Object)var3_2);
                    this.dispatchLauncherError(2002);
                    break block21;
                }
                catch (IOException var3_3) {
                    System.err.println("URLApplicationLauncher run failed: " + var3_3);
                    this.dispatchLauncherError(2002);
                    break block21;
                }
            }
            catch (Throwable var1_16) {
                var2_15 = null;
                try {
                    if (this.tempFile == null) throw var1_16;
                    var3_4 = new File(this.tempFile);
                    if (Boolean.getBoolean("externalviewer.keep.tmpfile") != false) throw var1_16;
                    if (var3_4.delete() != false) throw var1_16;
                    System.err.println("Could not delete file: " + this.tempFile);
                    throw var1_16;
                }
                catch (SecurityException var3_5) {
                    System.err.println("Could not delete temp file: " + var3_5);
                    throw var1_16;
                }
            }
            ** try [egrp 6[TRYBLOCK] [7 : 306->368)] { 
lbl71:
            // 1 sources

            if (this.tempFile == null) return;
            var3_1 = new File(this.tempFile);
            if (Boolean.getBoolean("externalviewer.keep.tmpfile") != false) return;
            if (var3_1.delete() != false) return;
            System.err.println("Could not delete file: " + this.tempFile);
            return;
lbl77:
            // 1 sources

            catch (SecurityException var3_1) {
                System.err.println("Could not delete temp file: " + var3_1);
            }
            return;
        }
        var2_14 = null;
        ** try [egrp 6[TRYBLOCK] [7 : 306->368)] { 
lbl83:
        // 1 sources

        if (this.tempFile == null) return;
        var3_1 = new File(this.tempFile);
        if (Boolean.getBoolean("externalviewer.keep.tmpfile") != false) return;
        if (var3_1.delete() != false) return;
        System.err.println("Could not delete file: " + this.tempFile);
        return;
lbl89:
        // 1 sources

        catch (SecurityException var3_1) {
            System.err.println("Could not delete temp file: " + var3_1);
        }
    }

    String getTempFileTemplate() {
        File file;
        String string = null;
        String string2 = System.getProperty("user.home");
        if (string2 != null && !string2.endsWith(File.separator)) {
            string2 = String.valueOf(string2) + File.separator;
        }
        if (!((file = new File(string2 = String.valueOf(string2) + ".hotjava" + File.separator + "temp")).exists() || file.mkdirs() || (file = new File(string2 = String.valueOf(System.getProperty("hotjava.home")) + File.separator + "temp")).exists() || file.mkdirs())) {
            return "%s";
        }
        string = String.valueOf(string2) + File.separator + "%s";
        return string;
    }

    public void addListener(ErrorListener errorListener) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(errorListener);
            return;
        }
    }

    private void dispatchLauncherError(int n) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            int n2 = this.errorListeners.size();
            if (n2 != 0) {
                ErrorEvent errorEvent = new ErrorEvent(this, n);
                int n3 = 0;
                while (n3 < n2) {
                    ErrorListener errorListener = (ErrorListener)this.errorListeners.elementAt(n3);
                    errorListener.launcherErrorOccurred(errorEvent);
                    ++n3;
                }
            }
            return;
        }
    }

    public static class ErrorEvent
    extends EventObject {
        int id;

        public ErrorEvent(Object object, int n) {
            super(object);
            this.id = n;
        }

        public int getId() {
            return this.id;
        }
    }

    public interface ErrorListener
    extends EventListener {
        public void launcherErrorOccurred(ErrorEvent var1);
    }
}

