/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tables;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Vector;
import sunw.hotjava.doc.BlockTagItem;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentState;
import sunw.hotjava.doc.FlowTagItem;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.MeasureState;
import sunw.hotjava.doc.Measurement;
import sunw.hotjava.doc.PrintedLineInfo;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.Length;
import sunw.hotjava.tables.BGColorInfo;
import sunw.hotjava.tables.TD;
import sunw.hotjava.tables.TableElementPanel;
import sunw.hotjava.tables.TablePanel;

class TableElementFormatter
extends Formatter
implements Serializable {
    static final long serialVersionUID = 8340134216489154801L;
    private DocItem startItem;
    private int startIndex;
    private boolean valid = false;
    private byte rowSpan;
    private byte colSpan;
    private Measurement elementMeasurement;
    private Length cellWidth;
    private Length cellHeight;
    private int vAlign;
    private int baselineOffset;
    private int oldDocYStart;
    private TableElementPanel parent;
    private Color myBackgroundColor;
    private boolean myBackgroundColorIsDeliberate;
    FormatterMouseListener formatterMouseListener;

    TableElementFormatter() {
    }

    TableElementFormatter(TableElementPanel tableElementPanel, DocumentState documentState, Document document, DocItem docItem, Length length, Length length2, int n, int n2, int n3, BGColorInfo bGColorInfo) {
        this.lines = new DocLine[1];
        this.nlines = 0;
        this.lines[0] = new DocLine(0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        this.parent = tableElementPanel;
        this.ds = documentState;
        this.doc = document;
        this.startItem = docItem;
        this.cellWidth = length;
        this.cellHeight = length2;
        this.vAlign = n;
        this.colSpan = (byte)n2;
        this.rowSpan = (byte)n3;
        this.marginHeight = this.parent.getCellPadding();
        this.startIndex = docItem.getIndex() + 1;
        TagItem tagItem = docItem.getTag(document);
        tagItem.getAttributes();
        if (bGColorInfo.isSet()) {
            this.myBackgroundColorIsDeliberate = true;
            this.myBackgroundColor = bGColorInfo.getColor();
            return;
        }
        this.myBackgroundColor = bGColorInfo.getDefaultColor();
    }

    TableElementFormatter(TableElementFormatter tableElementFormatter, TableElementPanel tableElementPanel, DocumentState documentState) {
        this.lines = new DocLine[1];
        this.parent = tableElementPanel;
        this.ds = documentState;
        this.doc = tableElementFormatter.doc;
        this.startItem = tableElementFormatter.startItem;
        this.cellWidth = tableElementFormatter.cellWidth;
        this.cellHeight = tableElementFormatter.cellHeight;
        this.vAlign = tableElementFormatter.vAlign;
        this.colSpan = tableElementFormatter.colSpan;
        this.rowSpan = tableElementFormatter.rowSpan;
        this.marginHeight = this.parent.getCellPadding();
        this.startIndex = tableElementFormatter.startIndex;
        this.myBackgroundColor = Color.white;
        this.copyPanelsForPrinting(tableElementFormatter, documentState);
    }

    public void registerListeners() {
        Container container = this.getParent();
        if (container != null) {
            this.formatterMouseListener = new FormatterMouseListener();
            container.addMouseListener(this.formatterMouseListener);
            container.addMouseMotionListener(this.formatterMouseListener);
        }
    }

    public void unregisterListeners() {
        Container container = this.getParent();
        if (container != null) {
            container.removeMouseListener(this.formatterMouseListener);
            container.removeMouseMotionListener(this.formatterMouseListener);
        }
        super.unregisterListeners();
    }

    protected void processMouseAction(MouseEvent mouseEvent) {
        super.processMouseAction(mouseEvent);
    }

    void getFormPanel(Vector vector) {
        int n = this.getStartIndex();
        int n2 = this.getMaxIndex();
        while (n < n2) {
            DocItem docItem = this.doc.getItem(n);
            n += docItem.getFormPanel(this, vector);
        }
    }

    Length getCellWidth() {
        return this.cellWidth;
    }

    Length getCellHeight() {
        return this.cellHeight;
    }

    int getColSpan() {
        return this.colSpan;
    }

    int getRowSpan() {
        return this.rowSpan;
    }

    public void dispatchDocumentEvent(Object object, int n, boolean bl, Object object2) {
        this.getTopFormatter().dispatchDocumentEvent(object, n, bl, object2);
    }

    public void dispatchDocumentEvent(int n, Object object) {
        this.getTopFormatter().dispatchDocumentEvent(n, object);
    }

    boolean containsPos(int n) {
        int n2 = n >> 16;
        return this.getStartIndex() <= n2 && n2 < this.getMaxIndex();
    }

    void adjustSpanBy(int n, boolean bl) {
        if (bl) {
            this.colSpan = (byte)(this.colSpan + n);
            return;
        }
        this.rowSpan = (byte)(this.rowSpan + n);
    }

    public int getAvailableHeight() {
        return this.height;
    }

    public int getAvailableWidth() {
        return this.width;
    }

    public Container getParent() {
        return this.parent;
    }

    public Formatter getParentFormatter() {
        return this.parent.getParentFormatter();
    }

    void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    int getBaseline() {
        if (this.vAlign == 4 && this.nlines > 0) {
            return this.lines[0].baseline;
        }
        return 0;
    }

    void setCommonBaseline(int n) {
        this.baselineOffset = 0;
        if (this.vAlign == 4 && this.nlines > 0) {
            DocLine docLine = this.lines[0];
            this.baselineOffset = n - docLine.baseline;
        }
    }

    void doVerticalAlignment() {
        int n = 0;
        int n2 = this.parent.getCellPadding();
        switch (this.vAlign) {
            case 2: {
                n = (this.height - this.docHeight - n2) / 2;
                break;
            }
            case 4: {
                n = this.baselineOffset;
                break;
            }
            case 5: {
                n = this.height - n2 - this.docHeight;
                break;
            }
        }
        if (n - this.oldDocYStart != 0) {
            this.adjustLinesBy(n - this.oldDocYStart);
            this.oldDocYStart = n;
        }
    }

    private void adjustLinesBy(int n) {
        int n2 = 0;
        while (n2 < this.nlines) {
            this.lines[n2].y += n;
            ++n2;
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return this.ds.docStyle.win.imageUpdate(image, n, n2, n3, n4, n5);
    }

    public void reformat() {
        super.reformat();
        this.baselineOffset = 0;
        this.oldDocYStart = 0;
    }

    void setAssignedWidth(int n) {
        if (this.width != n) {
            this.width = n;
            this.reformat();
        }
        this.formatElement();
    }

    void measure(Measurement measurement) {
        this.updateMeasurements();
        measurement.setMinWidth(this.elementMeasurement.getMinWidth());
        measurement.setPreferredWidth(this.elementMeasurement.getPreferredWidth());
    }

    int getElementHeight() {
        return this.docHeight;
    }

    int getAdjustedElementHeight() {
        return this.docHeight + this.baselineOffset;
    }

    private void updateMeasurements() {
        Object object;
        int n;
        DocStyle docStyle;
        if (this.valid) {
            return;
        }
        this.elementMeasurement = new Measurement();
        Measurement measurement = new Measurement();
        MeasureState measureState = new MeasureState();
        measureState.pos = this.startIndex << 16;
        measureState.style = docStyle = this.doc.getStyle(this.ds.docStyle, measureState.pos);
        boolean bl = measureState.style.nobreak;
        Measurement measurement2 = new Measurement();
        int n2 = this.getStartIndex() + this.getNumItems() << 16;
        FormatState formatState = new FormatState();
        boolean bl2 = false;
        int n3 = -1;
        boolean bl3 = false;
        int n4 = -1;
        boolean bl4 = true;
        while (measureState.pos < n2) {
            TagItem tagItem;
            n = measureState.pos >> 16;
            object = this.doc.getItem(n);
            int n5 = ((DocItem)object).getOffset();
            if (object instanceof FlowTagItem) {
                tagItem = (FlowTagItem)object;
                if (tagItem.nobr) {
                    bl2 = n5 > 0;
                    n3 = n + n5;
                }
            }
            if (n == n3) {
                bl2 = false;
            }
            if (object instanceof BlockTagItem) {
                tagItem = (BlockTagItem)object;
                if (((BlockTagItem)tagItem).pre) {
                    bl3 = true;
                    n4 = n + n5;
                }
            }
            if (n == n4) {
                bl3 = false;
            }
            boolean bl5 = false;
            measurement2.reset();
            if (n5 > 0) {
                bl5 = ((DocItem)object).measureStartTag(this, formatState, measurement2, measureState);
                measureState.style.nobreak = bl;
            } else if (n5 < 0) {
                bl5 = ((DocItem)object).measureEndTag(this, formatState, measurement2, measureState);
            } else {
                if (bl3 || bl2) {
                    measureState.style.nobreak = true;
                }
                bl5 = ((DocItem)object).measureItem(this, formatState, measurement2, measureState);
                measureState.style.nobreak = bl;
            }
            if (!measureState.skipShifting) {
                if (bl4) {
                    measurement2.adjustBy(measureState.leftShift);
                    bl4 = false;
                } else {
                    measurement2.adjustMinBy(measureState.leftShift);
                }
            } else {
                measureState.skipShifting = false;
                bl5 = true;
            }
            if (measureState.style.nobreak && !bl5) {
                if (this.cellWidth.isSet() && measurement.getMinWidth() + measurement2.getMinWidth() > this.cellWidth.getValue()) {
                    measureState.style.nobreak = false;
                    bl = false;
                    TD tD = (TD)this.startItem;
                    tD.ignoreNoWrap();
                    measureState.pos -= 65536;
                    measurement2.reset();
                    continue;
                }
                measurement.appendNoBreak(measurement2);
            } else {
                measurement.append(measurement2);
            }
            if (!bl5) continue;
            bl5 = false;
            this.elementMeasurement.unify(measurement);
            measurement.reset();
            bl4 = true;
        }
        this.elementMeasurement.unify(measurement);
        if (!measureState.style.nobreak) {
            this.elementMeasurement.adjustForFloaters();
        } else {
            this.elementMeasurement.adjustForFloatersNoBreak();
        }
        if (this.cellWidth.isSet() && !this.cellWidth.isPercentage()) {
            n = this.elementMeasurement.getMinWidth();
            if (n > this.cellWidth.getValue()) {
                object = Integer.toString(n);
                this.cellWidth = new Length((String)object);
            } else {
                this.elementMeasurement.setMinWidth(this.cellWidth.getValue());
            }
            this.elementMeasurement.setPreferredWidth(this.cellWidth.getValue());
        }
        this.valid = !measureState.measurementInvalid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipRect();
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                if (rectangle == null) {
                    if (!this.paint(graphics, 0, 0, this.width, this.height, true)) return;
                    this.touch();
                } else {
                    int n = Math.max(rectangle.x, 0);
                    int n2 = Math.max(rectangle.y, 0);
                    int n3 = Math.min(rectangle.x + rectangle.width, this.width);
                    int n4 = Math.min(rectangle.y + rectangle.height, this.height);
                    if (n > this.width) return;
                    if (n3 < 0) return;
                    if (n2 > this.height) return;
                    if (n4 < 0) {
                        return;
                    }
                    if (!this.paint(graphics, n, n2, n3 - n, n4 - n2, true)) return;
                    this.touch();
                }
            }
            return;
        }
    }

    protected void clipToDrawableArea(Graphics graphics) {
        int n = this.parent.getCellPadding();
        graphics.clipRect(n, n, this.width - 2 * n, this.height - 2 * n);
    }

    boolean paint(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (this.getStartIndex() >= this.doc.nitems) {
            return false;
        }
        Graphics graphics2 = graphics.create();
        boolean bl2 = false;
        try {
            this.clipToDrawableArea(graphics2);
            int n5 = n2;
            int n6 = n5 + n4;
            DocStyle docStyle = null;
            boolean bl3 = this.ds.paintingScreen;
            if (bl && this.nlines > 0 && this.lines[0].y != 0) {
                this.paintBack(graphics2, 0, 0, this.width, this.lines[0].y);
            }
            int n7 = this.findY(n2);
            while (n7 < this.nlines) {
                DocLine docLine = this.lines[n7];
                if (docLine.y >= n6) break;
                n5 = docLine.y;
                if (bl) {
                    this.paintBack(graphics2, 0, n5, this.width, docLine.height);
                }
                if (!docLine.updated || bl3) {
                    docStyle = this.paintLine(graphics2, docLine, n5, n, n3, docStyle, false);
                } else {
                    bl2 = true;
                    docStyle = null;
                }
                n5 += docLine.height;
                ++n7;
            }
            if (bl && n5 < n6) {
                this.paintBack(graphics2, 0, n5, this.width, n6 - n5);
            }
            this.paintFloaters(graphics2, n, n2, n3, n4);
        }
        finally {
            Object var10_15 = null;
            graphics2.dispose();
        }
        return bl2;
    }

    public void print(Graphics graphics) {
        PrintedLineInfo printedLineInfo = new PrintedLineInfo();
        Graphics graphics2 = graphics.create();
        try {
            this.clipToDrawableArea(graphics2);
            int n = 0;
            DocStyle docStyle = null;
            int n2 = 0;
            while (n2 < this.nlines) {
                DocLine docLine = this.lines[n2];
                n = docLine.y;
                docStyle = this.printLine(graphics2, docLine, n, 0, this.width, docStyle, printedLineInfo);
                n += docLine.height;
                ++n2;
            }
            this.printFloatersInYRange(graphics2, 0, n);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            graphics2.dispose();
            throw throwable;
        }
        Object var5_8 = null;
        graphics2.dispose();
    }

    public void touch(boolean bl, int n) {
        this.parent.touch(bl, n);
    }

    void requestReformat(boolean bl, int n) {
        this.parent.touch(bl, n, this.startItem);
        this.valid = false;
    }

    public void touch(boolean bl, int n, DocItem docItem) {
        int n2 = this.findPos(docItem.getIndex() << 16);
        if (n2 < this.nlines) {
            this.lines[n2].updated = true;
        }
        this.parent.touch(bl, n, docItem);
    }

    protected void setVisible(Component component, BitSet bitSet, int n) {
        if (bitSet != null && bitSet.get(n) && !(component instanceof TablePanel)) {
            component.setVisible(true);
        }
    }

    protected void setInvisible(Component component, BitSet bitSet, int n) {
        if (component.isVisible() && !(component instanceof TablePanel)) {
            bitSet.set(n);
            component.setVisible(false);
        }
    }

    protected void disconnectFromParent(Component component) {
        this.parent.remove(component);
    }

    public Graphics getGraphics() {
        if (this.parent != null && this.ds.started) {
            return this.parent.getGraphics();
        }
        return null;
    }

    public void activateSubItems() {
        this.activateItemComponents();
    }

    public void notify(Document document, int n, int n2, int n3) {
        n2 = Math.max(n2, this.startIndex << 16);
        int n4 = this.findAffected(n2);
        switch (n) {
            case 10: {
                int n5 = n2 & 0x7FFF0000;
                int n6 = 65536 - (n2 & 0xFFFF);
                int n7 = n5 + 65536;
                if ((this.ds.selStart & 0x7FFF0000) == n5 && this.ds.selStart > n2) {
                    this.ds.selStart += n6;
                } else if (this.ds.selStart > n7) {
                    this.ds.selStart += 65536;
                }
                if ((this.ds.selEnd & 0x7FFF0000) == n5 && this.ds.selEnd >= n2) {
                    this.ds.selEnd += n6;
                } else if (this.ds.selEnd > n7) {
                    this.ds.selEnd += 65536;
                }
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    docLine.updated = true;
                    if ((docLine.start & 0x7FFF0000) == n5 && docLine.start > n2) {
                        docLine.start += n6;
                    } else if (docLine.start >= n7) {
                        docLine.start += 65536;
                    }
                    docLine.end = (docLine.end & 0x7FFF0000) == n5 && docLine.end >= n2 ? (docLine.end += n6) : (docLine.end += 65536);
                    docLine.tail = (docLine.tail & 0x7FFF0000) == n5 && docLine.tail >= n2 ? (docLine.tail += n6) : (docLine.tail += 65536);
                    ++n4;
                }
                this.valid = false;
                this.adjustElementItemCountBy(1);
                this.invalidateFloatersInRange(n2, this.lines[--n4].end);
                this.notifyResponsiblesInRange(document, n, n2, n3);
                return;
            }
            case 12: {
                int n8 = n2 & 0x7FFF0000;
                if ((this.ds.selStart & 0x7FFF0000) == n8 && this.ds.selStart > n2) {
                    this.ds.selStart += n3;
                }
                if ((this.ds.selEnd & 0x7FFF0000) == n8 && this.ds.selEnd >= n2) {
                    this.ds.selEnd += n3;
                }
                int n9 = n8 + 65536;
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    if (docLine.start > n9) break;
                    docLine.updated = true;
                    if ((docLine.start & 0x7FFF0000) == n8 && docLine.start > n2) {
                        docLine.start += n3;
                    }
                    if ((docLine.end & 0x7FFF0000) == n8 && docLine.end >= n2) {
                        docLine.end += n3;
                    }
                    if ((docLine.tail & 0x7FFF0000) == n8 && docLine.tail >= n2) {
                        docLine.tail += n3;
                    }
                    ++n4;
                }
                this.valid = false;
                this.adjustElementItemCountBy(n3);
                this.invalidateFloatersInRange(n2, this.lines[--n4].end);
                this.notifyResponsiblesInRange(document, n, n2, n3);
                return;
            }
            case 13: {
                this.notifyResponsiblesInRange(document, n, n2, n3);
                int n10 = n2 & 0x7FFF0000;
                if ((this.ds.selStart & 0x7FFF0000) == n10 && this.ds.selStart > n2) {
                    this.ds.selStart -= n3;
                }
                if ((this.ds.selEnd & 0x7FFF0000) == n10 && this.ds.selEnd > n2) {
                    this.ds.selEnd -= n3;
                }
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    if (docLine.start <= n2) {
                        this.invalidateFloatersInRange(docLine.start, docLine.end);
                        docLine.updated = true;
                    }
                    if ((docLine.start & 0x7FFF0000) == n10 && docLine.start > n2) {
                        docLine.start -= n3;
                    }
                    if ((docLine.end & 0x7FFF0000) == n10 && docLine.end > n2) {
                        docLine.end -= n3;
                    }
                    if ((docLine.tail & 0x7FFF0000) == n10 && docLine.tail > n2) {
                        docLine.tail -= n3;
                    }
                    ++n4;
                }
                this.valid = false;
                this.adjustElementItemCountBy(-n3);
                return;
            }
            case 15: {
                if (this.ds.selStart > n2) {
                    this.ds.selStart += n3;
                }
                if (this.ds.selEnd >= n2) {
                    this.ds.selEnd += n3;
                }
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    if (docLine.start > n2) break;
                    if (docLine.end >= n2) {
                        docLine.end += n3;
                    }
                    docLine.tail += n3;
                    docLine.updated = true;
                    ++n4;
                }
                int n11 = n4;
                while (n11 < this.nlines) {
                    DocLine docLine = this.lines[n11];
                    docLine.start += n3;
                    docLine.end += n3;
                    docLine.tail += n3;
                    ++n11;
                }
                this.valid = false;
                this.adjustElementItemCountBy(n3);
                if (this.nlines > 0) {
                    this.invalidateFloatersInRange(n2, this.lines[this.nlines - 1].end);
                }
                this.notifyResponsiblesInRange(document, n, n2, n3);
                return;
            }
            case 16: {
                DocLine docLine;
                int n12 = n2 + n3;
                this.notifyResponsiblesInRange(document, n, n2, n3);
                this.removeFloatersInRange(n2, n12);
                if (this.ds.selStart > n2) {
                    this.ds.selStart -= n3;
                }
                if (this.ds.selEnd > n2) {
                    this.ds.selEnd -= n3;
                }
                if (n4 < this.nlines) {
                    docLine = this.lines[n4];
                    if (docLine.start < n2) {
                        if (docLine.end > n2) {
                            docLine.end = n2;
                        }
                        docLine.tail = n2;
                        docLine.updated = true;
                        ++n4;
                    }
                }
                while (n4 < this.nlines) {
                    docLine = this.lines[n4];
                    if (docLine.tail > n12) {
                        if (docLine.start >= n12) break;
                        docLine.start = n2;
                        docLine.end = docLine.end <= n12 ? n2 : (docLine.end -= n3);
                        docLine.tail -= n3;
                        docLine.updated = true;
                        ++n4;
                        break;
                    }
                    docLine.end = docLine.tail = n2;
                    docLine.start = docLine.tail;
                    docLine.updated = true;
                    ++n4;
                }
                int n13 = n4;
                while (n13 < this.nlines) {
                    DocLine docLine2 = this.lines[n13];
                    docLine2.start -= n3;
                    docLine2.end -= n3;
                    docLine2.tail -= n3;
                    ++n13;
                }
                this.valid = false;
                this.adjustElementItemCountBy(-n3);
                return;
            }
            case 18: 
            case 19: {
                Graphics graphics;
                if (document.isOkToFormat() && (graphics = this.getGraphics()) != null) {
                    try {
                        this.paintRangeNoFloaters(graphics, n2, n2 + n3, n == 18);
                        this.paintFloatersInRange(graphics, n2, n2 + n3);
                        return;
                    }
                    finally {
                        Object var8_27 = null;
                        graphics.dispose();
                    }
                }
                return;
            }
            case 17: {
                int n14 = n2 + n3;
                int n15 = n4;
                boolean bl = false;
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    if (docLine.start >= n14) break;
                    docLine.updated = true;
                    bl = true;
                    ++n4;
                }
                while (n4 < this.nlines) {
                    if (this.lines[n4].y == this.lines[n15].y) {
                        this.lines[n4].updated = true;
                        bl = true;
                        n14 = this.lines[n4].end;
                    } else if (this.lines[n4].y > this.lines[n15].y) break;
                    ++n4;
                }
                this.notifyResponsiblesInRange(document, n, n2, n3);
                this.dirtyFloaterLines(new FormatState(), n2, n14);
                if (bl) {
                    this.requestReformat(true, 200);
                }
                return;
            }
            case 21: {
                int n16 = this.getStartIndex() + this.getNumItems() << 16;
                while (n2 < n16) {
                    this.notifyResponsiblesInRange(document, n, n2, n3);
                    DocItem docItem = document.items[n2 >> 16];
                    n4 = 0;
                    while (n4 < this.nItemComponents) {
                        Component component = this.itemComponents[n4].getComponent();
                        int n17 = this.itemComponents[n4].getIndex();
                        DocItem docItem2 = document.items[n17];
                        if (docItem2 == docItem) {
                            if (this.ds.started) {
                                ((DocPanel)((Object)component)).stop();
                            }
                            ((DocPanel)((Object)component)).destroy();
                            if (this.parent != null) {
                                this.parent.remove(component);
                            }
                            System.arraycopy(this.itemComponents, n4 + 1, this.itemComponents, n4, this.nItemComponents - n4 - 1);
                            this.itemComponents[this.nItemComponents - 1] = null;
                            --this.nItemComponents;
                            --n4;
                        }
                        ++n4;
                    }
                    this.deactivateItems();
                    n2 = docItem.getIndex() + docItem.getOffset() + 1 << 16;
                }
                return;
            }
        }
    }

    private void adjustElementItemCountBy(int n) {
    }

    public Color getFormatterBackgroundColor() {
        return this.myBackgroundColor;
    }

    public boolean isFormatterBackgroundColorDeliberate() {
        return this.myBackgroundColorIsDeliberate;
    }

    protected int getStartIndex() {
        return this.startIndex;
    }

    protected int getNumItems() {
        return this.startItem.getOffset() - 1;
    }

    protected int getMaxIndex() {
        return this.startIndex + this.startItem.getOffset() - 1;
    }

    public void getBackgroundDisplacement(Point point) {
        this.parent.getBackgroundDisplacement(point);
    }

    private void formatElement() {
        DocLine docLine;
        DocLine[] docLineArray = this.lines;
        int n = this.nlines;
        int n2 = 0;
        while (n2 < n && !docLineArray[n2].updated) {
            ++n2;
        }
        int n3 = this.getMaxIndex() << 16;
        int n4 = n2 > 0 ? docLineArray[n2 - 1].end : this.getStartIndex() << 16;
        int n5 = n2 > 0 ? docLineArray[n2 - 1].y + docLineArray[n2 - 1].height : 0;
        int n6 = n2;
        FormatState formatState = new FormatState();
        FormatState formatState2 = new FormatState();
        formatState.pos = this.getStartIndex() - 1 << 16;
        while (n4 < n3) {
            docLine = this.formatLine(n5, n4, formatState, formatState2);
            if (docLine == null) break;
            docLine.y = n5;
            n4 = docLine.end;
            n5 += docLine.height;
            int n7 = docLine.height;
            while (n6 < n && docLineArray[n6].end <= n4) {
                n7 -= docLineArray[n6].height;
                ++n6;
            }
            this.docHeight += n7;
            int n8 = (docLine.margin >> 16) + docLine.width;
            if (this.docWidth < n8) {
                this.docWidth = n8;
            }
            if (n6 == n2) {
                int n9 = 10;
                if (n + n9 > docLineArray.length) {
                    DocLine[] docLineArray2 = new DocLine[docLineArray.length + n9];
                    System.arraycopy(docLineArray, 0, docLineArray2, 0, n);
                    docLineArray = docLineArray2;
                }
                System.arraycopy(docLineArray, n6, docLineArray, n6 + n9, n - n6);
                n6 += n9;
                n += n9;
            }
            docLineArray[n2++] = docLine;
            if (n6 >= n || docLineArray[n6].updated || docLineArray[n6].start != n4 || docLineArray[n6].margin != formatState.margin) continue;
            do {
                docLine = docLineArray[n6++];
                this.updateFloatersYInRange(docLine.start, docLine.end, n5 - docLine.y);
                docLine.y = n5;
                n5 += docLine.height;
                docLineArray[n2++] = docLine;
            } while (n6 < n && !docLineArray[n6].updated);
            n4 = docLineArray[n6 - 1].end;
        }
        this.docHeight = this.adjustDocHeightForFloaters(this.docHeight);
        if (n6 < n && docLineArray[n6].y != n5) {
            this.updateFloatersYInRange(n4, n3, n5 - docLineArray[n6].y);
            do {
                docLine = docLineArray[n6++];
                docLine.y = n5;
                n5 += docLine.height;
                docLineArray[n2++] = docLine;
            } while (n6 < n);
        } else {
            System.arraycopy(docLineArray, n6, docLineArray, n2, n - n6);
        }
        this.nlines = n += n2 - n6;
        this.lines = docLineArray;
    }

    public void select(int n, int n2) {
        DocumentFormatter documentFormatter = this.getTopFormatter();
        documentFormatter.select(n, n2);
    }

    private final class FormatterMouseListener
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        public FormatterMouseListener() {
            TableElementFormatter.this = TableElementFormatter.this;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            TableElementFormatter.this.processMouseAction(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            TableElementFormatter.this.processMouseAction(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            TableElementFormatter.this.processMouseAction(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            TableElementFormatter.this.processMouseAction(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            TableElementFormatter.this.processMouseAction(mouseEvent);
        }
    }
}

