/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tags;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentState;
import sunw.hotjava.doc.Floatable;
import sunw.hotjava.doc.FlowTagItem;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.MeasureState;
import sunw.hotjava.doc.Measurement;
import sunw.hotjava.doc.PrintedLineInfo;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.Length;
import sunw.hotjava.tags.Align;
import sunw.hotjava.tags.OBJECT;
import sunw.hotjava.tags.TagAppletPanel;
import sunw.html.Attributes;

public class APPLET
extends FlowTagItem
implements Floatable {
    private static boolean lazyLoadingNotDone = true;
    int adjustedWidth = -1;
    int adjustedHeight = -1;
    Length width;
    Length height;
    int hspace;
    int vspace;
    int effHSpace;
    int effVSpace;
    int align;
    int border;
    OBJECT object;
    static Color borderColor = null;

    public APPLET() {
        if (lazyLoadingNotDone) {
            borderColor = Globals.getColor("applet.bordercolor", Color.lightGray);
            lazyLoadingNotDone = false;
        }
    }

    public synchronized void init(Document document) {
        this.atts = this.getAttributes();
        if (this.atts == null) {
            this.width = new Length(null);
            this.height = new Length(null);
            return;
        }
        this.width = new Length(this.atts.get("width"));
        this.height = new Length(this.atts.get("height"));
        if (this.width.isSet()) {
            if (!this.height.isSet()) {
                this.height = this.width;
            }
        } else if (this.height.isSet()) {
            this.width = this.height;
        } else {
            this.width = new Length("250");
            this.height = new Length("250");
        }
        this.hspace = TagItem.parseInt(this.atts, "hspace", 0, 0);
        this.effHSpace = this.hspace * 2;
        this.vspace = TagItem.parseInt(this.atts, "vspace", 0, 0);
        this.effVSpace = this.vspace * 2;
        this.border = TagItem.parseInt(this.atts, "border", 0, 0);
        this.align = Align.getAlign(this.atts);
    }

    public void init(Document document, OBJECT oBJECT) {
        this.object = oBJECT;
        this.init(document);
    }

    public int getOffset() {
        if (this.object == null) {
            return super.getOffset();
        }
        return this.object.getOffset();
    }

    public Attributes getAttributes() {
        if (this.object == null) {
            return super.getAttributes();
        }
        return this.object.getAttributes();
    }

    public int getIndex() {
        if (this.object == null) {
            return super.getIndex();
        }
        return this.object.getIndex();
    }

    public DocItem getObject() {
        if (this.object == null) {
            return this;
        }
        return this.object;
    }

    public void adjustDimension(int n, int n2) {
        this.adjustedWidth = n;
        this.adjustedHeight = n2;
    }

    public void adjustDimension() {
        this.adjustedWidth = -1;
        this.adjustedHeight = -1;
    }

    public int getWidthAttribute(Formatter formatter) {
        if (this.adjustedWidth != -1) {
            return this.adjustedWidth;
        }
        if (this.width.isPercentage()) {
            if (formatter == null) {
                return 0;
            }
            return (int)((double)formatter.getAvailableWidth() * ((double)this.width.getValue() / 100.0));
        }
        return this.width.getValue();
    }

    private int getWidth(Formatter formatter) {
        if (this.adjustedWidth != -1) {
            return this.adjustedWidth + this.effHSpace + this.border * 2;
        }
        TagAppletPanel tagAppletPanel = (TagAppletPanel)formatter.getPanel(this);
        if (tagAppletPanel == null || !tagAppletPanel.isActive()) {
            return this.getWidthAttribute(formatter) + this.effHSpace + this.border * 2;
        }
        int n = tagAppletPanel.size().width;
        if (n == 0) {
            return this.getWidthAttribute(formatter) + this.effHSpace + this.border * 2;
        }
        return n + this.effHSpace + this.border * 2;
    }

    public int getWidth(Formatter formatter, DocStyle docStyle) {
        return this.getWidth(formatter);
    }

    public int getHeightAttribute(Formatter formatter) {
        if (this.adjustedHeight != -1) {
            return this.adjustedHeight;
        }
        if (this.height.isPercentage()) {
            if (formatter == null) {
                return 0;
            }
            return (int)((double)formatter.getAvailableHeight() * ((double)this.height.getValue() / 100.0));
        }
        return this.height.getValue();
    }

    private int getHeight(Formatter formatter) {
        if (this.adjustedHeight != -1) {
            return this.adjustedHeight + this.effVSpace + this.border * 2;
        }
        TagAppletPanel tagAppletPanel = (TagAppletPanel)formatter.getPanel(this);
        if (tagAppletPanel == null || !tagAppletPanel.isActive()) {
            return this.getHeightAttribute(formatter) + this.effVSpace + this.border * 2;
        }
        int n = tagAppletPanel.size().height;
        if (n == 0) {
            return this.getHeightAttribute(formatter) + this.effVSpace + this.border * 2;
        }
        return n + this.effVSpace + this.border * 2;
    }

    public int getAscent(Formatter formatter, FormatState formatState) {
        return Align.getAscent(formatState, this.align, this.getHeight(formatter));
    }

    public int getDescent(Formatter formatter, FormatState formatState) {
        return Align.getDescent(formatState, this.align, this.getHeight(formatter));
    }

    public boolean needsActivation() {
        return true;
    }

    private boolean alignIsFloating() {
        return this.align == 7 || this.align == 8;
    }

    public boolean formatStartTag(Formatter formatter, FormatState formatState, FormatState formatState2) {
        if (formatState.state == 2) {
            return true;
        }
        if (this.alignIsFloating()) {
            boolean bl = false;
            if (!formatter.isFloater(this) && formatState.width + this.getWidth(formatter, formatState.style) > formatState.maxWidth) {
                if (formatState.startPos != formatState.pos) {
                    formatState.below += formatter.getCumulativeFloaterHeight(formatState.y);
                    return true;
                }
                bl = true;
            }
            formatter.queueFloater(formatter, formatState, this, this.getAscent(formatter, formatState) + this.getDescent(formatter, formatState), this.align == 7);
            formatState.pos += this.getOffset() << 16;
            return bl;
        }
        formatter.setBreak(formatState, formatState2, 0, formatState.width);
        formatState.state = 1;
        formatState.width += this.getWidth(formatter);
        formatState.ascent = Math.max(formatState.ascent, Math.max(formatState.style.ascent, this.getAscent(formatter, formatState)));
        formatState.descent = Math.max(formatState.descent, Math.max(formatState.style.descent, this.getDescent(formatter, formatState)));
        formatState.pos += this.getOffset() << 16;
        this.formatEndTag(formatter, formatState, formatState2);
        return false;
    }

    public boolean formatEndTag(Formatter formatter, FormatState formatState, FormatState formatState2) {
        formatState.pos += 65536;
        return false;
    }

    public int findStartTagX(DocLine docLine, DocStyle docStyle, int n, int n2, int n3, Formatter formatter) {
        DocumentState documentState = formatter.getDocumentState();
        if (documentState.tags) {
            return super.findStartTagX(docLine, docStyle, n, n2, n3, formatter);
        }
        int n4 = this.getWidth(formatter, docStyle);
        if ((n3 -= n) < n4 >> 1) {
            return n2;
        }
        if (n3 <= n4) {
            return n2 + 1;
        }
        return -n4 - 1;
    }

    public int findEndTagX(DocLine docLine, DocStyle docStyle, int n, int n2, int n3, Formatter formatter) {
        return -1;
    }

    public int paint(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        if (this.alignIsFloating()) {
            formatter.displayPos += this.getOffset() << 16;
            return 0;
        }
        int n3 = super.paint(formatter, graphics, n, n2 - 5, docLine);
        formatter.displayPos += this.getOffset() - 1 << 16;
        n3 += this.paintApplet(formatter, graphics, n + n3, n2, docLine);
        n3 += this.paintEndTag(formatter, graphics, n + n3, n2 - 5, docLine);
        formatter.displayStyle = formatter.displayStyle.next;
        return n3;
    }

    public int paint(Formatter formatter, Graphics graphics, int n, int n2) {
        return this.paintApplet(formatter, graphics, n, n2, null);
    }

    private int paintApplet(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        TagAppletPanel tagAppletPanel = (TagAppletPanel)formatter.getPanel(this.getObject());
        if (tagAppletPanel != null) {
            Serializable serializable;
            DocStyle docStyle = formatter.displayStyle;
            int n3 = this.getWidthAttribute(formatter);
            int n4 = this.getHeightAttribute(formatter);
            int n5 = n3 + this.border * 2;
            int n6 = n4 + this.border * 2;
            if (docLine != null) {
                n2 += Align.yOffset(docLine, docStyle, this.align, n6 + this.effVSpace);
            }
            if (this.border > 0) {
                serializable = graphics.getColor();
                Color color = formatter.getFormatterBackgroundColor();
                graphics.setColor(Globals.getVisible3DColor(color));
                int n7 = 0;
                while (n7 < this.border) {
                    graphics.draw3DRect(n + this.hspace, n2 + this.vspace, n5 - (n7 * 2 + 1), n6 - (n7 * 2 + 1), true);
                    ++n7;
                    ++n;
                    ++n2;
                }
                graphics.setColor((Color)serializable);
            }
            serializable = tagAppletPanel.bounds();
            if (((Rectangle)serializable).x != n + this.hspace || ((Rectangle)serializable).y != n2 + this.vspace || ((Rectangle)serializable).width != n3 || ((Rectangle)serializable).height != n4) {
                tagAppletPanel.reshape(n + this.hspace, n2 + this.vspace, n3, n4);
            }
            tagAppletPanel.validate();
            tagAppletPanel.show();
        }
        return this.getWidth(formatter);
    }

    public int print(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine, PrintedLineInfo printedLineInfo) {
        n2 += docLine.baseline - docLine.lnascent;
        formatter.displayPos += this.getOffset() << 16;
        int n3 = this.getWidth(formatter);
        int n4 = this.getHeight(formatter);
        graphics.setColor(Color.black);
        TagAppletPanel tagAppletPanel = (TagAppletPanel)formatter.getPanel(this);
        if (tagAppletPanel != null) {
            Graphics graphics2 = graphics.create(n + this.hspace, n2 + this.vspace, n3 - this.effHSpace, n4 - this.effVSpace);
            try {
                tagAppletPanel.print(graphics2);
            }
            finally {
                Object var12_11 = null;
                graphics2.dispose();
            }
        }
        return n3;
    }

    public int print(Formatter formatter, Graphics graphics, int n, int n2) {
        int n3 = this.getWidth(formatter);
        int n4 = this.getHeight(formatter);
        graphics.setColor(Color.black);
        TagAppletPanel tagAppletPanel = (TagAppletPanel)formatter.getPanel(this);
        if (tagAppletPanel != null) {
            Graphics graphics2 = graphics.create(n + this.hspace, n2 + this.vspace, n3 - this.effHSpace, n4 - this.effVSpace);
            try {
                tagAppletPanel.print(graphics2);
            }
            finally {
                Object var10_9 = null;
                graphics2.dispose();
            }
        }
        return n3;
    }

    public Component createView(Formatter formatter, Document document) {
        TagAppletPanel tagAppletPanel = new TagAppletPanel(document, this);
        formatter.dispatchDocumentEvent(1019, tagAppletPanel);
        Color color = formatter.getFormatterBackgroundColor();
        tagAppletPanel.setBackground(color);
        return tagAppletPanel;
    }

    public boolean measureStartTag(Formatter formatter, FormatState formatState, Measurement measurement, MeasureState measureState) {
        int n = this.getWidth(formatter);
        if (this.alignIsFloating()) {
            measurement.setFloaterMinWidth(n);
            measurement.setFloaterPreferredWidth(n);
        } else {
            measurement.setMinWidth(n);
            measurement.setPreferredWidth(n);
        }
        measureState.pos += this.getOffset() << 16;
        return false;
    }

    public boolean measureEndTag(Formatter formatter, FormatState formatState, Measurement measurement, MeasureState measureState) {
        measureState.pos += 65536;
        return false;
    }
}

