/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.Action;
import com.sun.java.swing.DefaultSingleSelectionModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JApplet;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLayeredPane;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.JSeparator;
import com.sun.java.swing.MenuElement;
import com.sun.java.swing.MenuSelectionManager;
import com.sun.java.swing.SingleSelectionModel;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.PopupMenuEvent;
import com.sun.java.swing.event.PopupMenuListener;
import com.sun.java.swing.plaf.PopupMenuUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class JPopupMenu
extends JComponent
implements Accessible,
MenuElement {
    transient Component invoker;
    transient Popup popup;
    transient Frame frame;
    private String label;
    private boolean paintBorder = true;
    private Insets margin;
    private int desiredLocationX;
    private int desiredLocationY;
    private int lastPopupType = 0;
    private static final Object heavyPopupCacheKey = new StringBuffer("JPopupMenu.heavyPopupCache");
    private static final Object lightPopupCacheKey = new StringBuffer("JPopupMenu.lightPopupCache");
    private static final Object mediumPopupCacheKey = new StringBuffer("JPopupMenu.mediumPopupCache");
    private static final Object defaultLWPopupEnabledKey = new StringBuffer("JPopupMenu.defaultLWPopupEnabledKey");
    private static final int MAX_CACHE_SIZE = 5;
    private transient MouseGrabber mouseGrabber;
    private boolean lightWeightPopupEnabled = true;
    private static final int LIGHT_WEIGHT_POPUP = 0;
    private static final int MEDIUM_WEIGHT_POPUP = 1;
    private static final int HEAVY_WEIGHT_POPUP = 2;
    private SingleSelectionModel selectionModel;
    static /* synthetic */ Class class$com$sun$java$swing$event$PopupMenuListener;

    public static void setDefaultLightWeightPopupEnabled(boolean bl) {
        SwingUtilities.appContextPut(defaultLWPopupEnabledKey, new Boolean(bl));
    }

    public static boolean getDefaultLightWeightPopupEnabled() {
        Boolean bl = (Boolean)SwingUtilities.appContextGet(defaultLWPopupEnabledKey);
        if (bl == null) {
            SwingUtilities.appContextPut(defaultLWPopupEnabledKey, Boolean.TRUE);
            return true;
        }
        return bl;
    }

    private static Hashtable getHeavyPopupCache() {
        Hashtable hashtable = (Hashtable)SwingUtilities.appContextGet(heavyPopupCacheKey);
        if (hashtable == null) {
            hashtable = new Hashtable(2);
            SwingUtilities.appContextPut(heavyPopupCacheKey, hashtable);
        }
        return hashtable;
    }

    private static Vector getLightPopupCache() {
        Vector vector = (Vector)SwingUtilities.appContextGet(lightPopupCacheKey);
        if (vector == null) {
            vector = new Vector();
            SwingUtilities.appContextPut(lightPopupCacheKey, vector);
        }
        return vector;
    }

    private static Vector getMediumPopupCache() {
        Vector vector = (Vector)SwingUtilities.appContextGet(mediumPopupCacheKey);
        if (vector == null) {
            vector = new Vector();
            SwingUtilities.appContextPut(mediumPopupCacheKey, vector);
        }
        return vector;
    }

    static synchronized void recycleHeavyPopup(Popup popup) {
        Vector vector;
        Frame frame = JPopupMenu.getFrame((Component)((Object)popup));
        Hashtable hashtable = JPopupMenu.getHeavyPopupCache();
        if (hashtable.containsKey(frame)) {
            vector = (Vector)hashtable.get(frame);
        } else {
            vector = new Vector();
            hashtable.put(frame, vector);
            frame.addWindowListener(new 1(frame));
        }
        if (vector.size() < 5) {
            vector.addElement(popup);
        }
    }

    static synchronized Popup getRecycledHeavyPopup(Frame frame) {
        Hashtable hashtable = JPopupMenu.getHeavyPopupCache();
        if (!hashtable.containsKey(frame)) {
            return null;
        }
        Vector vector = (Vector)hashtable.get(frame);
        int n = vector.size();
        if (n > 0) {
            Popup popup = (Popup)vector.elementAt(0);
            vector.removeElementAt(0);
            return popup;
        }
        return null;
    }

    static synchronized void recycleLightPopup(Popup popup) {
        Vector vector = JPopupMenu.getLightPopupCache();
        if (vector.size() < 5) {
            vector.addElement(popup);
        }
    }

    static synchronized Popup getRecycledLightPopup() {
        Vector vector = JPopupMenu.getLightPopupCache();
        int n = vector.size();
        if (n > 0) {
            Popup popup = (Popup)vector.elementAt(0);
            vector.removeElementAt(0);
            return popup;
        }
        return null;
    }

    static synchronized void recycleMediumPopup(Popup popup) {
        Vector vector = JPopupMenu.getMediumPopupCache();
        if (vector.size() < 5) {
            vector.addElement(popup);
        }
    }

    static synchronized Popup getRecycledMediumPopup() {
        Vector vector = JPopupMenu.getMediumPopupCache();
        int n = vector.size();
        if (n > 0) {
            Popup popup = (Popup)vector.elementAt(0);
            vector.removeElementAt(0);
            return popup;
        }
        return null;
    }

    static void recyclePopup(Popup popup) {
        if (popup instanceof JPanelPopup) {
            JPopupMenu.recycleLightPopup(popup);
            return;
        }
        if (popup instanceof WindowPopup) {
            JPopupMenu.recycleHeavyPopup(popup);
            return;
        }
        if (popup instanceof PanelPopup) {
            JPopupMenu.recycleMediumPopup(popup);
        }
    }

    public JPopupMenu() {
        this(null);
    }

    public JPopupMenu(String string) {
        this.label = string;
        this.setLayout(new GridBagLayout());
        this.lightWeightPopupEnabled = JPopupMenu.getDefaultLightWeightPopupEnabled();
        this.setSelectionModel(new DefaultSingleSelectionModel());
        this.addMouseListener(new 2());
        this.updateUI();
    }

    public PopupMenuUI getUI() {
        return (PopupMenuUI)this.ui;
    }

    public void setUI(PopupMenuUI popupMenuUI) {
        super.setUI(popupMenuUI);
    }

    public void updateUI() {
        this.setUI((PopupMenuUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "PopupMenuUI";
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SingleSelectionModel singleSelectionModel) {
        this.selectionModel = singleSelectionModel;
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.getComponentCount() + 1;
        super.add((Component)jMenuItem, gridBagConstraints);
        return jMenuItem;
    }

    public Component add(Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.getComponentCount() + 1;
        super.add(component, gridBagConstraints);
        return component;
    }

    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = new JMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setVerticalTextPosition(0);
        jMenuItem.setEnabled(action.isEnabled());
        jMenuItem.addActionListener(action);
        this.add(jMenuItem);
        PropertyChangeListener propertyChangeListener = this.createActionChangeListener(jMenuItem);
        action.addPropertyChangeListener(propertyChangeListener);
        return jMenuItem;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(jMenuItem);
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        String string2 = string;
        this.label = string;
        this.firePropertyChange("label", string2, string);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        this.invalidate();
        this.repaint();
    }

    public void addSeparator() {
        this.add(new JSeparator());
    }

    public void insert(Action action, int n) {
        throw new Error("void insert(Action, int) {} not yet implemented");
    }

    public void insert(Component component, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        int n2 = this.getComponentCount();
        Vector<Component> vector = new Vector<Component>();
        int n3 = n;
        while (n3 < n2) {
            vector.addElement(this.getComponent(n));
            this.remove(n);
            ++n3;
        }
        this.add(component);
        int n4 = 0;
        while (n4 < vector.size()) {
            this.add((Component)vector.elementAt(n4));
            ++n4;
        }
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(class$com$sun$java$swing$event$PopupMenuListener != null ? class$com$sun$java$swing$event$PopupMenuListener : (class$com$sun$java$swing$event$PopupMenuListener = JComponent.class$("com.sun.java.swing.event.PopupMenuListener")), popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$PopupMenuListener != null ? class$com$sun$java$swing$event$PopupMenuListener : (class$com$sun$java$swing$event$PopupMenuListener = JComponent.class$("com.sun.java.swing.event.PopupMenuListener")), popupMenuListener);
    }

    protected void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$PopupMenuListener != null ? class$com$sun$java$swing$event$PopupMenuListener : JComponent.class$("com.sun.java.swing.event.PopupMenuListener"))) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
            }
            n -= 2;
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$PopupMenuListener != null ? class$com$sun$java$swing$event$PopupMenuListener : JComponent.class$("com.sun.java.swing.event.PopupMenuListener"))) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n + 1]).popupMenuWillBecomeInvisible(popupMenuEvent);
            }
            n -= 2;
        }
    }

    protected void firePopupMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$PopupMenuListener != null ? class$com$sun$java$swing$event$PopupMenuListener : JComponent.class$("com.sun.java.swing.event.PopupMenuListener"))) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n + 1]).popupMenuCanceled(popupMenuEvent);
            }
            n -= 2;
        }
    }

    public void pack() {
        if (this.popup != null) {
            this.popup.pack();
        }
    }

    private Popup createLightWeightPopup() {
        Popup popup = JPopupMenu.getRecycledLightPopup();
        if (popup == null) {
            popup = new JPanelPopup();
        }
        return popup;
    }

    private Popup createMediumWeightPopup() {
        Popup popup = JPopupMenu.getRecycledMediumPopup();
        if (popup == null) {
            popup = new PanelPopup();
        }
        return popup;
    }

    private Popup createHeavyWeightPopup() {
        Frame frame = JPopupMenu.getFrame(this.invoker);
        if (frame != null) {
            this.popup = JPopupMenu.getRecycledHeavyPopup(frame);
        } else {
            frame = new Frame();
        }
        if (this.popup == null) {
            this.popup = new WindowPopup(frame);
        }
        return this.popup;
    }

    private boolean popupFit(Rectangle rectangle) {
        if (this.invoker != null) {
            Container container = this.invoker.getParent();
            while (container != null) {
                if (container instanceof JFrame || container instanceof JDialog) {
                    return SwingUtilities.isRectangleContainingRectangle(container.getBounds(), rectangle);
                }
                if (container instanceof JApplet) {
                    Rectangle rectangle2 = container.getBounds();
                    Point point = container.getLocationOnScreen();
                    rectangle2.x = point.x;
                    rectangle2.y = point.y;
                    return SwingUtilities.isRectangleContainingRectangle(rectangle2, rectangle);
                }
                if (container instanceof Frame) {
                    return SwingUtilities.isRectangleContainingRectangle(container.getBounds(), rectangle);
                }
                container = container.getParent();
            }
        }
        return false;
    }

    private boolean ancestorIsDialog(Component component) {
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof Dialog) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    private void replacePopup(int n) {
        this.popup.removeComponent(this);
        JPopupMenu.recyclePopup(this.popup);
        switch (n) {
            case 0: {
                this.popup = this.createLightWeightPopup();
                break;
            }
            case 1: {
                this.popup = this.createMediumWeightPopup();
                break;
            }
            case 2: {
                this.popup = this.createHeavyWeightPopup();
                break;
            }
        }
        this.popup.setLocationOnScreen(this.desiredLocationX, this.desiredLocationY);
        this.popup.addComponent(this, "Center");
        this.invalidate();
        this.popup.setBackground(this.getBackground());
        this.popup.pack();
    }

    public void setVisible(boolean bl) {
        if (bl == this.isVisible()) {
            return;
        }
        if (!bl) {
            this.getSelectionModel().clearSelection();
            if (this.getRootPopupMenu() == this) {
                this.requestRemoveGrab(this.invoker);
            }
        } else if (this.isPopupMenu() && this.getSubElements().length > 0) {
            MenuElement[] menuElementArray = new MenuElement[]{this, this.getSubElements()[0]};
            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
        }
        if (bl) {
            boolean bl2 = this.ancestorIsDialog(this.invoker);
            this.firePopupMenuWillBecomeVisible();
            switch (this.lastPopupType) {
                case 0: {
                    this.popup = this.createLightWeightPopup();
                    break;
                }
                case 1: {
                    this.popup = this.createMediumWeightPopup();
                    break;
                }
                case 2: {
                    this.popup = this.createHeavyWeightPopup();
                    break;
                }
            }
            int n = this.lastPopupType;
            this.popup.setLocationOnScreen(this.desiredLocationX, this.desiredLocationY);
            this.popup.addComponent(this, "Center");
            this.popup.setBackground(this.getBackground());
            this.popup.pack();
            Rectangle rectangle = new Rectangle(this.desiredLocationX, this.desiredLocationY, this.popup.getWidth(), this.popup.getHeight());
            int n2 = this.popupFit(rectangle) ? (this.lightWeightPopupEnabled ? 0 : 1) : (bl2 ? 1 : 2);
            if (n2 != n) {
                this.replacePopup(n2);
                n = n2;
            }
            this.lastPopupType = n;
            this.popup.show(this.invoker);
            if (this.getRootPopupMenu() == this) {
                this.requestAddGrab(this.invoker, this.popup);
                return;
            }
        } else if (this.popup != null) {
            this.firePopupMenuWillBecomeInvisible();
            this.popup.hide();
            this.popup.removeComponent(this);
            JPopupMenu.recyclePopup(this.popup);
            this.popup = null;
        }
    }

    public boolean isVisible() {
        if (this.popup != null) {
            return this.popup.isShowing();
        }
        return false;
    }

    public void setLocation(int n, int n2) {
        if (this.popup != null) {
            this.popup.setLocationOnScreen(n, n2);
            return;
        }
        this.desiredLocationX = n;
        this.desiredLocationY = n2;
    }

    private boolean isPopupMenu() {
        return this.invoker != null && !(this.invoker instanceof JMenu);
    }

    public Component getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Component component) {
        Component component2 = this.invoker;
        this.invoker = component;
        if (component2 != this.invoker && this.ui != null) {
            this.ui.uninstallUI(this);
            this.ui.installUI(this);
        }
        this.invalidate();
    }

    public void show(Component component, int n, int n2) {
        this.setInvoker(component);
        Frame frame = JPopupMenu.getFrame(component);
        if (frame != this.frame && frame != null) {
            this.frame = frame;
            if (this.popup != null) {
                this.setVisible(false);
            }
        }
        Point point = component.getLocationOnScreen();
        this.setLocation(point.x + n, point.y + n2);
        this.setVisible(true);
    }

    JPopupMenu getRootPopupMenu() {
        JPopupMenu jPopupMenu = this;
        while (jPopupMenu != null && !jPopupMenu.isPopupMenu() && jPopupMenu.getInvoker() != null && jPopupMenu.getInvoker().getParent() != null && jPopupMenu.getInvoker().getParent() instanceof JPopupMenu) {
            jPopupMenu = (JPopupMenu)jPopupMenu.getInvoker().getParent();
        }
        return jPopupMenu;
    }

    public int getComponentIndex(Component component) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = componentArray[n2];
            if (component2 == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Component getComponentAtIndex(int n) {
        int n2 = this.getComponentCount();
        if (n <= n2) {
            Component[] componentArray = this.getComponents();
            return componentArray[n];
        }
        return null;
    }

    public void setPopupSize(Dimension dimension) {
        this.popup.setSize(dimension.width, dimension.height);
    }

    public void setPopupSize(int n, int n2) {
        this.popup.setSize(n, n2);
    }

    public void setSelected(Component component) {
        SingleSelectionModel singleSelectionModel = this.getSelectionModel();
        int n = this.getComponentIndex(component);
        singleSelectionModel.setSelectedIndex(n);
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        this.paintBorder = bl;
        this.repaint();
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    boolean isSubPopupMenu(JPopupMenu jPopupMenu) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof JMenu) {
                JMenu jMenu = (JMenu)component;
                JPopupMenu jPopupMenu2 = jMenu.getPopupMenu();
                if (jPopupMenu2 == jPopupMenu) {
                    return true;
                }
                if (jPopupMenu2.isSubPopupMenu(jPopupMenu)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private static Window getWindow(Component component) {
        Component component2 = component;
        while (!(component2 instanceof Window) && component2 != null) {
            component2 = component2.getParent();
        }
        return (Window)component2;
    }

    private static Frame getFrame(Component component) {
        Component component2 = component;
        while (!(component2 instanceof Frame) && component2 != null) {
            component2 = component2.getParent();
        }
        return (Frame)component2;
    }

    private void requestAddGrab(Component component, Popup popup) {
        if (this.mouseGrabber == null) {
            this.mouseGrabber = new MouseGrabber(this);
        }
        Window window = JPopupMenu.getWindow(component);
        this.mouseGrabber.grabContainer(window, popup.getComponent());
    }

    private void requestRemoveGrab(Component component) {
        if (this.mouseGrabber != null) {
            this.mouseGrabber.ungrabContainers();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPopupMenu();
        }
        return this.accessibleContext;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.invoker != null && this.invoker instanceof Serializable) {
            vector.addElement("invoker");
            vector.addElement(this.invoker);
        }
        if (this.popup != null && this.popup instanceof Serializable) {
            vector.addElement("popup");
            vector.addElement(this.popup);
        }
        if (this.frame != null && this.frame instanceof Serializable) {
            vector.addElement("frame");
            vector.addElement(this.frame);
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("invoker")) {
            this.invoker = (Component)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("popup")) {
            this.popup = (Popup)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("frame")) {
            this.frame = (Frame)vector.elementAt(++n);
            ++n;
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void menuSelectionChanged(boolean bl) {
        if (this.invoker instanceof JMenu) {
            JMenu jMenu = (JMenu)this.invoker;
            if (bl) {
                jMenu.setPopupMenuVisible(true);
            } else {
                jMenu.setPopupMenuVisible(false);
            }
        }
        if (this.isPopupMenu() && !bl) {
            this.setVisible(false);
        }
    }

    public MenuElement[] getSubElements() {
        Vector<Component> vector = new Vector<Component>();
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getComponent(n2);
            if (component instanceof MenuElement) {
                vector.addElement(component);
            }
            ++n2;
        }
        MenuElement[] menuElementArray = new MenuElement[vector.size()];
        n2 = 0;
        n = vector.size();
        while (n2 < n) {
            menuElementArray[n2] = (MenuElement)vector.elementAt(n2);
            ++n2;
        }
        return menuElementArray;
    }

    public Component getComponent() {
        return this;
    }

    private static final class 1
    extends WindowAdapter {
        private final /* synthetic */ Frame val$f;

        public void windowClosed(WindowEvent windowEvent) {
            Hashtable hashtable = JPopupMenu.getHeavyPopupCache();
            hashtable.remove(this.val$f);
        }

        /* synthetic */ 1(Frame frame) {
            this.val$f = frame;
        }
    }

    private final class 2
    extends MouseAdapter {
        /* synthetic */ 2() {
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem jMenuItem) {
            JPopupMenu.this = JPopupMenu.this;
            this.menuItem = jMenuItem;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
                return;
            }
            if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl);
            }
        }
    }

    private static class MouseGrabber
    implements MouseListener,
    MouseMotionListener,
    WindowListener,
    ComponentListener {
        JPopupMenu popupMenu;
        Vector grabbed = new Vector();

        public MouseGrabber(JPopupMenu jPopupMenu) {
            this.popupMenu = jPopupMenu;
        }

        void cancelPopupMenu() {
            this.popupMenu.firePopupMenuCanceled();
            this.popupMenu.setVisible(false);
        }

        void grabContainer(Container container, Component component) {
            if (container == component) {
                return;
            }
            if (container instanceof Window) {
                ((Window)container).addWindowListener(this);
                ((Window)container).addComponentListener(this);
                this.grabbed.addElement(container);
            }
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = container.getComponentCount();
                Component[] componentArray = container.getComponents();
                int n2 = 0;
                while (n2 < n) {
                    Component component2 = componentArray[n2];
                    if (component2.isVisible() && component2 != component) {
                        component2.addMouseListener(this);
                        component2.addMouseMotionListener(this);
                        this.grabbed.addElement(component2);
                        if (component2 instanceof Container) {
                            Container container2 = (Container)component2;
                            this.grabContainer(container2, component);
                        }
                    }
                    ++n2;
                }
                return;
            }
        }

        void ungrabContainers() {
            int n = 0;
            int n2 = this.grabbed.size();
            while (n < n2) {
                Component component = (Component)this.grabbed.elementAt(n);
                if (component instanceof Window) {
                    ((Window)component).removeWindowListener(this);
                    ((Window)component).removeComponentListener(this);
                } else {
                    component.removeMouseListener(this);
                    component.removeMouseMotionListener(this);
                }
                ++n;
            }
            this.grabbed = new Vector();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (menuSelectionManager.isComponentPartOfCurrentMenu(this.popupMenu) && menuSelectionManager.isComponentPartOfCurrentMenu(component)) {
                return;
            }
            this.cancelPopupMenu();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowIconified(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }

    private interface Popup {
        public void setSize(int var1, int var2);

        public int getWidth();

        public int getHeight();

        public void addComponent(Component var1, Object var2);

        public void removeComponent(Component var1);

        public void pack();

        public void setBackground(Color var1);

        public void show(Component var1);

        public void hide();

        public boolean isShowing();

        public Rectangle getBoundsOnScreen();

        public void setLocationOnScreen(int var1, int var2);

        public Component getComponent();
    }

    class WindowPopup
    extends Window
    implements Popup,
    Serializable,
    Accessible {
        int saveX;
        int saveY;
        boolean firstShow = true;
        protected AccessibleContext accessibleContext;

        public WindowPopup(Frame frame) {
            super(frame);
            JPopupMenu.this = JPopupMenu.this;
        }

        public Component getComponent() {
            return this;
        }

        public int getWidth() {
            return this.getBounds().width;
        }

        public int getHeight() {
            return this.getBounds().height;
        }

        public void update(Graphics graphics) {
            ((Container)this).paint(graphics);
        }

        public void show(Component component) {
            ((Component)this).setLocation(this.saveX, this.saveY);
            ((Component)this).setVisible(true);
            if (this.firstShow) {
                this.hide();
                ((Component)this).setVisible(true);
                this.firstShow = false;
            }
        }

        public void hide() {
            super.hide();
            ((Container)this).removeNotify();
        }

        public Rectangle getBoundsOnScreen() {
            return this.getBounds();
        }

        public void setLocationOnScreen(int n, int n2) {
            ((Component)this).setLocation(n, n2);
            this.saveX = n;
            this.saveY = n2;
        }

        public void addComponent(Component component, Object object) {
            this.add(component, object);
        }

        public void removeComponent(Component component) {
            this.remove(component);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleWindowPopup();
            }
            return this.accessibleContext;
        }

        protected class AccessibleWindowPopup
        extends AccessibleContext
        implements Serializable,
        AccessibleComponent {
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.WINDOW;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet accessibleStateSet = SwingUtilities.getAccessibleStateSet(WindowPopup.this);
                if (WindowPopup.this.getFocusOwner() != null) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                return accessibleStateSet;
            }

            public Accessible getAccessibleParent() {
                Container container = WindowPopup.this.getParent();
                if (container instanceof Accessible) {
                    return (Accessible)((Object)container);
                }
                return null;
            }

            public int getAccessibleIndexInParent() {
                return SwingUtilities.getAccessibleIndexInParent(WindowPopup.this);
            }

            public int getAccessibleChildrenCount() {
                return SwingUtilities.getAccessibleChildrenCount(WindowPopup.this);
            }

            public Accessible getAccessibleChild(int n) {
                return SwingUtilities.getAccessibleChild(WindowPopup.this, n);
            }

            public Locale getLocale() {
                return WindowPopup.this.getLocale();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public Color getBackground() {
                return ((Component)WindowPopup.this).getBackground();
            }

            public void setBackground(Color color) {
                ((Component)WindowPopup.this).setBackground(color);
            }

            public Color getForeground() {
                return WindowPopup.this.getForeground();
            }

            public void setForeground(Color color) {
                WindowPopup.this.setForeground(color);
            }

            public Cursor getCursor() {
                return WindowPopup.this.getCursor();
            }

            public void setCursor(Cursor cursor) {
                ((Component)WindowPopup.this).setCursor(cursor);
            }

            public Font getFont() {
                return WindowPopup.this.getFont();
            }

            public void setFont(Font font) {
                ((Component)WindowPopup.this).setFont(font);
            }

            public FontMetrics getFontMetrics(Font font) {
                return WindowPopup.this.getFontMetrics(font);
            }

            public boolean isEnabled() {
                return WindowPopup.this.isEnabled();
            }

            public void setEnabled(boolean bl) {
                WindowPopup.this.setEnabled(bl);
            }

            public boolean isVisible() {
                return WindowPopup.this.isVisible();
            }

            public void setVisible(boolean bl) {
                ((Component)WindowPopup.this).setVisible(bl);
            }

            public boolean isShowing() {
                return WindowPopup.this.isShowing();
            }

            public boolean contains(Point point) {
                return WindowPopup.this.contains(point);
            }

            public Point getLocationOnScreen() {
                return WindowPopup.this.getLocationOnScreen();
            }

            public Point getLocation() {
                return WindowPopup.this.getLocation();
            }

            public void setLocation(Point point) {
                ((Component)WindowPopup.this).setLocation(point);
            }

            public Rectangle getBounds() {
                return WindowPopup.this.getBounds();
            }

            public void setBounds(Rectangle rectangle) {
                ((Component)WindowPopup.this).setBounds(rectangle);
            }

            public Dimension getSize() {
                return WindowPopup.this.getSize();
            }

            public void setSize(Dimension dimension) {
                ((Component)WindowPopup.this).setSize(dimension);
            }

            public Accessible getAccessibleAt(Point point) {
                return SwingUtilities.getAccessibleAt(WindowPopup.this, point);
            }

            public boolean isFocusTraversable() {
                return WindowPopup.this.isFocusTraversable();
            }

            public void requestFocus() {
                WindowPopup.this.requestFocus();
            }

            public void addFocusListener(FocusListener focusListener) {
                WindowPopup.this.addFocusListener(focusListener);
            }

            public void removeFocusListener(FocusListener focusListener) {
                WindowPopup.this.removeFocusListener(focusListener);
            }

            AccessibleWindowPopup() {
                WindowPopup.this = WindowPopup.this;
            }
        }
    }

    class JPanelPopup
    extends JPanel
    implements Popup,
    Serializable {
        int desiredLocationX;
        int desiredLocationY;

        public JPanelPopup() {
            JPopupMenu.this = JPopupMenu.this;
            this.setLayout(new BorderLayout());
            this.setDoubleBuffered(true);
            this.setOpaque(true);
        }

        public Component getComponent() {
            return this;
        }

        public void addComponent(Component component, Object object) {
            this.add(component, object);
        }

        public void removeComponent(Component component) {
            this.remove(component);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void pack() {
            this.setSize(this.getPreferredSize());
        }

        public void show(Component component) {
            Container container = component.getParent();
            Window window = null;
            Container container2 = container;
            while (container2 != null) {
                if (container2 instanceof JRootPane) {
                    container = ((JRootPane)container2).getLayeredPane();
                    container2 = container.getParent();
                    while (container2 != null && !(container2 instanceof Window)) {
                        container2 = container2.getParent();
                    }
                    window = (Window)container2;
                    break;
                }
                if (container2 instanceof Window) {
                    container = container2;
                    window = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            Point point = this.convertScreenLocationToParent(container, this.desiredLocationX, this.desiredLocationY);
            this.setLocation(point.x, point.y);
            if (container instanceof JLayeredPane) {
                ((JLayeredPane)container).add(this, JLayeredPane.POPUP_LAYER, 0);
                return;
            }
            container.add(this);
        }

        public void hide() {
            Container container = this.getParent();
            Rectangle rectangle = this.getBounds();
            if (container != null) {
                container.remove(this);
            }
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public Rectangle getBoundsOnScreen() {
            Container container = this.getParent();
            if (container != null) {
                Rectangle rectangle = this.getBounds();
                Point point = this.convertParentLocationToScreen(container, rectangle.x, rectangle.y);
                rectangle.x = point.x;
                rectangle.y = point.y;
                return rectangle;
            }
            throw new Error("getBoundsOnScreen called on an invisible popup");
        }

        Point convertParentLocationToScreen(Container container, int n, int n2) {
            Component component = null;
            Container container2 = this;
            while (container2 != null) {
                if (container2 instanceof Window) {
                    component = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            if (component != null) {
                Rectangle rectangle = component.getBounds();
                Point point = new Point(n, n2);
                point = SwingUtilities.convertPoint(container, point, null);
                point.x += rectangle.x;
                point.y += rectangle.y;
                return point;
            }
            throw new Error("convertParentLocationToScreen: no window ancestor found");
        }

        Point convertScreenLocationToParent(Container container, int n, int n2) {
            Window window = null;
            Container container2 = container;
            while (container2 != null) {
                if (container2 instanceof Window) {
                    window = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            if (window != null) {
                Point point = new Point(n, n2);
                SwingUtilities.convertPointFromScreen(point, container);
                return point;
            }
            throw new Error("convertScreenLocationToParent: no window ancestor found");
        }

        public void setLocationOnScreen(int n, int n2) {
            Container container = this.getParent();
            if (container != null) {
                Point point = this.convertScreenLocationToParent(container, n, n2);
                this.setLocation(point.x, point.y);
                return;
            }
            this.desiredLocationX = n;
            this.desiredLocationY = n2;
        }
    }

    class PanelPopup
    extends Panel
    implements Popup,
    Serializable {
        int desiredLocationX;
        int desiredLocationY;

        public PanelPopup() {
            JPopupMenu.this = JPopupMenu.this;
            this.setLayout(new BorderLayout());
        }

        public int getWidth() {
            return this.getBounds().width;
        }

        public int getHeight() {
            return this.getBounds().height;
        }

        public Component getComponent() {
            return this;
        }

        public void addComponent(Component component, Object object) {
            this.add(component, object);
        }

        public void removeComponent(Component component) {
            this.remove(component);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void pack() {
            this.setSize(this.getPreferredSize());
        }

        public void show(Component component) {
            Container container = component.getParent();
            Window window = null;
            Container container2 = container;
            while (container2 != null) {
                if (container2 instanceof JRootPane) {
                    container = ((JRootPane)container2).getLayeredPane();
                    container2 = container.getParent();
                    while (container2 != null && !(container2 instanceof Window)) {
                        container2 = container2.getParent();
                    }
                    window = (Window)container2;
                    break;
                }
                if (container2 instanceof Window) {
                    container = container2;
                    window = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            Point point = this.convertScreenLocationToParent(container, this.desiredLocationX, this.desiredLocationY);
            this.setLocation(point.x, point.y);
            if (container instanceof JLayeredPane) {
                ((JLayeredPane)container).add(this, JLayeredPane.POPUP_LAYER, 0);
                return;
            }
            container.add(this);
        }

        public void hide() {
            Container container = this.getParent();
            Rectangle rectangle = this.getBounds();
            if (container != null) {
                container.remove(this);
            }
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public Rectangle getBoundsOnScreen() {
            Container container = this.getParent();
            if (container != null) {
                Rectangle rectangle = this.getBounds();
                Point point = this.convertParentLocationToScreen(container, rectangle.x, rectangle.y);
                rectangle.x = point.x;
                rectangle.y = point.y;
                return rectangle;
            }
            throw new Error("getBoundsOnScreen called on an invisible popup");
        }

        Point convertParentLocationToScreen(Container container, int n, int n2) {
            Component component = null;
            Container container2 = this;
            while (container2 != null) {
                if (container2 instanceof Window) {
                    component = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            if (component != null) {
                Rectangle rectangle = component.getBounds();
                Point point = new Point(n, n2);
                point = SwingUtilities.convertPoint(container, point, null);
                point.x += rectangle.x;
                point.y += rectangle.y;
                return point;
            }
            throw new Error("convertParentLocationToScreen: no window ancestor found");
        }

        Point convertScreenLocationToParent(Container container, int n, int n2) {
            Window window = null;
            Container container2 = container;
            while (container2 != null) {
                if (container2 instanceof Window) {
                    window = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            if (window != null) {
                Point point = new Point(n, n2);
                SwingUtilities.convertPointFromScreen(point, container);
                return point;
            }
            throw new Error("convertScreenLocationToParent: no window ancestor found");
        }

        public void setLocationOnScreen(int n, int n2) {
            Container container = this.getParent();
            if (container != null) {
                Point point = this.convertScreenLocationToParent(container, n, n2);
                this.setLocation(point.x, point.y);
                return;
            }
            this.desiredLocationX = n;
            this.desiredLocationY = n2;
        }
    }

    protected class AccessibleJPopupMenu
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }

        AccessibleJPopupMenu() {
            JPopupMenu.this = JPopupMenu.this;
        }
    }
}

