/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.ToggleButtonUI;
import com.sun.java.swing.plaf.basic.BasicButtonListener;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;

public class BasicToggleButtonUI
extends ToggleButtonUI
implements Serializable {
    private static ToggleButtonUI toggleButtonUI;
    private static BasicButtonListener listener;
    private static final int defaultTextIconGap = 4;
    private static final Insets defaultMargin;
    protected static Color toggleButtonFocus;

    public static ComponentUI createUI(JComponent jComponent) {
        if (toggleButtonUI == null) {
            toggleButtonUI = new BasicToggleButtonUI();
        }
        return toggleButtonUI;
    }

    public Insets getDefaultMargin(AbstractButton abstractButton) {
        return defaultMargin;
    }

    public Border getDefaultBorder(AbstractButton abstractButton) {
        return UIManager.getBorder("ToggleButton.border");
    }

    public int getDefaultTextIconGap(AbstractButton abstractButton) {
        return 4;
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults(jComponent);
        this.installListeners(jComponent);
        this.installKeyboardActions(jComponent);
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "ToggleButton.background", "ToggleButton.foreground", "ToggleButton.font");
        LookAndFeel.installBorder(jComponent, "ToggleButton.border");
        toggleButtonFocus = UIManager.getColor("ToggleButton.focus");
    }

    protected void installListeners(JComponent jComponent) {
        listener = this.createListener(jComponent);
        if (listener != null) {
            jComponent.addMouseListener(listener);
            jComponent.addMouseMotionListener(listener);
            jComponent.addFocusListener(listener);
            ((AbstractButton)jComponent).addChangeListener(listener);
        }
    }

    protected void installKeyboardActions(JComponent jComponent) {
        listener.setupKeyboard((AbstractButton)jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions(jComponent);
        this.uninstallListeners(jComponent);
        this.uninstallDefaults(jComponent);
    }

    protected void uninstallKeyboardActions(JComponent jComponent) {
        jComponent.resetKeyboardActions();
    }

    protected void uninstallListeners(JComponent jComponent) {
        jComponent.removeMouseListener(listener);
        jComponent.removeMouseMotionListener(listener);
        jComponent.removeFocusListener(listener);
        ((AbstractButton)jComponent).removeChangeListener(listener);
    }

    protected void uninstallDefaults(JComponent jComponent) {
        LookAndFeel.uninstallBorder(jComponent);
    }

    protected BasicButtonListener createListener(JComponent jComponent) {
        return new BasicButtonListener((AbstractButton)jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Dimension dimension = abstractButton.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(dimension);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.right + rectangle.x;
        rectangle.height -= insets.bottom + rectangle.y;
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        String string = SwingUtilities.layoutCompoundLabel(fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, abstractButton.getText() == null ? 0 : 4);
        graphics.setColor(abstractButton.getBackground());
        if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, jComponent, rectangle2);
        }
        if (string != null && !string.equals("")) {
            this.paintText(graphics, jComponent, rectangle3, string);
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, rectangle, rectangle3, rectangle2);
        }
    }

    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = null;
        if (!buttonModel.isEnabled()) {
            icon = abstractButton.getDisabledIcon();
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon = abstractButton.getPressedIcon();
            if (icon == null) {
                icon = abstractButton.getSelectedIcon();
            }
        } else if (buttonModel.isSelected()) {
            icon = abstractButton.getSelectedIcon();
        } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            icon = abstractButton.getRolloverIcon();
        }
        if (icon == null) {
            icon = abstractButton.getIcon();
        }
        icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x, rectangle.y + fontMetrics.getAscent());
            return;
        }
        graphics.setColor(abstractButton.getBackground().brighter());
        BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x, rectangle.y + fontMetrics.getAscent());
        graphics.setColor(abstractButton.getBackground().darker());
        BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        return BasicGraphicsUtils.getPreferredButtonSize(abstractButton, 4);
    }

    static {
        defaultMargin = new Insets(2, 2, 2, 2);
    }
}

