/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.CellRendererPane;
import com.sun.java.swing.DefaultButtonModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JList;
import com.sun.java.swing.ListCellRenderer;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.metal.MetalLookAndFeel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

public class MetalComboBoxButton
extends JButton {
    protected JComboBox comboBox;
    protected JList listBox;
    protected CellRendererPane rendererPane;
    protected Icon comboIcon;
    protected boolean iconOnly = false;

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox jComboBox) {
        this.comboBox = jComboBox;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon icon) {
        this.comboIcon = icon;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean bl) {
        this.iconOnly = bl;
    }

    MetalComboBoxButton() {
        super("");
        1 var1_1 = new 1();
        this.setModel(var1_1);
    }

    public MetalComboBoxButton(JComboBox jComboBox, Icon icon, CellRendererPane cellRendererPane, JList jList) {
        this();
        this.comboBox = jComboBox;
        this.comboIcon = icon;
        this.rendererPane = cellRendererPane;
        this.listBox = jList;
    }

    public MetalComboBoxButton(JComboBox jComboBox, Icon icon, boolean bl, CellRendererPane cellRendererPane, JList jList) {
        this(jComboBox, icon, cellRendererPane, jList);
        this.iconOnly = bl;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        int n = this.getWidth() - (insets.left + insets.right);
        int n2 = this.getHeight() - (insets.top + insets.bottom);
        int n3 = insets.left;
        int n4 = insets.top;
        int n5 = n3 + (n - 1);
        int n6 = n4 + (n2 - 1);
        int n7 = 0;
        int n8 = n5;
        if (this.comboIcon != null) {
            n7 = this.comboIcon.getIconWidth();
            int n9 = this.comboIcon.getIconHeight();
            int n10 = 0;
            if (this.iconOnly) {
                n8 = this.getWidth() / 2 - n7 / 2;
                n10 = this.getHeight() / 2 - n9 / 2;
            } else {
                n8 = n3 + (n - 1) - n7;
                n10 = n4 + (n6 - n4) / 2 - n9 / 2;
            }
            this.comboIcon.paintIcon(this, graphics, n8, n10);
            if (this.hasFocus()) {
                graphics.setColor(MetalLookAndFeel.getFocusColor());
                graphics.drawRect(n3 - 1, n4 - 1, n + 3, n2 + 1);
            }
        }
        if (!this.iconOnly && this.comboBox != null) {
            ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
            boolean bl = this.getModel().isPressed();
            Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, bl, false);
            component.setFont(this.rendererPane.getFont());
            if (this.model.isArmed() && this.model.isPressed()) {
                if (this.isOpaque()) {
                    component.setBackground(UIManager.getColor("Button.pressed"));
                }
            } else {
                component.setBackground(this.comboBox.getBackground());
            }
            component.setForeground(this.comboBox.getForeground());
            int n11 = n - (insets.right + n7);
            this.rendererPane.paintComponent(graphics, component, this, n3, n4, n11, n2);
        }
    }

    private final class 1
    extends DefaultButtonModel {
        public void setArmed(boolean bl) {
            super.setArmed(this.isPressed() ? true : bl);
        }

        /* synthetic */ 1() {
        }
    }
}

