/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text.html;

import com.sun.java.swing.Icon;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.View;
import com.sun.java.swing.text.html.HTMLBoxView;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

class ListView
extends HTMLBoxView {
    private String type;
    private int start = 1;
    URL imageurl;
    Icon img;
    private int bulletgap = 5;
    protected static final char[][] romanChars = new char[][]{{'i', 'v'}, {'x', 'l'}, {'c', 'd'}, {'m', '?'}};

    public ListView(Element element) {
        super(element, 1);
        this.setParagraphInsets(element.getAttributes());
        AttributeSet attributeSet = element.getAttributes();
        if (attributeSet != null) {
            Object object;
            String string;
            String string2;
            String string3 = (String)attributeSet.getAttribute("-bullet-gap");
            if (string3 != null) {
                try {
                    this.bulletgap = Integer.valueOf(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.bulletgap = 5;
                }
            }
            if ((string2 = (String)attributeSet.getAttribute("list-style-image")) == null) {
                string2 = (String)attributeSet.getAttribute("list-style");
            }
            if (string2 == null) {
                this.type = null;
            } else if (string2.equalsIgnoreCase("none")) {
                this.type = new String("none");
            } else {
                try {
                    string = null;
                    object = new StringTokenizer(string2, "()");
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        string = ((StringTokenizer)object).nextToken();
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        string = ((StringTokenizer)object).nextToken();
                    }
                    URL uRL = new URL(string);
                    this.img = new ImageIcon(uRL);
                    this.type = new String("html-image");
                }
                catch (MalformedURLException malformedURLException) {
                    this.type = null;
                }
            }
            string = (String)attributeSet.getAttribute("type");
            if (string == null || string == "#DEFAULT") {
                if (this.type == null) {
                    object = element.getName();
                    if (object != null && ((String)object).equalsIgnoreCase("ol")) {
                        this.type = new String("1");
                    } else {
                        this.type = (String)attributeSet.getAttribute("list-style-type");
                        if (this.type == null || this.type == "#DEFAULT") {
                            this.type = (String)attributeSet.getAttribute("list-style");
                            if (this.type == null || this.type == "#DEFAULT") {
                                this.type = new String("disc");
                            }
                        }
                    }
                }
            } else {
                this.type = string;
            }
            if ((object = (String)attributeSet.getAttribute("start")) != null) {
                try {
                    this.start = Integer.valueOf((String)object);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
            }
        }
    }

    public float getAlignment(int n) {
        switch (n) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.5f;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    protected void paintChild(Graphics graphics, Rectangle rectangle, int n) {
        View view = this.getView(n);
        AttributeSet attributeSet = view.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute("type");
        if (string == null) {
            string = this.type;
        }
        if (string.equalsIgnoreCase("square")) {
            this.drawShape(graphics, string, rectangle.x, rectangle.y, rectangle.height, view.getAlignment(1));
        } else if (string.equalsIgnoreCase("circle")) {
            this.drawShape(graphics, string, rectangle.x, rectangle.y, rectangle.height, view.getAlignment(1));
        } else if (string.equalsIgnoreCase("1") || string.equalsIgnoreCase("decimal")) {
            this.drawLetter(graphics, '1', rectangle.x, rectangle.y, rectangle.height, n);
        } else if (string.equals("a") || string.equalsIgnoreCase("lower-alpha")) {
            this.drawLetter(graphics, 'a', rectangle.x, rectangle.y, rectangle.height, n);
        } else if (string.equals("A") || string.equalsIgnoreCase("upper-alpha")) {
            this.drawLetter(graphics, 'A', rectangle.x, rectangle.y, rectangle.height, n);
        } else if (string.equals("i") || string.equalsIgnoreCase("lower-roman")) {
            this.drawLetter(graphics, 'i', rectangle.x, rectangle.y, rectangle.height, n);
        } else if (string.equals("I") || string.equalsIgnoreCase("upper-roman")) {
            this.drawLetter(graphics, 'I', rectangle.x, rectangle.y, rectangle.height, n);
        } else if (string.equalsIgnoreCase("html-image")) {
            this.drawIcon(graphics, rectangle.x, rectangle.y, rectangle.height, view.getAlignment(1));
        } else if (!string.equals("none")) {
            this.drawShape(graphics, string, rectangle.x, rectangle.y, rectangle.height, view.getAlignment(1));
        }
        super.paintChild(graphics, rectangle, n);
    }

    protected void drawIcon(Graphics graphics, int n, int n2, int n3, float f) {
        graphics.setColor(Color.black);
        int n4 = n - this.img.getIconWidth() - this.bulletgap;
        int n5 = n2 + (int)((float)n3 * f) - 3;
        this.img.paintIcon(this.getContainer(), graphics, n4, n5);
    }

    protected void drawShape(Graphics graphics, String string, int n, int n2, int n3, float f) {
        graphics.setColor(Color.black);
        int n4 = n - this.bulletgap - 7;
        int n5 = n2 + (int)((float)n3 * f) - 3;
        if (string.equalsIgnoreCase("square")) {
            graphics.drawRect(n4, n5, 7, 7);
            return;
        }
        if (string.equalsIgnoreCase("circle")) {
            graphics.drawOval(n4, n5, 7, 7);
            return;
        }
        graphics.fillOval(n4, n5, 7, 7);
    }

    protected void drawLetter(Graphics graphics, char c, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.black);
        String string = String.valueOf(this.formatItemNum(n4 + this.start, c)) + ".";
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = n - n5 - this.bulletgap;
        int n7 = n2 + fontMetrics.getAscent() + fontMetrics.getLeading();
        graphics.drawString(string, n6, n7);
    }

    protected String formatItemNum(int n, char c) {
        String string;
        boolean bl = false;
        switch (c) {
            default: {
                string = String.valueOf(n);
                break;
            }
            case 'A': {
                bl = true;
            }
            case 'a': {
                string = this.formatAlphaNumerals(n);
                break;
            }
            case 'I': {
                bl = true;
            }
            case 'i': {
                string = this.formatRomanNumerals(n);
            }
        }
        if (bl) {
            string = string.toUpperCase();
        }
        return string;
    }

    protected String formatAlphaNumerals(int n) {
        String string = "";
        string = n > 26 ? String.valueOf(this.formatAlphaNumerals(n / 26)) + this.formatAlphaNumerals(n % 26) : String.valueOf((char)(97 + n - 1));
        return string;
    }

    protected String formatRomanNumerals(int n) {
        return this.formatRomanNumerals(0, n);
    }

    protected String formatRomanNumerals(int n, int n2) {
        if (n2 < 10) {
            return this.formatRomanDigit(n, n2);
        }
        return String.valueOf(this.formatRomanNumerals(n + 1, n2 / 10)) + this.formatRomanDigit(n, n2 % 10);
    }

    protected String formatRomanDigit(int n, int n2) {
        String string = "";
        if (n2 == 9) {
            string = String.valueOf(string) + romanChars[n][0];
            string = String.valueOf(string) + romanChars[n + 1][0];
            return string;
        }
        if (n2 == 4) {
            string = String.valueOf(string) + romanChars[n][0];
            string = String.valueOf(string) + romanChars[n][1];
            return string;
        }
        if (n2 >= 5) {
            string = String.valueOf(string) + romanChars[n][1];
            n2 -= 5;
        }
        int n3 = 0;
        while (n3 < n2) {
            string = String.valueOf(string) + romanChars[n][0];
            ++n3;
        }
        return string;
    }
}

