/* PGPCrack v0.5b
 * by Mark Miller <markm@voicenet.com>
 * A program that can crack PGP conventionally encrypted files.
 * Copyright (c) Mark Miller 1996
 * Feel free to distribute and modify this program.  Just please keep this
 * comment block on the code and make note of the modification.
 */

#include <stdio.h>
#include <string.h>
#include "md5.h"
#include "idea.h"

void chop(char *buf);
void hash(char *buf, char md5hash[16]);
int ctb_check(char *filename);
int ideacrack(char buf[10], char key[16]);

main(int argc, char *argv[])
{
 FILE *phrases;
 FILE *ideafile;
 FILE *log;
 char md5hash[16];
 char data[256];
 char textbuf[10];
 char buf[15];
 int ctb_return;
 int idea_return;
 int count;
 if(argc < 3) {
      fprintf(stderr, "Usage: %s [phraselist] [pgpfile] <logfile>\n", argv[0]);
      exit(1);
 }
/* Open passphrase list */
 if((phrases=fopen(argv[1], "r"))==NULL) {
      fprintf(stderr, "%s: Cannot open %s\n", argv[0], argv[1]);
      fclose(phrases);
      exit(2);
 }
 ctb_return = ctb_check(argv[2]);
 switch(ctb_return)
 {
  case(-1) : { fprintf(stderr, "%s: Cannot open %s\n", argv[0], argv[2]);
               exit(3); }
  case(1)  : { fprintf(stderr, "%s: %s is a secret key\n", argv[0], argv[2]);
               exit(4); }
  case(2)  : { fprintf(stderr, "%s: %s is not a PGP file\n", argv[0], argv[2]);
               exit(5); }
  case(3)  : { fprintf(stderr, "%s: %s is not conventionally encrypted\n", argv[0], argv[2]);
               exit(6); }
  default  : { break;   }
 }
/* Open a file to which to write the cracked passphrase.  If none is specified,
 * use stderr.
 */
 if(argv[3]) {
      if((log=fopen(argv[3], "w"))==NULL) {
           printf("%s: Cannot open logfile %s\n", argv[0], argv[3]);
           exit(7);
      }
 } else {
      log=stderr;
 }
 ideafile=fopen(argv[2], "r");
 fread(buf, 1, 15, ideafile);
 fclose(ideafile);
 for(count = 0; count < 10; count++)
      textbuf[count] = buf[count+5];
 while((fgets(data, 257, phrases))!=NULL) {
      chop(data);
      hash(data, md5hash);
      idea_return = ideacrack(textbuf, md5hash);
      if(idea_return == 0) {
           fprintf(log, "PGPCrack passphrase: %s\n", data);
           break;
      }
 }
 fclose(phrases);
 exit(0);
}

/* This function is roughly equivalent to the chop() function in Perl.  Only
 * this chops off the last byte of the character array only if it is a UNIX
 * '\n' character (0x10).  This is why the passphrase list must be in UNIX
 * text format.
 */
void chop(char *buf)
{
 int i;
 int j;
 i = strlen(buf);
 j = buf[i-1];
 if (j==10)
 {
  buf[i-1] = 0;
 }
}

void hash(char *buf, char md5hash[16])
{
 MD5_CTX md5;
 MD5Init(&md5);
 MD5Update(&md5, buf, strlen(buf));
 MD5Final(md5hash, &md5);
 md5hash[16] = 0;
}

/* Check to make sure that the file is in PGP format. */
int ctb_check(char *filename)
{
 FILE *pgp;
 char s;
 int i;
 if((pgp=fopen(filename, "r"))==NULL)
 {
  return -1;
 }
 fread(&s, 1, 1, pgp);
 fclose(pgp);
 i = (int)s;
 if(i & 0x80)
 {
  if((i & 0x24)==36)
  {
   return 0;
  }
  else if((i & 0x14)==20)
  {
   return 1;
  }
  else
  {
   return 3;
  }
 }
 return 2;
}

int ideacrack(char buf[10], char key[16])
{
 struct IdeaCfbContext ctx; 
 char plainbuf[10];
 ideaCfbInit(&ctx, key); 
 ideaCfbDecrypt(&ctx, buf, plainbuf, 10);
 if((plainbuf[6] == plainbuf[8]) && (plainbuf[7] == plainbuf[9]))
      return 0;
 return 1;
}
