/*
This code is copyright (C) 1998 Robert O'Callahan.
This code is free for non-commercial use. Modification in all forms is permitted.
This license continues to apply to any modified versions. This license text must be
reproduced and distributed with any modified versions.
As a matter of courtesy I (Robert O'Callahan) would like to be informed of
any potentially useful modifications.
*/

#ifndef __UTIL_H
#define __UTIL_H

typedef unsigned long uint32;
typedef unsigned short uint16;

#define NUM_ELEM(a) (sizeof(a) / sizeof((a)[0]))

#define buf_create(buf, len) (*(buf) = 0, *(len) = 0)

#define buf_ensure_size(buf, len, desired) \
  (*(len) < (desired) ? (*(buf) = realloc(*(buf), (desired)), *(len) = (desired)) : *(len))

#define buf_destroy(buf, len) (free(*(buf)), *(buf) = 0, *(len) = 0)

#define get_uint32_MSBfirst(buf) \
  (((uint32)(unsigned char)(buf)[0] << 24) + ((uint32)(unsigned char)(buf)[1] << 16) + \
  ((uint32)(unsigned char)(buf)[2] << 8) + (uint32)(unsigned char)(buf)[3])

#define get_ushort16_MSBfirst(buf) \
  (((uint32)(unsigned char)(buf)[0] << 8) + (uint32)(unsigned char)(buf)[1])

#define set_ushort16_MSBfirst(buf, v) \
  ((buf)[0] = (unsigned char)((uint16)(v) >> 8),     \
   (buf)[1] = (unsigned char)(uint16)(v))

#define set_uint32_MSBfirst(buf, v) \
  ((buf)[0] = (unsigned char)((uint32)(v) >> 24),     \
   (buf)[1] = (unsigned char)((uint32)(v) >> 16),     \
   (buf)[2] = (unsigned char)((uint32)(v) >> 8),      \
   (buf)[3] = (unsigned char)(uint32)(v))

#endif
