RCSID $Id: net.ipv4.af_inet.c,v 1.6 1999/11/18 04:15:51 rgb Exp $
--- ./net/ipv4/af_inet.c.preipsec	Wed Jun  3 18:17:50 1998
+++ ./net/ipv4/af_inet.c	Fri Sep 17 10:14:12 1999
@@ -51,6 +51,8 @@
  *		Mike McLagan	:	ADD/DEL DLCI Ioctls
  *	Willy Konynenberg	:	Transparent proxying support.
  *		David S. Miller	:	New socket lookup architecture for ISS.
+ *	Richard Guy Briggs	:	Added support for IPSEC (RFC2401) and PF_KEYv2 (RFC2367).
+ *
  *
  *		This program is free software; you can redistribute it and/or
  *		modify it under the terms of the GNU General Public License
@@ -108,6 +110,9 @@
 #ifdef CONFIG_NET_RADIO
 #include <linux/wireless.h>
 #endif	/* CONFIG_NET_RADIO */
+#ifdef CONFIG_IPSEC
+#include <../net/ipsec/ipsec_tunnel.h>
+#endif /* CONFIG_IPSEC */
 
 #define min(a,b)	((a)<(b)?(a):(b))
 
@@ -1146,6 +1151,14 @@
 	ip_alias_init();
 #endif
 
+#if defined(CONFIG_IPSEC)
+	/*
+	 *  Initialise AF_INET ESP and AH protocol support including 
+	 *  e-routing and SA tables
+	 */
+	ipsec_init();
+#endif /* CONFIG_IPSEC */
+
 #ifdef CONFIG_INET_RARP
 	rarp_ioctl_hook = rarp_ioctl;
 #endif
