/*
 *
			   IPSEC for Linux
		         Preliminary Release
 
	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 
		 LIMITED PRELIMINARY RELEASE LICENCE
 	
  Permission to copy, use, and distribute unmodified copies of this
  software without fee is hereby granted, provided that this entire
  notice is included in all copies.

  No modified copies may be distributed.

  [[ This restriction will, of course, change when the code becomes
  more stable. While you may of course still distribute context-diffs
  (or anything equivalent), I strongly urge you to send any changes
  you have directly to me. This will help the community by providing a
  reference base for the code. Thanks, /ji ]]
 
  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
  IMPLIED WARRANTY. IN PARTICULAR, NEITHER THE AUTHOR NOR ANYONE
  DISTRIBUTING THIS SOFTWARE MAKE ANY REPRESENTATION OR WARRANTY OF
  ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR ITS
  FITNESS FOR ANY PARTICULAR PURPOSE.
 
 *
 */

/*
 * $Id: ipsec_espdes.c,v 0.4 1997/01/15 01:28:15 ji Rel $
 *
 * $Log: ipsec_espdes.c,v $
 * Revision 0.4  1997/01/15 01:28:15  ji
 * Minor cosmetic changes.
 *
 * Revision 0.3  1996/11/20 14:35:48  ji
 * IV now increments with every packets.
 * Other minor cleanups.
 * Rationalized debugging code.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */

#include <linux/config.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/config.h>

#include <linux/socket.h>
#include <linux/sockios.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/icmp.h>
#include <linux/udp.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <net/sock.h>
#include <net/icmp.h>

#include <net/checksum.h>

#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/miscdevice.h>

#include <linux/skbuff.h>
#include <linux/proc_fs.h>
#include <linux/stat.h>

#include <net/netlink.h>
#include <unistd.h>
#include "radij.h"
#include "ipsec_encap.h"
#include "ipsec_radij.h"
#include "ipsec_netlink.h"
#include "ipsec_xform.h"
#ifdef CONFIG_IPSEC_AH
#include "ipsec_ah.h"
#endif
#ifdef CONFIG_IPSEC_ESP
#include "ipsec_esp.h"
#endif

extern void des_cbc_encrypt(caddr_t, caddr_t, int, caddr_t, caddr_t, int);
extern void des_set_key(caddr_t, caddr_t);

#ifdef DEBUG_IPSEC_ESP
static void
print_ip_pkt(struct iphdr *ip)
{
	int i, len;
	unsigned char *d = (unsigned char *)ip;
	len = ntohs(ip->tot_len);
	
	printk("packet length: %d", len);
	for (i = 0; i < len; i++)
		printk(" %02x", d[i]);
	printk("\n");
}

#ifdef NOLONGER_DEBUG_IPSEC_ESP	
static void
print_ip(struct iphdr *ip)
{
	unsigned char *ipaddr;

	printk("IP packet:\n");
	printk("--- header len = %d\n", ip->ihl*4);
	printk("--- ip version: %d\n", ip->version);
	printk("--- ip protocol: %d\n", ip->protocol);
	ipaddr=(unsigned char *)&ip->saddr;
	printk("--- source address: %u.%u.%u.%u\n", 
			*ipaddr, *(ipaddr+1), *(ipaddr+2), *(ipaddr+3));
	ipaddr=(unsigned char *)&ip->daddr;
	printk("--- destination address: %u.%u.%u.%u\n", 
			*ipaddr, *(ipaddr+1), *(ipaddr+2), *(ipaddr+3));
	printk("--- total packet len: %d\n", ntohs(ip->tot_len));
}
#endif
#endif

struct sk_buff *
espdes_input(struct sk_buff *skb, struct tdb *tdbp)
{
	struct iphdr *ipp;
	struct espdes_xdata *xd;
	struct esp *espp;
	int iphlen, esphlen, proto, len, pad, ilen;
	unsigned char *dat, *idat;
	unsigned char iv[8];
	
	len = skb->len; dat = skb->data;

	ipp = (struct iphdr *)dat;
	iphlen = ipp->ihl << 2;
	espp = (struct esp *)(dat + iphlen);
	
	xd = (struct espdes_xdata *)tdbp->tdb_xdata;

	esphlen = 8;			/* spi + iv32 */

	iv[0] = espp->esp_iv[0];
	iv[1] = espp->esp_iv[1];
	iv[2] = espp->esp_iv[2];
	iv[3] = espp->esp_iv[3];
	if (xd->edx_ivlen == 4)
	{
		iv[4] = ~iv[0];
		iv[5] = ~iv[1];
		iv[6] = ~iv[2];
		iv[7] = ~iv[3];
	}
	else
	{
		iv[4] = espp->esp_iv[4];
		iv[5] = espp->esp_iv[5];
		iv[6] = espp->esp_iv[6];
		iv[7] = espp->esp_iv[7];

		esphlen += 4;		/* was iv64 after all */
	}

	idat = dat + iphlen + esphlen;
	ilen = len - iphlen - esphlen;

	if (ilen % 8)
	{
		printk("ipsec_espdes: got packet with ilen = %d \n", ilen);
		return NULL;
	}
	
	des_cbc_encrypt(idat, idat, ilen, (caddr_t)(xd->edx_eks), iv, 0);
	
	proto = idat[ilen - 1];
	pad = idat[ilen - 2] + 2;
	
#ifdef DEBUG_IPSEC_ESP
	if (debug_esp & DB_ES_IPAD)
	  printk("espdes_input: proto = %d, padding = %d\n", proto, pad);
#endif

	/*
	 *	Discard the original IP header
	 */
	 
	ipp->tot_len = htons(ntohs(ipp->tot_len) - esphlen - pad);
	ipp->protocol = proto;

	memmove((void *)(skb->data + esphlen), (void *)skb->data, iphlen);

	skb_pull(skb, esphlen);
	skb_trim(skb, len - esphlen - pad);

	/*
	 *	Adjust pointers
	 */
	 
	
	len = skb->len; dat = skb->data;
	

	skb->h.iph=(struct iphdr *)skb->data;
	skb->ip_hdr=(struct iphdr *)skb->data;

	memset(skb->proto_priv, 0, sizeof(struct options));
	
	ipp = (struct iphdr *)dat;
	ipp->check = 0;
	ipp->check = ip_fast_csum((unsigned char *)dat, iphlen >> 2);

	return skb;
}

int
espdes_attach(void)
{
	printk("espdes_attach: called.\n");
	return 0;
}

/*
 * espdes_init() is called when an SPI is being set up. It interprets the
 * encap_msghdr present in m, and sets up the transformation data.
 */

int
espdes_init(struct tdb *tdbp, struct xformsw *xsp, struct encap_msghdr *em)
{
	struct espdes_xdata *xd;
	u_long rk[2];
	
	tdbp->tdb_xform = xsp;

	tdbp->tdb_xdata = (caddr_t)kmalloc(sizeof (struct espdes_xdata), GFP_ATOMIC); /* XXX memory leak here if updating old TDB? */

	if (tdbp->tdb_xdata == NULL)
	  return ENOBUFS;
	memset(tdbp->tdb_xdata, 0, sizeof (struct espdes_xdata));
	xd = (struct espdes_xdata *)tdbp->tdb_xdata;

	if ((em->em_msglen - EMT_SETSPI_FLEN) != EMT_ESPDESCBC_ULEN)
	{
		kfree((caddr_t)tdbp->tdb_xdata);
		tdbp->tdb_xdata = NULL;
		return EINVAL;
	}
	
	memcpy((caddr_t)xd, em->em_dat, EMT_ESPDESCBC_ULEN);

	rk[0] = xd->edx_eks[0][0];	/* some overloading doesn't hurt */
	rk[1] = xd->edx_eks[0][1];	/* XXX -- raw-major order */

	des_set_key((caddr_t)rk, (caddr_t)(xd->edx_eks));

	return 0;
}



int
espdes_zeroize(void)
{
	return 0;
}

int
espdes_print(void *xdat, char *buf)
{
	int size;
	int i, ds;

	struct espdes_xdata *xd = (struct espdes_xdata *)xdat;
	size = sprintf(buf, "ivlen = %d, iv =", xd->edx_ivlen);
	buf += size;

	for (i = 0; i < xd->edx_ivlen; i++)
	{
		ds = sprintf(buf, " %02x", xd->edx_iv[i]);
		buf += ds;
		size += ds;
	}

#ifdef ESPPRINTKEYS
	ds = sprintf(buf, ", ks = ");
	buf += ds;
	size += ds;
	
	for (i = 8; i < 136; i++)
	{
		ds = sprintf(buf, " %02x", xd->edx_iv[i]);
		buf += ds;
		size += ds;
	}
#endif

	return size;
}

int
espdes_room(struct tdb *tp, int iphlen, int tlen, int *hr, int *tr)
{
	struct espdes_xdata *xd = (struct espdes_xdata *)(tp->tdb_xdata) ;
	
	*hr += xd->edx_ivlen + 4;
	*tr += ((8 - ((tlen + 2) % 8)) % 8) + 2;
	return 0;
}

int espdes_output(struct sk_buff *skb, struct tdb *tdbp)
{
	struct iphdr *ipp;
	struct espdes_xdata *xd;
	struct esp *espp;
	int iphlen, esphlen, hrm, trm, len, ilen;
	unsigned char *dat, *idat;
	unsigned char iv[8];
	
	ipp = (struct iphdr *)(skb->data);
#ifdef DEBUG_IPSEC_ESP
	if (debug_esp & DB_ES_OINFO)
	{
		printk("espdes_output: old header (headroom = %d, tailroom = %d\n", skb_headroom(skb), skb_tailroom(skb));
		print_ip_pkt(ipp);
	}

#endif	
	iphlen = ipp->ihl << 2;
	if (iphlen != sizeof (struct iphdr))
	{
		printk("espdes_output: cannot process options yet\n"); /* XXX */
		return -1;
	}

	xd = (struct espdes_xdata *)tdbp->tdb_xdata;

	hrm = xd->edx_ivlen + 4;
	trm = ((8 - ((skb->len - iphlen + 2) % 8)) % 8) + 2;

	dat = skb_push(skb, hrm);
	ilen = skb->len;
	len = ilen + trm;
	
#ifdef DEBUG_IPSEC_ESP
	if (debug_esp & DB_ES_OINFO2)
		printk("before skb_trim: %d,%d (need: %d,%d)", skb_headroom(skb), skb_tailroom(skb), hrm, trm);
#endif
	skb_put(skb, trm);
#ifdef DEBUG_IPSEC_ESP
	if (debug_esp & DB_ES_OINFO2)
		printk(" after skb_trim: %d,%d\n", skb_headroom(skb), skb_tailroom(skb));
#endif	
	memmove((void *)dat, (void *)(dat + hrm), iphlen);
	espp = (struct esp *)(dat + iphlen);
	ipp = (struct iphdr *)dat;

	if (ntohs(ipp->frag_off) & IP_OFFSET)
	{
		printk("espdes_output: attempted to encrypt fragment!\n");
		return -1;
	}

	espp->esp_spi = tdbp->tdb_spi;

	if (xd->edx_ivlen == 4)
	{
		esphlen = 8;
		xd->edx_ivl[0]++;		/* increment IV */
		iv[0] = espp->esp_iv[0] = xd->edx_iv[0];
		iv[1] = espp->esp_iv[1] = xd->edx_iv[1];
		iv[2] = espp->esp_iv[2] = xd->edx_iv[2];
		iv[3] = espp->esp_iv[3] = xd->edx_iv[3];
		iv[4] = ~iv[0];
		iv[5] = ~iv[1];
		iv[6] = ~iv[2];
		iv[7] = ~iv[3];
	}
	else
	{
		esphlen = 12;
		xd->edx_ivq++;		/* increment IV */
		iv[0] = espp->esp_iv[0] = xd->edx_iv[0];
		iv[1] = espp->esp_iv[1] = xd->edx_iv[1];
		iv[2] = espp->esp_iv[2] = xd->edx_iv[2];
		iv[3] = espp->esp_iv[3] = xd->edx_iv[3];
		iv[4] = espp->esp_iv[4] = xd->edx_iv[4];
		iv[5] = espp->esp_iv[5] = xd->edx_iv[5];
		iv[6] = espp->esp_iv[6] = xd->edx_iv[6];
		iv[7] = espp->esp_iv[7] = xd->edx_iv[7];
	}
	
	dat[len - 1] = ipp->protocol;
	dat[len - 2] = trm - 2;
	
	ipp->protocol		=	50;
	ipp->tot_len		=	htons(len);

	idat = dat + iphlen + esphlen;
	ilen = len - iphlen - esphlen;

#ifdef DEBUG_IPSEC_ESP
	if (debug_esp & DB_ES_OINFO)
		printk("encrypting %d bytes\n", ilen);
#endif	
	des_cbc_encrypt(idat, idat, ilen, (caddr_t)(xd->edx_eks), iv, 1);

	skb->ip_hdr = skb->h.iph = (struct iphdr *) skb->data;
	ipp->check = 0;
	ipp->check = ip_fast_csum((unsigned char *)ipp, ipp->ihl);

#ifdef DEBUG_IPSEC_ESP
	if (debug_esp & DB_ES_OH)
	{
		printk("espdes_output: new header (headroom = %d, tailroom = %d\n", skb_headroom(skb), skb_tailroom(skb));
		print_ip_pkt(ipp);
	}
#endif


	return 0;
}

