/*
 *
			   IPSEC for Linux
		         Preliminary Release
 
	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 
		 LIMITED PRELIMINARY RELEASE LICENCE
 	
  Permission to copy, use, and distribute unmodified copies of this
  software without fee is hereby granted, provided that this entire
  notice is included in all copies.

  No modified copies may be distributed.

  [[ This restriction will, of course, change when the code becomes
  more stable. While you may of course still distribute context-diffs
  (or anything equivalent), I strongly urge you to send any changes
  you have directly to me. This will help the community by providing a
  reference base for the code. Thanks, /ji ]]
 
  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
  IMPLIED WARRANTY. IN PARTICULAR, NEITHER THE AUTHOR NOR ANYONE
  DISTRIBUTING THIS SOFTWARE MAKE ANY REPRESENTATION OR WARRANTY OF
  ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR ITS
  FITNESS FOR ANY PARTICULAR PURPOSE.
 
 *
 */

/*
 * $Id: ipsec_init.c,v 0.4 1997/01/15 01:28:15 ji Rel $
 *
 * $Log: ipsec_init.c,v $
 * Revision 0.4  1997/01/15 01:28:15  ji
 * No changes.
 *
 * Revision 0.3  1996/11/20 14:39:04  ji
 * Fixed problem with node names of /proc/net entries.
 * Other minor cleanups.
 * Rationalized debugging code.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */

/*
 * Initialization code, and /proc file system interface code.
 */

#include <linux/module.h>
#include <linux/config.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/config.h>

#include <linux/socket.h>
#include <linux/sockios.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/icmp.h>
#include <linux/udp.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <net/sock.h>
#include <net/icmp.h>

#include <net/checksum.h>

#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/miscdevice.h>

#include <linux/skbuff.h>
#include <linux/proc_fs.h>
#include <linux/stat.h>

#include <net/netlink.h>
#include <unistd.h>
#include "radij.h"
#include "ipsec_encap.h"
#include "ipsec_radij.h"
#include "ipsec_netlink.h"
#include "ipsec_xform.h"
#include "ipsec_tunnel.h"

#ifdef CONFIG_IPSEC_AH
#include "ipsec_ah.h"
#endif

#ifdef CONFIG_IPSEC_ESP
#include "ipsec_esp.h"
#endif

#ifdef DEBUG_IPSEC_EROUTE
int debug_eroute = 0;
#endif

#ifdef DEBUG_IPSEC_SPI
int debug_spi = 0;
#endif

int
ipsec_rt_get_info(char *buffer, char **start, off_t offset, int length, int dummy)
{
	int len=0;
	off_t pos=0;
	int size = 0;

	/*
	 * XXX - Needs work. What happens when we have more than 3K
	 * characters worth of e-routing info to report?
	 */
	

#ifdef DEBUG_IPSEC_RADIJ
	if (debug_radij & DB_RJ_DUMPTREES)
	  rj_dumptrees();			/* XXXXXXXXX */
#endif

#ifdef DEBUG_IPSEC_EROUTE
	if (debug_eroute & DB_ER_PROCFS)
	  printk("ipsec_rt_get_info: buffer=0x%x, *start=0x%x, offset=%d, length=%d\n", (u_int)buffer, (u_int)*start, (int)offset, length);
#endif

	size = ipsec_walk(buffer);

	len += size;
	pos += size;
	*start = buffer+len-(pos-offset);	/* Start of wanted data */
	len = pos-offset;			/* Start slop */

	return len;
}

int
ipsec_spi_get_info(char *buffer, char **start, off_t offset, int length, int dummy)
{

	int len=0;
	off_t pos=0;
	int size=0, ds;
	int i;
	char *buf = buffer;
	struct tdb *tdbp;

	/*
	 * XXX - Needs work. What happens when we have more than 3K
	 * characters worth of spi info to report?
	 */

#ifdef DEBUG_IPSEC_SPI
	if (debug_spi & DB_SP_PROCFS)
	  printk("ipsec_spi_get_info: buffer=0x%x, *start=0x%x, offset=%d, length=%d\n", (u_int)buffer, (u_int)*start, (int)offset, length);
#endif

	for (i = 0; i < TDB_HASHMOD; i++)
		for (tdbp = tdbh[i]; tdbp; tdbp = tdbp->tdb_hnext)
		{
			ds = sprintf(buf, "(%d.%d.%d.%d, %08x, %d: ", 
					O4(tdbp->tdb_dst.s_addr),
					O3(tdbp->tdb_dst.s_addr),
					O2(tdbp->tdb_dst.s_addr),
					O1(tdbp->tdb_dst.s_addr),
					(u_int)ntohl(tdbp->tdb_spi),
					tdbp->tdb_xform->xf_type);
			buf += ds; size += ds;
			ds = tdbp->tdb_xform->xf_print(tdbp->tdb_xdata, buf);
			buf += ds; size += ds;
			ds = sprintf(buf, ")\n");
			buf += ds; size += ds;
		}
	
	len += size;
	pos += size;
	*start = buffer+len-(pos-offset);	/* Start of wanted data */
	len = pos-offset;			/* Start slop */

	return len;

}

static struct proc_dir_entry ipsec_rt =
{
	4242, 8, "ipsec-rt",
	S_IFREG | 0444, 1, 0, 0, 0,
	&proc_net_inode_operations,
	ipsec_rt_get_info,
	NULL, NULL, NULL, NULL, NULL
};

static struct proc_dir_entry ipsec_spi =
{
	4243, 9, "ipsec-spi",
	S_IFREG | 0444, 1, 0, 0, 0,
	&proc_net_inode_operations,
	ipsec_spi_get_info,
	NULL, NULL, NULL, NULL, NULL
};

void
ipsec_init(void)
{
	struct xformsw *xsp;

	proc_register(&proc_net, &ipsec_rt);
	proc_register(&proc_net, &ipsec_spi);
	
	(void)netlink_attach(NETLINK_IPSEC, ipsec_callback);

	ipsec_radijinit();

#ifdef CONFIG_IPSEC_AH
	inet_add_protocol(&ah_protocol);
#endif

#ifdef CONFIG_IPSEC_ESP
	inet_add_protocol(&esp_protocol);
#endif

	for (xsp = xformsw; xsp < xformswNXFORMSW; xsp++)
	{
		printk("ipsec_init: attaching <%s>\n", xsp->xf_name);
		(*(xsp->xf_attach))();
	}
}	


#ifdef MODULE
int init_module(void)
{
	ipsec_init();
	ipsec_tunnel_init_module();
	return 0;
}

void cleanup_module(void)
{
	if (proc_unregister(&proc_net, 4243) != 0)
		printk("ipsec: cannot unregister /proc/net/ipsec-spi\n");
	if (proc_unregister(&proc_net, 4242) != 0)
		printk("ipsec: cannot unregister /proc/net/ipsec-rt\n");
	
	netlink_detach(NETLINK_IPSEC);
#ifdef CONFIG_IPSEC_AH
	if ( inet_del_protocol(&ah_protocol) < 0 )
		printk(KERN_INFO "ah close: can't remove protocol\n");
#endif
}
#endif
