/*
 *
			   IPSEC for Linux
		         Preliminary Release
 
	    Copyright (C) 1996, John Ioannidis <ji@hol.gr>
 
		 LIMITED PRELIMINARY RELEASE LICENCE
 	
  Permission to copy, use, and distribute unmodified copies of this
  software without fee is hereby granted, provided that this entire
  notice is included in all copies.

  No modified copies may be distributed.

  [[ This restriction will, of course, change when the code becomes
  more stable. While you may of course still distribute context-diffs
  (or anything equivalent), I strongly urge you to send any changes
  you have directly to me. This will help the community by providing a
  reference base for the code. Thanks, /ji ]]
 
  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
  IMPLIED WARRANTY. IN PARTICULAR, NEITHER THE AUTHOR NOR ANYONE
  DISTRIBUTING THIS SOFTWARE MAKE ANY REPRESENTATION OR WARRANTY OF
  ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR ITS
  FITNESS FOR ANY PARTICULAR PURPOSE.
 
 *
 */

/*
 * $Id: spigrp.c,v 0.3 1996/11/20 14:51:32 ji Rel $
 *
 * $Log: spigrp.c,v $
 * Revision 0.3  1996/11/20 14:51:32  ji
 * Fixed problems with #include paths.
 * Changed (incorrect) references to ipsp into ipsec.
 *
 * Revision 0.2  1996/11/08 15:46:29  ji
 * First limited release.
 *
 *
 */

#include <sys/types.h>
#include <string.h>
#include <errno.h>

#include <sys/socket.h>
#include <linux/skbuff.h>

#include <netinet/in.h>
#include <arpa/inet.h>



#include <unistd.h>
#include "radij.h"
#include "ipsec_encap.h"
#include "ipsec_netlink.h"
#include "ipsec_ah.h"

#include <stdio.h>

u_long bigbuf[1024];

inline int x2i(char *s)
{
	char ss[3];
	ss[0] = s[0];
	ss[1] = s[1];
	ss[2] = 0;

	return strtol(ss, NULL, 16);
}
	

main(argc, argv)
int argc;
char **argv;
{
	int fd;
	int i, dlen, nspis;
	
	struct encap_msghdr *em = (struct encap_msghdr *)bigbuf;

	if ((argc < 3) || (argc > 9) || ((argc % 2) != 1))
	  fprintf(stderr, "usage: %s dst1 spi1 [ dst2 spi2 [ dst3 spi3 [ dst4 spi4 ] ] ] \n", argv[0]), exit(1);
	nspis = argc / 2;

  
	fd = open("/dev/ipsec", 2);
	if (fd < 0)
		perror("open"), exit(1);
	
	em->em_magic = EM_MAGIC;
	em->em_version = 0;
	em->em_type = EMT_GRPSPIS;
	em->em_msglen = EM_MINLEN + nspis * 12;

	switch (nspis)
	{
	      case 4:
		em->em_rel[3].emr_spi = htonl(strtol(argv[8], NULL, 16));
		em->em_rel[3].emr_dst.s_addr = inet_addr(argv[7]);
	      case 3:
		em->em_rel[2].emr_spi = htonl(strtol(argv[6], NULL, 16));
		em->em_rel[2].emr_dst.s_addr = inet_addr(argv[5]);
	      case 2:
		em->em_rel[1].emr_spi = htonl(strtol(argv[4], NULL, 16));
		em->em_rel[1].emr_dst.s_addr = inet_addr(argv[3]);
	      case 1:
		em->em_rel[0].emr_spi = htonl(strtol(argv[2], NULL, 16));
		em->em_rel[0].emr_dst.s_addr = inet_addr(argv[1]);
		break;
	}
	
	if (write(fd, (caddr_t)em, em->em_msglen) != em->em_msglen)
		perror("write");

}


