/*
 * This program is an implementation of the ISAKMP Internet Standard.
 * Copyright (C) 1997 Angelos D. Keromytis.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * This code was written while the author was in Greece, in May/June
 * 1997.
 *
 * You may contact the author by:
 *   e-mail: angelos@dsl.cis.upenn.edu
 *  US-mail: Angelos D. Keromytis
 *           Distributed Systems Lab
 *           Computer and Information Science Department
 *           University of Pennsylvania
 *           Moore Building
 *           200 South 33rd Street
 *           Philadelphia, PA 19104	   
 */

#if defined(__OpenBSD__) || defined(__NetBSD__)
#include <machine/endian.h>
#elif linux
#if defined(i386) && !defined(__i386__)
#define __i386__ 1
#define MYHACKFORTHIS 1
#endif
#include <endian.h>
#include <asm/byteorder.h>
#ifdef MYHACKFORTHIS
#undef __i386__
#endif
#else
#include <sys/endian.h>
#endif

struct isakmp_hdr
{
    u_int8_t    isa_icookie[COOKIE_SIZE];
    u_int8_t    isa_rcookie[COOKIE_SIZE];
    u_int8_t    isa_np;                 /* Next payload */
#if BYTE_ORDER == BIG_ENDIAN
    u_int8_t    isa_maj:4;		/* Major version */
    u_int8_t    isa_min:4;		/* Minor version */
#elif BYTE_ORDER == LITTLE_ENDIAN
    u_int8_t    isa_min:4;
    u_int8_t    isa_maj:4;
#else
#error "Check your endianness"
#endif
    u_int8_t    isa_xchg;		/* Exchange type */
    u_int8_t    isa_flags;		
    u_int32_t   isa_msgid;		/* Message ID */
    u_int32_t   isa_length;		/* Length of message */
};

struct isakmp_attribute
{
    union 
    {
	struct _heh
	{
#if BYTE_ORDER == BIG_ENDIAN
	    u_int16_t isaat_af:1;		/* TLV/TV flag */
	    u_int16_t isaat_type:15;		/* Attribute type */
#elif BYTE_ORDER == LITTLE_ENDIAN
	    u_int16_t isaat_type:15;
	    u_int16_t isaat_af:1;
#else
#error "Check your endianness"
#endif
	} _heh;
	u_int16_t isaat_type;
    } _hah;
    u_int16_t isaat_lv;			/* Length or value */
};

#define isaat_af     _hah._heh.isaat_af
#define isaat_type   _hah.isaat_type

struct isakmp_sa
{
    u_int8_t  isasa_np;			/* Next payload */
    u_int8_t  isasa_reserved;
    u_int16_t isasa_length;		/* Payload length */
    u_int32_t isasa_doi;		/* DOI */
};

struct isakmp_proposal
{
    u_int8_t    isap_np;
    u_int8_t    isap_reserved;
    u_int16_t   isap_length;
    u_int8_t    isap_proposal;
    u_int8_t    isap_protoid;
    u_int8_t    isap_spisize;
    u_int8_t    isap_notrans;		/* Number of transforms */
};

struct isakmp_transform
{
    u_int8_t    isat_np;
    u_int8_t    isat_reserved;
    u_int16_t   isat_length;
    u_int8_t    isat_transnum;		/* Number of the transform */
    u_int8_t    isat_transid;
    u_int8_t    isat_reserved2;
};
