/*	IDEA Encryption Plugin for Back Orifice 2000    
	Copyright (C) 1999, Maw~

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	The author of this program may be contacted at maw@wynne.demon.co.uk. 
*/
#include "MyIDEA.hpp"
#include "MD5.hpp"
#include <string.h>
#include <stdlib.h>

void IDEA_SetCBC(IDEAKeys *Keys, int t)
{
	if (t) Keys->Flags |= IDEA_CBC;
	else Keys->Flags &= ~IDEA_CBC;
}

void IDEA_InitKeys(IDEAKeys *Keys)
{
	memset(Keys,0,sizeof(IDEAKeys));
	Keys->Flags |= IDEA_CBC;
}

void IDEA_ShutdownKeys(IDEAKeys *Keys)
{
	if (Keys->StrKey) free(Keys->StrKey);
	IDEA_InitKeys(Keys);
}

// String key into shorts & generates subkeys
void IDEA_SetKey(IDEAKeys *Keys, char *key)
{
	PW_MD5(key, strlen(key), (char*)&Keys->Key[0]);

	if (Keys->StrKey) free(Keys->StrKey);
	Keys->StrKey = (char*)malloc(strlen(key)+1);
	strcpy(Keys->StrKey, key);

	IDEA_GenSubKeys(Keys);
}

/*
Calculates the multiplicative inverse of d mod (2^16 + 1)
i.e finds a value x such that dx=1 mod (2^16 + 1)

The version below is actually the only bit of code I didn't write myself.
It was ripped from a version of PGP (the European version of course).
I have a total mental block with this piece of code and it's late. I'll
write my own version later.

This function is *not* copyright Maw~
*/

unsigned short IDEA_MulInv(unsigned short x)
{
    unsigned short t0, t1;
    unsigned short q, y;

    if (x <= 1)
	return x;
    t1 = 0x10001L / x;
    y = 0x10001L % x;
    if (y == 1)
	return (1 - t1);
    t0 = 1;
    do {
	q = x / y;
	x = x % y;
	t0 += q * t1;
	if (x == 1)
	    return t0;
	q = y / x;
	y = y % x;
	t1 += q * t0;
    } while (y != 1);
    return (1 - t1);
}


// Generates the 52 (actually 56 are gen'd but only 52 used) subkeys used
// by IDEA along with the equivalent decryption keys.

void IDEA_GenSubKeys(IDEAKeys * Keys)
{
	int i, o , t;
	unsigned short wrap1, wrap2;
	unsigned short *ptr;

	memset(Keys->LastBlock, 0, sizeof(Keys->LastBlock));
	memset(Keys->LastBlockDC, 0, sizeof(Keys->LastBlockDC));

	memcpy(&Keys->SubKeys[0], &Keys->Key[0], 16);
	for (i=1;i<8;i++)
	{
		t = i*8;
		memcpy(&Keys->SubKeys[t], &Keys->SubKeys[t-8], 16);
		
		wrap1 = Keys->SubKeys[t];
		wrap2 = Keys->SubKeys[t+1];

		for (o=0;o<6;o++)
			Keys->SubKeys[t+o] = Keys->SubKeys[t+o+1] << 9 | Keys->SubKeys[t+o+2] >> 7;
		Keys->SubKeys[t+6] = Keys->SubKeys[t+7] << 9 | wrap1 >> 7;
		Keys->SubKeys[t+7] = wrap1 << 9 | wrap2 >> 7;
	}
	
	ptr = &Keys->SubKeys[51];

	Keys->DCSubKeys[3] = IDEA_MulInv(*ptr--);
	Keys->DCSubKeys[2] = - (*ptr--);
	Keys->DCSubKeys[1] = - (*ptr--);
	Keys->DCSubKeys[0] = IDEA_MulInv(*ptr--);
	Keys->DCSubKeys[5] = *ptr--;
	Keys->DCSubKeys[4] = *ptr--;

	o=6;
	for (i=0;i<7;i++)
	{
		Keys->DCSubKeys[o+3] = IDEA_MulInv(*ptr--);
		Keys->DCSubKeys[o+1] = - (*ptr--);
		Keys->DCSubKeys[o+2] = - (*ptr--);
		Keys->DCSubKeys[o+0] = IDEA_MulInv(*ptr--);
		Keys->DCSubKeys[o+5] = *ptr--;
		Keys->DCSubKeys[o+4] = *ptr--;
		o+=6;
	}
	Keys->DCSubKeys[o+3] = IDEA_MulInv(*ptr--);
	Keys->DCSubKeys[o+2] = - (*ptr--);
	Keys->DCSubKeys[o+1] = - (*ptr--);
	Keys->DCSubKeys[o+0] = IDEA_MulInv(*ptr--);
}

// a*b mod (2^16 + 1)
unsigned short IDEA_MulMod(unsigned short a,unsigned short b)
{
	unsigned int tmp;
	unsigned short ab, abdiv;

	tmp = (int)a * (int)b;

	if (tmp==0)
	{
		if (a) return 1-a;
		else return 1-b;
	}

	ab = a*b;
	abdiv = (unsigned short)(tmp >> 16);
	if (ab<abdiv) return (ab-abdiv)+1;

	return (ab-abdiv);
}

void IDEA_EncryptBlocks(IDEAKeys *Keys, unsigned short *s_data, int numquads)
{
	unsigned short T1,T2,T3,T4;
	unsigned short MA1, MA2;
	unsigned short e,f;
	unsigned short *data;
	unsigned short *keys;

	data = s_data;
	for (int i=0;i<numquads;i++)
	{
		keys = Keys->SubKeys;

		if (Keys->Flags & IDEA_CBC)
		{
			data[0] ^= Keys->LastBlock[0];
			data[1] ^= Keys->LastBlock[1];
			data[2] ^= Keys->LastBlock[2];
			data[3] ^= Keys->LastBlock[3];
		}

		for (int r=0;r<8;r++)
		{
			//	Opening Transf

			T1 = IDEA_MulMod(data[0], *keys++);
			T2 = data[1] + *keys++;
			T3 = data[2] + *keys++;
			T4 = IDEA_MulMod(data[3], *keys++);
		
			MA1 = T1 ^ T3;
			MA2 = T2 ^ T4;

			//	MA Unit

			MA1 = IDEA_MulMod(MA1, *keys++);
			MA2 = MA1 + MA2;
			MA2 = IDEA_MulMod(MA2, *keys++);
			MA1 = MA1 + MA2;

			//	Ending XOR

			data[0] = T1 ^ MA2;
			data[1] = T3 ^ MA2;
			data[2] = T2 ^ MA1;
			data[3] = T4 ^ MA1;
		}

		e=data[1];
		f=data[2];
		if (Keys->Flags & IDEA_CBC)
		{
			Keys->LastBlock[0] = data[0] = IDEA_MulMod(data[0], *keys++);
			Keys->LastBlock[1] = data[1] = f + *keys++;
			Keys->LastBlock[2] = data[2] = e + *keys++;
			Keys->LastBlock[3] = data[3] = IDEA_MulMod(data[3], *keys++);
		}
		else
		{
			data[0] = IDEA_MulMod(data[0], *keys++);
			data[1] = f + *keys++;
			data[2] = e + *keys++;
			data[3] = IDEA_MulMod(data[3], *keys++);
		}

		data = &data[4];
	}
}

void IDEA_DecryptBlocks(IDEAKeys *Keys, unsigned short *s_data, int numquads)
{
	unsigned short T1,T2,T3,T4;
	unsigned short MA1, MA2;
	unsigned short e,f;
	unsigned short *data;
	unsigned short *keys;
	unsigned short TmpLB[4];

	data = s_data;

	for (int i=0;i<numquads;i++)
	{
		keys = Keys->DCSubKeys;

		if (Keys->Flags & IDEA_CBC)
		{
			TmpLB[0] = Keys->LastBlockDC[0];
			TmpLB[1] = Keys->LastBlockDC[1];
			TmpLB[2] = Keys->LastBlockDC[2];
			TmpLB[3] = Keys->LastBlockDC[3];

			Keys->LastBlockDC[0] = data[0];
			Keys->LastBlockDC[1] = data[1];
			Keys->LastBlockDC[2] = data[2];
			Keys->LastBlockDC[3] = data[3];
		}

		for (int r=0;r<8;r++)
		{
			//	Opening Transf

			T1 = IDEA_MulMod(data[0], *keys++);
			T2 = data[1] + *keys++;
			T3 = data[2] + *keys++;
			T4 = IDEA_MulMod(data[3], *keys++);
		
			MA1 = T1 ^ T3;
			MA2 = T2 ^ T4;

			//	MA Unit

			MA1 = IDEA_MulMod(MA1, *keys++);
			MA2 = MA1 + MA2;
			MA2 = IDEA_MulMod(MA2, *keys++);
			MA1 = MA1 + MA2;

			//	Ending XOR

			data[0] = T1 ^ MA2;
			data[1] = T3 ^ MA2;
			data[2] = T2 ^ MA1;
			data[3] = T4 ^ MA1;
		}

		e=data[1];
		f=data[2];
		
		if (Keys->Flags & IDEA_CBC)
		{
			data[0] = IDEA_MulMod(data[0], *keys++) ^ TmpLB[0];
			data[1] = (f + *keys++) ^ TmpLB[1];
			data[2] = (e + *keys++) ^ TmpLB[2];
			data[3] = IDEA_MulMod(data[3], *keys++) ^ TmpLB[3];
		}
		else
		{
			data[0] = IDEA_MulMod(data[0], *keys++);
			data[1] = f + *keys++;
			data[2] = e + *keys++;
			data[3] = IDEA_MulMod(data[3], *keys++);
		}

		data = &data[4];
	}
}

