/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.BigInt;
import com.sun.crypto.provider.DerOutputStream;
import com.sun.crypto.provider.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;

public final class DHParameters
extends AlgorithmParametersSpi {
    protected BigInteger p;
    protected BigInteger g;
    private int l;

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(new BigInt(this.p));
        derOutputStream2.putInteger(new BigInt(this.g));
        if (this.l > 0) {
            derOutputStream2.putInteger(new BigInt(BigInteger.valueOf(this.l)));
        }
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        try {
            Class<?> clazz2 = Class.forName("javax.crypto.spec.DHParameterSpec");
            if (clazz2.isAssignableFrom(clazz)) {
                return new DHParameterSpec(this.p, this.g, this.l);
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + classNotFoundException.getMessage());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.p = ((DHParameterSpec)algorithmParameterSpec).getP();
        this.g = ((DHParameterSpec)algorithmParameterSpec).getG();
        this.l = ((DHParameterSpec)algorithmParameterSpec).getL();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            DerValue derValue = new DerValue(byArray);
            if (derValue.tag != 48) {
                throw new IOException("DH params parsing error");
            }
            derValue.data.reset();
            this.p = derValue.data.getInteger().toBigInteger();
            this.g = derValue.data.getInteger().toBigInteger();
            if (derValue.data.available() != 0) {
                this.l = derValue.data.getInteger().toInt();
            }
            if (derValue.data.available() != 0) {
                throw new IOException("DH parameter parsing error: Extra data");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Private-value length too big");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer("SunJCE Diffie-Hellman Parameters:\np:\n" + new BigInt(this.p).toString() + "\n" + "g:\n" + new BigInt(this.g).toString());
        if (this.l != 0) {
            stringBuffer.append("\nl:\n    " + this.l);
        }
        return stringBuffer.toString();
    }
}

