/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherBlockChaining;
import com.sun.crypto.provider.CipherFeedback;
import com.sun.crypto.provider.DESConstants;
import com.sun.crypto.provider.DESCrypt;
import com.sun.crypto.provider.ElectronicCodeBook;
import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.OutputFeedback;
import com.sun.crypto.provider.PCBC;
import com.sun.crypto.provider.PKCS5Padding;
import com.sun.crypto.provider.Padding;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public class DESCipher
extends CipherSpi
implements DESConstants {
    private byte[] buffer = null;
    private int unitBytes = 0;
    private int buffered = 0;
    private int diffBlocksize = 8;
    private Padding padding = null;
    private SymmetricCipher cipher = null;
    protected int cipherMode;
    private boolean decrypting = false;
    protected static final int ECB_MODE = 0;
    protected static final int CBC_MODE = 1;
    protected static final int CFB_MODE = 2;
    protected static final int OFB_MODE = 3;
    protected static final int PCBC_MODE = 4;
    protected SymmetricCipher rawAlg;
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;

    public DESCipher() {
        try {
            this.setRawAlg();
            this.unitBytes = 8;
            this.buffer = new byte[16];
            this.cipherMode = 0;
            ElectronicCodeBook electronicCodeBook = new ElectronicCodeBook();
            electronicCodeBook.setEmbeddedCipher(this.rawAlg);
            this.cipher = electronicCodeBook;
            this.padding = new PKCS5Padding();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
    }

    public DESCipher(String string, String string2) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.setRawAlg();
        this.unitBytes = 8;
        this.buffer = new byte[16];
        if (string.equalsIgnoreCase("ECB")) {
            this.cipherMode = 0;
            ElectronicCodeBook electronicCodeBook = new ElectronicCodeBook();
            electronicCodeBook.setEmbeddedCipher(this.rawAlg);
            this.cipher = electronicCodeBook;
        } else {
            this.engineSetMode(string);
        }
        if (string2.equalsIgnoreCase("PKCS5Padding")) {
            this.padding = new PKCS5Padding();
        } else {
            this.engineSetPadding(string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            byArray2 = new byte[this.engineGetOutputSize(n2)];
            int n3 = this.engineDoFinal(byArray, n, n2, byArray2, 0);
            if (n3 < byArray2.length) {
                byArray3 = new byte[n3];
                if (n3 != 0) {
                    System.arraycopy(byArray2, 0, byArray3, 0, n3);
                }
            } else {
                byArray3 = byArray2;
            }
        }
        catch (ShortBufferException shortBufferException) {}
        return byArray3;
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int n4;
        int n5 = n4 = this.buffered + n2;
        int n6 = 0;
        if (this.unitBytes != 8) {
            this.diffBlocksize = n4 < this.diffBlocksize ? (this.diffBlocksize -= n4) : 8 - (n4 - this.diffBlocksize) % 8;
            n6 = this.diffBlocksize;
        } else if (this.padding != null) {
            n6 = this.padding.padLength(n4);
        }
        if (this.diffBlocksize > 0 && this.diffBlocksize != 8 && this.padding != null && this.decrypting) {
            throw new IllegalBlockSizeException("Input length must be multiple of 8 when decrypting with padded cipher");
        }
        if (this.padding != null && !this.decrypting) {
            n5 += n6;
        }
        if (byArray2 == null || byArray2.length - n3 < n4 || this.padding != null && !this.decrypting && byArray2.length - n3 < n5) {
            throw new ShortBufferException("Output buffer not long enough to hold the result" + byArray2.length + " " + n5);
        }
        byte[] byArray3 = null;
        if (this.padding == null || this.decrypting) {
            if (this.buffered == 0) {
                n4 = this.finalNoPadding(byArray, n, byArray2, n3, n2);
            } else {
                byArray3 = new byte[n4];
                System.arraycopy(this.buffer, 0, byArray3, 0, this.buffered);
                if (n2 != 0) {
                    System.arraycopy(byArray, n, byArray3, this.buffered, n2);
                }
                n4 = this.finalNoPadding(byArray3, 0, byArray2, n3, n4);
            }
        } else {
            byArray3 = new byte[n5];
            if (this.buffered != 0) {
                System.arraycopy(this.buffer, 0, byArray3, 0, this.buffered);
            }
            if (n2 != 0) {
                System.arraycopy(byArray, n, byArray3, this.buffered, n2);
            }
            this.padding.padWithLen(byArray3, n4, n6);
            n4 = this.finalNoPadding(byArray3, 0, byArray2, n3, n5);
        }
        if (this.padding != null && this.decrypting) {
            if ((n4 = this.padding.unpad(byArray2, n3, n4)) < 0) {
                throw new BadPaddingException("Given final block not properly padded");
            }
            int n7 = n4;
            while (n7 < byArray2.length) {
                byArray2[n7] = 0;
                ++n7;
            }
        }
        this.buffered = 0;
        this.diffBlocksize = 8;
        if (this.cipherMode != 0) {
            FeedbackCipher feedbackCipher = (FeedbackCipher)((Object)this.cipher);
            feedbackCipher.reset();
        }
        return n4;
    }

    protected int engineGetBlockSize() {
        return 8;
    }

    protected byte[] engineGetIV() {
        if (this.cipherMode == 0) {
            return null;
        }
        return ((FeedbackCipher)((Object)this.cipher)).getIV();
    }

    protected int engineGetOutputSize(int n) {
        int n2 = this.buffered + n;
        if (this.padding == null) {
            return n2;
        }
        if (this.decrypting) {
            return n2;
        }
        if (this.unitBytes != 8) {
            if (n2 < this.diffBlocksize) {
                return this.diffBlocksize;
            }
            return n2 + 8 - (n2 - this.diffBlocksize) % 8;
        }
        return n2 + this.padding.padLength(n2);
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.cipherMode == 0) {
            return null;
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(this.engineGetIV());
        try {
            algorithmParameters = AlgorithmParameters.getInstance("DES", "SunJCE");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("SunJCE called, but not configured");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("SunJCE called, but not configured");
        }
        try {
            algorithmParameters.init(ivParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("IvParameterSpec not supported");
        }
        return algorithmParameters;
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                ivParameterSpec = (IvParameterSpec)algorithmParameters.getParameterSpec(class$javax$crypto$spec$IvParameterSpec != null ? class$javax$crypto$spec$IvParameterSpec : (class$javax$crypto$spec$IvParameterSpec = DESCipher.class$("javax.crypto.spec.IvParameterSpec")));
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
            }
        }
        this.engineInit(n, key, ivParameterSpec, secureRandom);
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.decrypting = n == 2;
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        this.buffered = 0;
        this.diffBlocksize = 8;
        if (this.cipherMode == 0 || secureRandom == null) {
            this.cipher.init(key);
            return;
        }
        byte[] byArray = new byte[8];
        secureRandom.nextBytes(byArray);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
        try {
            this.cipher.init(key, ivParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.decrypting = n == 2;
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        this.buffered = 0;
        this.diffBlocksize = 8;
        if (this.cipherMode == 0) {
            this.cipher.init(key);
            return;
        }
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
            this.cipher.init(key, (IvParameterSpec)algorithmParameterSpec);
            return;
        } else if (secureRandom == null) {
            this.cipher.init(key);
            return;
        } else {
            byte[] byArray = new byte[8];
            secureRandom.nextBytes(byArray);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            this.cipher.init(key, ivParameterSpec);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NoSuchAlgorithmException("null mode");
        }
        String string2 = string.toUpperCase();
        if (string2.equals("ECB")) {
            return;
        }
        if (string2.equals("CBC")) {
            this.cipherMode = 1;
            CipherBlockChaining cipherBlockChaining = new CipherBlockChaining();
            cipherBlockChaining.setEmbeddedCipher(this.rawAlg);
            this.cipher = cipherBlockChaining;
            return;
        }
        if (string2.startsWith("CFB")) {
            this.cipherMode = 2;
            CipherFeedback cipherFeedback = null;
            if (string.length() > 3) {
                int n;
                Integer n2 = null;
                try {
                    n2 = Integer.valueOf(string.substring(3));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NoSuchAlgorithmException("Algorithm mode: " + string + " not implemented");
                }
                if (n2 == null || (n = n2.intValue()) % 8 != 0 || (this.unitBytes = n >> 3) > 8) throw new NoSuchAlgorithmException("Invalid algorithm mode: " + string);
                cipherFeedback = new CipherFeedback(this.unitBytes);
            } else {
                cipherFeedback = new CipherFeedback();
            }
            cipherFeedback.setEmbeddedCipher(this.rawAlg);
            this.cipher = cipherFeedback;
            return;
        }
        if (string2.startsWith("OFB")) {
            this.cipherMode = 3;
            OutputFeedback outputFeedback = null;
            if (string.length() > 3) {
                int n;
                Integer n3 = null;
                try {
                    n3 = Integer.valueOf(string.substring(3));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NoSuchAlgorithmException("Algorithm mode: " + string + " not implemented");
                }
                if (n3 == null || (n = n3.intValue()) % 8 != 0 || (this.unitBytes = n >> 3) > 8) throw new NoSuchAlgorithmException("Invalid algorithm mode: " + string);
                outputFeedback = new OutputFeedback(this.unitBytes);
            } else {
                outputFeedback = new OutputFeedback();
            }
            outputFeedback.setEmbeddedCipher(this.rawAlg);
            this.cipher = outputFeedback;
            return;
        }
        if (!string2.equals("PCBC")) throw new NoSuchAlgorithmException("Cipher mode: " + string + " not found");
        this.cipherMode = 4;
        PCBC pCBC = new PCBC();
        pCBC.setEmbeddedCipher(this.rawAlg);
        this.cipher = pCBC;
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
        if (string == null) {
            throw new NoSuchPaddingException("null padding");
        }
        if (string.equalsIgnoreCase("PKCS5Padding")) {
            return;
        }
        if (!string.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException("Paddding: " + string + " not implemented");
        }
        this.padding = null;
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            byArray2 = new byte[this.engineGetOutputSize(n2)];
            int n3 = this.engineUpdate(byArray, n, n2, byArray2, 0);
            if (n3 < byArray2.length) {
                byArray3 = new byte[n3];
                System.arraycopy(byArray2, 0, byArray3, 0, n3);
            } else {
                byArray3 = byArray2;
            }
        }
        catch (ShortBufferException shortBufferException) {}
        return byArray3;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        int n4 = this.buffered + n2;
        if (this.padding != null && this.decrypting) {
            n4 -= 8;
        }
        n4 = n4 < 0 ? 0 : n4;
        n4 -= n4 % this.unitBytes;
        if (byArray2 == null || byArray2.length - n3 < n4) {
            throw new ShortBufferException("Output buffer must be (at least) " + n4 + " bytes long");
        }
        if (n4 > 0) {
            byte[] byArray3 = new byte[n4];
            int n5 = n4 - this.buffered;
            int n6 = this.buffered;
            if (n5 < 0) {
                n5 = 0;
                n6 = n4;
            }
            if (this.buffered != 0) {
                System.arraycopy(this.buffer, 0, byArray3, 0, n6);
            }
            if (n5 > 0) {
                System.arraycopy(byArray, n, byArray3, n6, n5);
            }
            try {
                if (this.decrypting) {
                    this.cipher.decrypt(byArray3, 0, n4, byArray2, n3);
                } else {
                    this.cipher.encrypt(byArray3, 0, n4, byArray2, n3);
                }
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {}
            if (this.unitBytes != 8) {
                this.diffBlocksize = n4 < this.diffBlocksize ? (this.diffBlocksize -= n4) : 8 - (n4 - this.diffBlocksize) % 8;
            }
            n2 -= n5;
            n += n5;
            n3 += n4;
            this.buffered -= n6;
            if (this.buffered > 0) {
                System.arraycopy(this.buffer, n6, this.buffer, 0, this.buffered);
            }
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buffer, this.buffered, n2);
        }
        this.buffered += n2;
        return n4 < 0 ? 0 : n4;
    }

    private int finalNoPadding(byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws IllegalBlockSizeException {
        if (byArray == null || n3 == 0) {
            return 0;
        }
        if (n3 % this.unitBytes != 0) {
            if (this.padding != null) {
                throw new IllegalBlockSizeException("Input length (with padding) not multiple of " + this.unitBytes + " bytes");
            }
            throw new IllegalBlockSizeException("Input length not multiple of " + this.unitBytes + " bytes");
        }
        if (this.decrypting) {
            this.cipher.decrypt(byArray, n, n3, byArray2, n2);
        } else {
            this.cipher.encrypt(byArray, n, n3, byArray2, n2);
        }
        return n3;
    }

    protected void setRawAlg() {
        this.rawAlg = new DESCrypt();
    }
}

