/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.JceSecurity;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;

public class Mac {
    private Provider provider;
    private MacSpi macSpi;
    private String algorithm;
    private boolean initialized = false;

    protected Mac(MacSpi macSpi, Provider provider, String string) {
        this.macSpi = macSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final Object clone() throws CloneNotSupportedException {
        if (this.macSpi instanceof Cloneable) {
            Mac mac = (Mac)super.clone();
            mac.provider = this.provider;
            mac.macSpi = (MacSpi)this.macSpi.clone();
            mac.algorithm = this.algorithm;
            mac.initialized = this.initialized;
            return mac;
        }
        throw new CloneNotSupportedException();
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        byte[] byArray = this.macSpi.engineDoFinal();
        this.macSpi.engineReset();
        return byArray;
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        this.update(byArray);
        return this.doFinal();
    }

    public final void doFinal(byte[] byArray, int n) throws ShortBufferException, IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        int n2 = this.getMacLength();
        if (byArray == null || byArray.length - n < n2) {
            throw new ShortBufferException("Cannot store MAC in output buffer");
        }
        byte[] byArray2 = this.doFinal();
        System.arraycopy(byArray2, 0, byArray, n, n2);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final Mac getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = JceSecurity.getImpl(string, "Mac", null);
            return new Mac((MacSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
        }
    }

    public static final Mac getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = JceSecurity.getImpl(string, "Mac", string2);
        return new Mac((MacSpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public final int getMacLength() {
        return this.macSpi.engineGetMacLength();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.macSpi.engineInit(key, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {}
        this.initialized = true;
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.macSpi.engineInit(key, algorithmParameterSpec);
        this.initialized = true;
    }

    public final void reset() {
        this.macSpi.engineReset();
    }

    public final void update(byte by) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        this.macSpi.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        if (byArray != null) {
            this.macSpi.engineUpdate(byArray, 0, byArray.length);
        }
    }

    public final void update(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        if (byArray != null) {
            if (byArray.length - n < n2) {
                throw new IllegalArgumentException("Input buffer too short");
            }
            this.macSpi.engineUpdate(byArray, n, n2);
        }
    }
}

