/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public final class DHKeyAgreement
extends KeyAgreementSpi {
    public static final int DH_UNINITIALIZED = 0;
    public static final int DH_PHASE_1 = 1;
    public static final int DH_PHASE_2 = 2;
    private int phase = 0;
    private KeyFactory dhKeyFactory;
    private DHPrivateKeySpec dhPrivKeySpec;
    private DHPublicKeySpec dhPubKeySpec;
    static /* synthetic */ Class class$javax$crypto$spec$DHPrivateKeySpec;
    static /* synthetic */ Class class$javax$crypto$spec$DHPublicKeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Key engineDoPhase(int n, Key key) throws IllegalStateException, InvalidKeyException {
        try {
            switch (n) {
                case 1: {
                    if (this.phase != 0) {
                        throw new IllegalStateException("Wrong state");
                    }
                    this.dhKeyFactory = KeyFactory.getInstance("DH");
                    this.dhPrivKeySpec = (DHPrivateKeySpec)this.dhKeyFactory.getKeySpec(key, class$javax$crypto$spec$DHPrivateKeySpec != null ? class$javax$crypto$spec$DHPrivateKeySpec : (class$javax$crypto$spec$DHPrivateKeySpec = DHKeyAgreement.class$("javax.crypto.spec.DHPrivateKeySpec")));
                    this.phase = 1;
                    break;
                }
                case 2: {
                    if (this.phase != 1) {
                        throw new IllegalStateException("Wrong state");
                    }
                    this.dhPubKeySpec = (DHPublicKeySpec)this.dhKeyFactory.getKeySpec(key, class$javax$crypto$spec$DHPublicKeySpec != null ? class$javax$crypto$spec$DHPublicKeySpec : (class$javax$crypto$spec$DHPublicKeySpec = DHKeyAgreement.class$("javax.crypto.spec.DHPublicKeySpec")));
                    if (!this.dhPrivKeySpec.getP().equals(this.dhPubKeySpec.getP()) || !this.dhPrivKeySpec.getG().equals(this.dhPubKeySpec.getG())) {
                        throw new InvalidKeyException("Incompatible parameters");
                    }
                    this.phase = 2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid phase number");
                }
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(invalidKeySpecException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
        }
        return null;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        BigInteger bigInteger = this.dhPubKeySpec.getP();
        if (this.phase != 2) {
            throw new IllegalStateException("Wrong state");
        }
        this.phase = 0;
        byte[] byArray = this.dhPubKeySpec.getY().modPow(this.dhPrivKeySpec.getX(), bigInteger).toByteArray();
        if (byArray.length << 3 != bigInteger.bitLength()) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        if (this.phase != 2) {
            throw new IllegalStateException("Wrong state");
        }
        if (byArray == null) {
            throw new ShortBufferException("No buffer provided for shared secret");
        }
        BigInteger bigInteger = this.dhPubKeySpec.getP();
        byte[] byArray2 = this.dhPubKeySpec.getY().modPow(this.dhPrivKeySpec.getX(), bigInteger).toByteArray();
        if (byArray2.length << 3 != bigInteger.bitLength()) {
            if (byArray.length - n < byArray2.length - 1) {
                throw new ShortBufferException("Buffer too short to hold shared secret");
            }
            System.arraycopy(byArray2, 1, byArray, n, byArray2.length - 1);
            this.phase = 0;
            return byArray2.length - 1;
        }
        if (byArray.length - n < byArray2.length) {
            throw new ShortBufferException("Buffer too short to hold shared secret");
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        this.phase = 0;
        return byArray2.length;
    }

    protected void engineInit(SecureRandom secureRandom) {
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("");
    }
}

