/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESKeySpec
implements KeySpec {
    private byte[] key;
    private static final byte[] PARITY_BIT_MASK = new byte[]{-128, 64, 32, 16, 8, 4, 2};

    public DESKeySpec(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    public DESKeySpec(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("Wrong key size");
        }
        this.key = new byte[8];
        System.arraycopy(byArray, n, this.key, 0, 8);
    }

    public byte[] getKey() {
        return this.key;
    }

    public static boolean isParityAdjusted(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("Wrong key size");
        }
        int n2 = 0;
        while (n2 < 8) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < PARITY_BIT_MASK.length) {
                if ((byArray[n2 + n] & PARITY_BIT_MASK[n4]) == PARITY_BIT_MASK[n4]) {
                    ++n3;
                }
                ++n4;
            }
            if (n3 & true ? (byArray[n2 + n] & 1) == 1 : (byArray[n2 + n] & 1) != 1) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

