/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESKey;
import com.sun.crypto.provider.DESedeKey;
import com.sun.crypto.provider.DHPublicKey;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public final class DHKeyAgreement
extends KeyAgreementSpi {
    private boolean generateSecret = false;
    private KeyFactory dhKeyFactory = KeyFactory.getInstance("DH");
    private DHPrivateKeySpec dhPrivKeySpec;
    private DHPublicKeySpec dhPubKeySpec;
    private BigInteger init_p = null;
    private BigInteger init_g = null;
    static /* synthetic */ Class class$javax$crypto$spec$DHPrivateKeySpec;
    static /* synthetic */ Class class$javax$crypto$spec$DHPublicKeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException("Public key expected");
        }
        if (this.init_p == null || this.init_g == null) {
            throw new IllegalStateException("Not initialized");
        }
        try {
            this.dhPubKeySpec = (DHPublicKeySpec)this.dhKeyFactory.getKeySpec(key, class$javax$crypto$spec$DHPublicKeySpec != null ? class$javax$crypto$spec$DHPublicKeySpec : (class$javax$crypto$spec$DHPublicKeySpec = DHKeyAgreement.class$("javax.crypto.spec.DHPublicKeySpec")));
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(invalidKeySpecException.getMessage());
        }
        BigInteger bigInteger = this.dhPubKeySpec.getP();
        BigInteger bigInteger2 = this.dhPubKeySpec.getG();
        if (bigInteger != null && !this.init_p.equals(bigInteger)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (bigInteger2 != null && !this.init_g.equals(bigInteger2)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        this.generateSecret = true;
        if (!bl) {
            byte[] byArray = this.engineGenerateSecret();
            return new DHPublicKey(new BigInteger(1, byArray), this.init_p, this.init_g);
        }
        return null;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (!this.generateSecret) {
            throw new IllegalStateException("Wrong state");
        }
        this.generateSecret = false;
        BigInteger bigInteger = this.init_p;
        byte[] byArray = this.dhPubKeySpec.getY().modPow(this.dhPrivKeySpec.getX(), bigInteger).toByteArray();
        if (byArray.length << 3 != bigInteger.bitLength()) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (string == null) {
            throw new NoSuchAlgorithmException("null algorithm");
        }
        byte[] byArray = this.engineGenerateSecret();
        if (string.equalsIgnoreCase("DES")) {
            return new DESKey(byArray);
        }
        if (string.equalsIgnoreCase("DESede")) {
            return new DESedeKey(byArray);
        }
        throw new NoSuchAlgorithmException("Unsupported secret key algorithm: " + string);
    }

    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        if (!this.generateSecret) {
            throw new IllegalStateException("Wrong state");
        }
        if (byArray == null) {
            throw new ShortBufferException("No buffer provided for shared secret");
        }
        BigInteger bigInteger = this.init_p;
        byte[] byArray2 = this.dhPubKeySpec.getY().modPow(this.dhPrivKeySpec.getX(), bigInteger).toByteArray();
        if (byArray2.length << 3 != bigInteger.bitLength()) {
            if (byArray.length - n < byArray2.length - 1) {
                throw new ShortBufferException("Buffer too short to hold shared secret");
            }
            System.arraycopy(byArray2, 1, byArray, n, byArray2.length - 1);
            this.generateSecret = false;
            return byArray2.length - 1;
        }
        if (byArray.length - n < byArray2.length) {
            throw new ShortBufferException("Buffer too short to hold shared secret");
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        this.generateSecret = false;
        return byArray2.length;
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(key, null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {}
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.generateSecret = false;
        this.init_p = null;
        this.init_g = null;
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Diffie-Hellman parameters expected");
        }
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Private key expected");
        }
        try {
            this.dhPrivKeySpec = (DHPrivateKeySpec)this.dhKeyFactory.getKeySpec(key, class$javax$crypto$spec$DHPrivateKeySpec != null ? class$javax$crypto$spec$DHPrivateKeySpec : (class$javax$crypto$spec$DHPrivateKeySpec = DHKeyAgreement.class$("javax.crypto.spec.DHPrivateKeySpec")));
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(invalidKeySpecException.getMessage());
        }
        if (algorithmParameterSpec != null) {
            this.init_p = ((DHParameterSpec)algorithmParameterSpec).getP();
            this.init_g = ((DHParameterSpec)algorithmParameterSpec).getG();
        }
        BigInteger bigInteger = this.dhPrivKeySpec.getP();
        BigInteger bigInteger2 = this.dhPrivKeySpec.getG();
        if (this.init_p != null && bigInteger != null && !this.init_p.equals(bigInteger)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (this.init_g != null && bigInteger2 != null && !this.init_g.equals(bigInteger2)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (this.init_p == null && bigInteger == null || this.init_g == null && bigInteger2 == null) {
            throw new InvalidKeyException("Missing parameters");
        }
        this.init_p = bigInteger;
        this.init_g = bigInteger2;
    }
}

