/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.BlockCipher;
import com.sun.net.ssl.internal.ssl.CbcBlockCipher;
import com.sun.net.ssl.internal.ssl.CipherRC4;
import com.sun.net.ssl.internal.ssl.CipherRC4_40;
import com.sun.net.ssl.internal.ssl.Des3Cipher;
import com.sun.net.ssl.internal.ssl.DesCipher;
import com.sun.net.ssl.internal.ssl.ExportControl;
import java.security.NoSuchAlgorithmException;

public abstract class CipherBox
implements c,
ExportControl {
    public abstract int decrypt(byte[] var1, int var2, int var3);

    public abstract int encrypt(byte[] var1, int var2, int var3);

    public int getCipherType() {
        return 0;
    }

    public int initVectorSize() {
        return 0;
    }

    public abstract int keyMaterialSize();

    public abstract int keySize();

    public static CipherBox newCipher(int n2, boolean bl2) {
        if (bl2) {
            switch (n2) {
                case 0: {
                    return new CipherNULL();
                }
                case 1: {
                    return new CipherRC4_40();
                }
                case 5: {
                    return new CipherDES_40();
                }
            }
            throw new IllegalArgumentException("Cipher type = " + n2 + ", exportable");
        }
        switch (n2) {
            case 1: {
                return new CipherRC4();
            }
            case 3: {
                return new CipherDES();
            }
            case 4: {
                return new Cipher3DES();
            }
        }
        throw new IllegalArgumentException("Cipher type = " + n2 + ", US Domestic");
    }

    public abstract CipherBox newCipherBox(byte[] var1, byte[] var2) throws NoSuchAlgorithmException;

    public static final class CipherNULL
    extends CipherBox {
        public int decrypt(byte[] byArray, int n2, int n3) {
            return n3;
        }

        public int encrypt(byte[] byArray, int n2, int n3) {
            return n3;
        }

        public int keyMaterialSize() {
            return 0;
        }

        public int keySize() {
            return 0;
        }

        public CipherBox newCipherBox(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
            return new CipherNULL();
        }

        public String toString() {
            return "NULL";
        }
    }

    private static abstract class BlockCipherBox
    extends CipherBox {
        public int blockSize = 8;

        public int addPadding(byte[] byArray, int n2, int n3) {
            int n4 = n3 + 1;
            if (n4 % this.blockSize != 0) {
                n4 += this.blockSize - 1;
                n4 -= n4 % this.blockSize;
            }
            int n5 = n4 - n3;
            if (byArray.length < n4) {
                throw new IllegalArgumentException("no space to pad buffer");
            }
            int n6 = 0;
            n2 += n3;
            while (n6 <= n5) {
                byArray[n2++] = (byte)(n5 - 1);
                ++n6;
            }
            return n4;
        }

        public int initVectorSize() {
            return this.blockSize;
        }

        public int removePadding(byte[] byArray, int n2, int n3) {
            int n4 = byArray[n2 + n3 - 1] & 0xFF;
            if (++n4 <= this.blockSize) {
                return n3 - n4;
            }
            return n3;
        }
    }

    private static abstract class AcmeCBC
    extends BlockCipherBox {
        public CbcBlockCipher cbc;

        public AcmeCBC() {
        }

        public AcmeCBC(BlockCipher blockCipher) {
            this.cbc = new CbcBlockCipher(blockCipher);
        }

        public int decrypt(byte[] byArray, int n2, int n3) {
            int n4 = n2;
            int n5 = 0;
            while (n5 < n3) {
                this.cbc.decrypt(byArray, n4, byArray, n4);
                n5 += this.blockSize;
                n4 += this.blockSize;
            }
            return this.removePadding(byArray, n2, n3);
        }

        public int encrypt(byte[] byArray, int n2, int n3) {
            int n4 = this.addPadding(byArray, n2, n3);
            int n5 = 0;
            while (n5 < n4) {
                this.cbc.encrypt(byArray, n2, byArray, n2);
                n5 += this.blockSize;
                n2 += this.blockSize;
            }
            return n4;
        }
    }

    private static final class CipherDES_40
    extends AcmeCBC {
        public CipherDES_40() {
        }

        private CipherDES_40(byte[] byArray, byte[] byArray2) {
            super(new DesCipher(byArray));
            this.cbc.setIv(byArray2);
        }

        public int keyMaterialSize() {
            return 5;
        }

        public int keySize() {
            return 8;
        }

        public CipherBox newCipherBox(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
            return new CipherDES_40(byArray, byArray2);
        }

        public String toString() {
            return "DES40_CBC";
        }
    }

    private static final class CipherDES
    extends AcmeCBC {
        public CipherDES() {
        }

        private CipherDES(byte[] byArray, byte[] byArray2) {
            super(new DesCipher(byArray));
            this.cbc.setIv(byArray2);
        }

        public int keyMaterialSize() {
            return 8;
        }

        public int keySize() {
            return 8;
        }

        public CipherBox newCipherBox(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
            return new CipherDES(byArray, byArray2);
        }

        public String toString() {
            return "DES_CBC";
        }
    }

    private static final class Cipher3DES
    extends AcmeCBC {
        public Cipher3DES() {
        }

        private Cipher3DES(byte[] byArray, byte[] byArray2) {
            super(new Des3Cipher(byArray));
            this.cbc.setIv(byArray2);
        }

        public int keyMaterialSize() {
            return 24;
        }

        public int keySize() {
            return 24;
        }

        public CipherBox newCipherBox(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
            return new Cipher3DES(byArray, byArray2);
        }

        public String toString() {
            return "3DES_EDE_CBC";
        }
    }
}

