/**
   SSLPolicyInt.java

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Wed May  5 08:47:37 1999

   This package is a SSLv3/TLS implementation written by Eric Rescorla
   <ekr@rtfm.com> and licensed by Claymore Systems, Inc.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. All advertising materials mentioning features or use of this software
      must display the following acknowledgement:
      This product includes software developed by Claymore Systems, Inc.
   4. Neither the name of Claymore Systems, Inc. nor the name of Eric
      Rescorla may be used to endorse or promote products derived from this
      software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.

   $Id: SSLPolicyInt.java,v 1.4 1999/06/22 06:24:57 ekr Exp $

*/

package COM.claymoresystems.sslg;

public class SSLPolicyInt extends Object {
     public static final short TLS_RSA_WITH_NULL_MD5                  =  0x0001 ;
     public static final short TLS_RSA_WITH_NULL_SHA                  =  0x0002 ;
     public static final short TLS_RSA_EXPORT_WITH_RC4_40_MD5         =  0x0003 ;
     public static final short TLS_RSA_WITH_RC4_128_MD5               =  0x0004 ;
     public static final short TLS_RSA_WITH_RC4_128_SHA               =  0x0005 ;
     public static final short TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5     =  0x0006 ;
     public static final short TLS_RSA_WITH_IDEA_CBC_SHA              =  0x0007 ;
     public static final short TLS_RSA_EXPORT_WITH_DES40_CBC_SHA      =  0x0008 ;
     public static final short TLS_RSA_WITH_DES_CBC_SHA               =  0x0009 ;
     public static final short TLS_RSA_WITH_3DES_EDE_CBC_SHA          =  0x000A ;
     public static final short TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA   =  0x000B ;
     public static final short TLS_DH_DSS_WITH_DES_CBC_SHA            =  0x000C ;
     public static final short TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA       =  0x000D ;
     public static final short TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA   =  0x000E ;
     public static final short TLS_DH_RSA_WITH_DES_CBC_SHA            =  0x000F ;
     public static final short TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA       =  0x0010 ;
     public static final short TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA  =  0x0011 ;
     public static final short TLS_DHE_DSS_WITH_DES_CBC_SHA           =  0x0012 ;
     public static final short TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA      =  0x0013 ;
     public static final short TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA  =  0x0014 ;
     public static final short TLS_DHE_RSA_WITH_DES_CBC_SHA           =  0x0015 ;
     public static final short TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA      =  0x0016 ;
     public static final short TLS_DH_anon_EXPORT_WITH_RC4_40_MD5     =  0x0017 ;
     public static final short TLS_DH_anon_WITH_RC4_128_MD5           =  0x0018 ;
     public static final short TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA  =  0x0019 ;
     public static final short TLS_DH_anon_WITH_DES_CBC_SHA           =  0x001A ;
     public static final short TLS_DH_anon_WITH_3DES_EDE_CBC_SHA      =  0x001B ;

     private boolean requireClientAuth=false;
     private short[] cipherSuites={
	  TLS_DHE_DSS_WITH_DES_CBC_SHA,
	  TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA,
	  TLS_RSA_WITH_3DES_EDE_CBC_SHA,
	  TLS_RSA_WITH_DES_CBC_SHA,
	  TLS_RSA_WITH_RC4_128_MD5,
	  TLS_RSA_WITH_RC4_128_SHA,
	  TLS_RSA_EXPORT_WITH_RC4_40_MD5,
	  TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5,
	  TLS_RSA_EXPORT_WITH_DES40_CBC_SHA
     };
     
     private boolean negotiateTLS=true;
     private byte[][] rootCertificates=null;
     private int sessionLife=86400;
     private boolean acceptUnverifiable=false;
     
     /** Set whether or not to require client authentication when
	 negotiating (this is relevant only for servers)

	 @param val a boolean specifying whether client auth is required. The default is no
     */
     public void requireClientAuth(boolean val) {
       requireClientAuth=val;
     }

     /** Get whether client auth is required. This is relevant only
	 for servers

	 @return val a boolean indicating whether client auth is required
     */
     public boolean requireClientAuthP(){
       return requireClientAuth;
     }

     /** Specify which cipherSuites may be negotiated.
	 <P>
	 Currently there is no check made as to whether these cipherSuites
	 are in fact negotiatable given the current keying material. This
	 is a bug.
	 <P>
	 Currently supported cipher suites:
	 <PRE>
	 TLS_DHE_DSS_EXPORT_WITH_DES40_RSA
	 TLS_DHE_DSS_WITH_DES_CBC_SHA
	 TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA
	 TLS_RSA_WITH_3DES_EDE_CBC_SHA,
	 TLS_RSA_WITH_DES_CBC_SHA,
	 TLS_RSA_WITH_RC4_128_MD5,
	 TLS_RSA_WITH_RC4_128_SHA,
	 TLS_RSA_EXPORT_WITH_RC4_40_MD5,
	 TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5,
	 TLS_RSA_EXPORT_WITH_DES40_CBC_SHA
	 </PRE>
	 @param cS the list of allowed cipherSuites as an array of shorts. The values are specified as constants in this class
     */
     public void setCipherSuites(short[] cS){
       cipherSuites=cS;
     }

     /** Return the allowed cipherSuites

	 @return a short[] containing all the cipherSuites currently allowed
     */
     public short[] getCipherSuites(){
       return(cipherSuites);
     }

     /** Set whether to try to negotiate TLS. IF this value is false,
	 SSLv3 will be negotiated. The default is true/yes.

	 @param tls a boolean indicating whether to try to negotiate TLS
     */
     public void negotiateTLS(boolean tls) {
       negotiateTLS=true;
     }

     /** return whether TLS is to be negotiated

	 @return a boolean indicating whether TLS negotiation is attempted.
     */
     public boolean negotiateTLSP(){
       return negotiateTLS;
     }

     /** Set the lifetime of a cached session. Any attempt to resume a
	 session after it has expired will fail. This has no effect on
	 sessions that are currently active, however.

	 @param lifetime lifetime of a cached session in seconds. Default is 86400 (1 day)
     */
     public void setSessonLifetime(int lifetime){
       sessionLife=lifetime;
     }

     /** return the lifetime of a session

	 @return the lifetime setting, in seconds
     */
     public int getSessionLifetime(){
       return sessionLife;
     }

     /** allow unverifiable certificates. If we encounter a certificate
	 which cannot be verified by a known root, we ordinarily reject,
	 but this accepts that behavior to be overridden. The value of
	 getCertificateChain() will be null.
	 <P>
	 Setting this value to true completely compromises security against
	 active attack. This should only be used for testing purposes.

	 @param accept a boolean indicating whether unverifiable certificates should be accepted
     */

     public void acceptUnverifiableCertificates(boolean accept){
       acceptUnverifiable=accept;
     }


     /** return whether unverifiable certificates are accepted

	 @return a boolean indicating whether unverifiable certs will be accepted
     */
     public boolean acceptUnverifiableCertificatesP(){
       return acceptUnverifiable;
     }
       
}
