//
// lmath.hxx
//
// fun with LIntegers!
//
// Leonard Janke
// August 1996

#ifndef _LMATH_HXX
#define _LMATH_HXX
#include "linteger.hxx"
#include "monty.hxx"

class LMath
{
private:
  static int LUByte(unsigned int* base, int index);

  static int FirstNonZeroByte(const unsigned int a);
  
  static inline int ZIndexToOffset(const int index, const int zSize);

public:
  static inline int CompareMagnitudes(const LInteger&, const LInteger&);

  static inline LInteger Negative(const LInteger&);

  static inline LInteger AbsoluteValue(const LInteger&);

  static LInteger TwoToThe(const int);
  
  static void LongDivide(const LInteger&, const LInteger&, LInteger&, 
			 LInteger&);

  static LInteger ModExp(const LInteger&, const LInteger&, const LInteger&n);

  static LInteger SpecialModExp(const LInteger&, const LInteger&, const LInteger&);

  static LInteger ExtendedEuclid(const LInteger&, const LInteger&, LInteger&, 
				 LInteger&);
};

#include "lmath.inl"

#endif
