/*
**	ssh_msg.h	-- ssh message types (as per v1.5 protocol)
**		please see protocol specificatons for more information
**		(draft-ylonen-ssh-protocol-00.txt, 15 November 1995)
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
**		
*/

#ifndef __SSH_MSG_H
#define __SSH_MSG_H

#include "ssh_types.h"

/*
**	SSH_MSG_*	messages sent by both client and server
**	SSH_SMSG_*	messages sent by only the server
**	SSH_CMSG_*	messages sent by only the client
*/
#define SSH_MSG_ERROR		-2	/* error with message */
#define SSH_MSG_NOTYPE		-1	/* my own one that's never used */
#define SSH_MSG_NONE		0	/* all, reserved, never sent */
#define SSH_MSG_DISCONNECT	1	/* all, disconnection, plus str */
#define SSH_SMSG_PUBLIC_KEY	2	/* server, first message */
#define SSH_CMSG_SESSION_KEY	3	/* client, first message */
#define SSH_CMSG_USER		4	/* client, user to authenticate */
#define SSH_CMSG_AUTH_RHOSTS	5	/* client, request .rhosts auth */
#define SSH_CMSG_AUTH_RSA	6	/* client, auth using RSA */
#define SSH_SMSG_AUTH_RSA_CHALLENGE	7	/* server, rsa auth challenge */
#define SSH_CMSG_AUTH_RSA_RESPONSE	8	/* client, response to challenge */
#define SSH_CMSG_AUTH_PASSWORD	9	/* client, request passwd auth */
#define SSH_CMSG_REQUEST_PTY	10	/* client, requests a pty */
#define SSH_CMSG_WINDOW_SIZE	11	/* client, update screen size */
#define SSH_CMSG_EXEC_SHELL	12	/* client, start a shell */
#define SSH_CMSG_EXEC_CMD	13	/* client, starts exec'ing command */
#define SSH_SMSG_SUCCESS	14	/* server, success! */
#define SSH_SMSG_FAILURE	15	/* server, failure :( */
#define SSH_CMSG_STDIN_DATA	16	/* client, stdin data to server */
#define SSH_SMSG_STDOUT_DATA	17	/* server, stdout data from serv */
#define SSH_SMSG_STDERR_DATA	18	/* server, stderr data */
#define SSH_CMSG_EOF		19	/* client, eof in input */
#define SSH_SMSG_EXITSTATUS	20	/* server, command exit status */
#define SSH_MSG_CHANNEL_OPEN_CONFIRMATION	21	/* all, channel opened ok */
#define SSH_MSG_CHANNEL_OPEN_FAILURE		22	/* all, channel open failed */
#define SSH_MSG_CHANNEL_DATA			23	/* all, data into channel */
#define SSH_MSG_CHANNEL_CLOSE			24	/* all, closing channel */
#define SSH_MSG_CHANNEL_CLOSE_CONFIRMATION	25	/* all, confirm chan close */
#define SSH_MSG_OBSOLTETED_MESSAGE	26	/* all, osoleted */
#define SSH_SMSG_X11_OPEN		27	/* server, fake x-serv up */
#define SSH_CMSG_PORT_FORWARD_REQUEST	28	/* client, req forwarded port */
#define SSH_MSG_PORT_OPEN		29	/* all, conn over fwd port */
#define SSH_CMSG_AGENT_REQUEST_FORWARDING	30	/* client, req auth fwding */
#define SSH_SMSG_AGENT_OPEN		31	/* server, req auth chan */
#define SSH_MSG_IGNORE			32	/* all, ignore this */
#define SSH_CMSG_EXIT_CONFIRMATION	33	/* client, last message */
#define SSH_CMSG_X11_REQUEST_FORWARDING	34	/* client, req fake X11 */
#define SSH_CMSG_AUTH_RHOSTS_RSA	35	/* client, req .rhosts auth */
#define SSH_MSG_DEBUG			36	/* all, debugging messages */
#define SSH_CMSG_REQUEST_COMPRESSION	37	/* client, req use of gzip */
#define SSH_CMSG_MAX_PACKET_SIZE	38	/* client, max packet size */
#define SSH_CMSH_AUTH_TIS		39	/* client, start TIS auth */
#define SSH_SMGS_AUTH_TIS_CHALLENGE	40	/* server, TIS challenge */
#define SSH_CMSG_AUTH_TIS_RESPONSE	41	/* client, response to above */
#define SSH_CMSG_AUTH_KERBEROS		42	/* client, req kerberos */
#define SSH_SMSG_AUTH_KERBEROS_RESPONSE	43	/* server, response to req */
#define SSH_CMSG_HAVE_KERBEROS_TGT	44	/* client, kerberos info */

#ifdef __cplusplus
extern "C" {
#endif

/*
**	And let's define some general messages
*/
int ssh_msg_disconnect_encode(uint8_t * data, uint32_t * data_len,
	uint8_t * reason);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_MSG_H */

