/*
**	ssh_mp_stream.h	-- header file for dealing with strings in a stream
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**	See the LICENSE file.
*/

#ifndef __SSH_MP_STREAM_H
#define __SSH_MP_STREAM_H

#include "ssh.h"
#include "ssh_util.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
**	convert between SSHv1.5 strings and a char *
*/
int string_to_stream(uint8_t * stream, const uint8_t * str);
int string_to_stream_n(uint8_t * stream, const uint8_t * str, uint32_t length,
	int stream_size);
int string_from_stream(const uint8_t * stream, uint8_t * str, int str_size);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_MP_STREAM_H */

