#define SCRAMBLE_READ 0
#define SCRAMBLE_WRITE 1

#include <stdlib.h>

// Note that SQUARE is a separately compiled linked object,
// declared in the make file "sd.mak"
// This is due to a data type conflict which isn't easy to
// resolve.....

extern void squareinitialise(char *keyin, int slot);
extern void squareencipher(unsigned long *buffer,int slot);
extern void squaredecipher(unsigned long *buffer,int slot);

#include "tea_asm.c"
#include "idea.c"
#include "misty1.c"
//#dinclude "des/des.c"
#include "desAsm.c"

#include "blowfish.c"





/*
 WhiTable is a pointer to the 1k "summer"/whitening table, 
 This routine generates the IV (left) and IV(Right) for each sector.
 lower 64 bits is IV It also generates XOR 'whitening' values to xor 
the cipher text with *JUST* before or after it is written/read 
to from disk. This can be found in the upper 64 bits summed


Parameters:
temp_block is the current SECTOR block being dealt with.
l and r are pointers to the address of the variables whick will contain the IV (left) and IV(right) values...
cbccl and cbccr are pointers which contain the addresses of
variables which will be set to the so called "whitening" values.

cbccl= cipher block chaining constant left
cbccl= cipher block chaining constant right

*/

void getiv64(int *l,int *r,int *cbccl,int *cbccr,int temp_block,char *WhiTable)
{


_asm
    {




	mov ecx,[temp_block]
    //inc [temp_block]
	mov esi,[WhiTable]

	;ecx=sector number.....

	pushad
	push ebp

	xor eax,eax
	xor edx,edx
	xor ebp,ebp
	xor edi,edi

		 
	mov ebx,32
		

formIVW:
	
	push esi
	shr ecx,1
	jnc nohigh
	add esi,16
nohigh:


	add eax,[esi]			  ;96 bits........
	adc edx,[esi+4]
	adc ebp,[esi+8]	  		  ;....
	adc edi,[esi+12]
	
	pop esi
	add esi,32
	dec ebx
	jnz formIVW	
    mov ecx,ebp
	pop ebp
	mov esi,[cbccl]
	mov [esi],ecx
	mov esi,[cbccr]
	mov [esi],edi
	mov esi,[l]
	mov [esi],eax
	mov esi,[r]
	mov [esi],edx
	popad
	}


}



	void cipherblockwr(int cipher,int index,unsigned long * buffer,char *WhiTable,int tempblock,int numsectors)

	{

	
		char *temp;

		int ivl,ivr;

		int cbccl,cbccr;
		int n;


		int bl=2;

		if (cipher==SQUARE) bl=4;

		while (numsectors)
		{

			getiv64(&ivl,&ivr,&cbccl,&cbccr,tempblock,WhiTable);
			
	
			for (n=0;n<128;n=n+bl) // sector scrambler...
				{
				buffer[n]=ivl^buffer[n];
				buffer[n+1]=ivr^buffer[n+1];
				
				switch (cipher)
				{
				
				case BLOWFISH:
				Blowfish_encipher(&buffer[n],&buffer[n+1],index);
				break;


				case TEA16:
				case TEA32:
				teaencipher(&buffer[n],index);
				break;

				case IDEA:
				ideaencipher(&buffer[n],index);
				break;


				case DES56:
				desencipher(&buffer[n],index);
				break;

				case SQUARE:
				squareencipher(&buffer[n],index);
				break;


				case MISTY1:
				mistyencipher(&buffer[n],index);
				break;
	
				case THREEDES:
				threedesencipher(&buffer[n],index);
				break;

				}
				ivl=buffer[n];
				ivr=buffer[n+1];
			
				buffer[n]^=cbccl;
				buffer[n+1]^=cbccr;
			
			
			   }
		 tempblock++;
		 numsectors--;
		 
		 temp=(char *)buffer;
		 temp+=512;
		 buffer=(unsigned long *) temp;

		}

	}


	void cipherblockrd(int cipher,int index,unsigned long * buffer,char *WhiTable,int tempblock,int numsectors)

	{

		char *temp;

		int ivl,ivr,ivl2,ivr2,cbccl,cbccr;

		int n;
		int bl=2;


		if (cipher==SQUARE) bl=4;

		while (numsectors)
		{

			getiv64(&ivl,&ivr,&cbccl,&cbccr,tempblock,WhiTable);


		//	ivl=1;
		//	ivr=2;



			for (n=0;n<128;n=n+bl) // sector scrambler...
				{

			buffer[n]^=cbccl;
			buffer[n+1]^=cbccr;
			
			ivl2=buffer[n];
			ivr2=buffer[n+1];

			switch (cipher)
				{
				
				case BLOWFISH:
				Blowfish_decipher(&buffer[n],&buffer[n+1],index);
				break;
				case TEA16:
				case TEA32:
				teadecipher(&buffer[n],index);
				break;

				case IDEA:
				ideadecipher(&buffer[n],index);
				break;

				case DES56:
				desdecipher(&buffer[n],index);
				break;
				
				case SQUARE:
				squaredecipher(&buffer[n],index);
				break;


				case MISTY1:
				mistydecipher(&buffer[n],index);
				break;

				case THREEDES:
				threedesdecipher(&buffer[n],index);
				break;

			    }


			buffer[n]=ivl^buffer[n];
			buffer[n+1]=ivr^buffer[n+1];
		
			ivl=ivl2;
			ivr=ivr2;
				}
		 tempblock++;
		 numsectors--;
		 
		 temp=(char *)buffer;
		 temp+=512;
		 buffer=(unsigned long *) temp;

		}

	}
	
//This is the main entry point when doing scramdisk disk IO to 
//cipher/decipher the disk buffer.

// parameters:

// wr is the mode, SCRAMBLE_READ or SCRAMBLE_WRITE
//buffer is a pointer to the data buffer on read it will contain //scrambled data on entry and clear on exit. Write= vice versa

//cv is a structure containing info about the mounted disk.
// EG partition and physical device or filename/handle
// Here  members "index" and "cipher" are the ones we are 
//interested in. "cipher" is BLOWFISH, SQUARE etc.
// Index is the zero based slot where the device is to be found.
//0..3    This allows the cipher alogorithm code to pick the 
	
//correct key schedule for the particular disk being dealt with.


// Char * WhiTable
// This 1K summer table is simply used to generate IVs and whitening values for 
//EACH sector. The values need to be correct.
//tempblock is the sector number we are starting at. (bad name choice)

//numsectors is the number of 512 bytesectors to do. (always assumes //512 bytes a sector. Container files can be held on stuff which is //different.. handled by the OS

	void cipherblock(int wr,cryptvol *cv,unsigned long * buffer,char *WhiTable,int tempblock,int numsectors)

	{
		
		int index=cv->index;
		 
			if (wr==SCRAMBLE_WRITE)
				{
				cipherblockwr(cv->cipher,index,buffer,WhiTable,tempblock,numsectors);
				return;
				}
		
			if (wr==SCRAMBLE_READ)
					cipherblockrd(cv->cipher,index,buffer,WhiTable,tempblock,numsectors);
	}









int	ApplicationNameSet(char * name,char *dir,char *nin)

{

	
	char *i=nin;
	char *o1=name;
	char *o2=dir;
	char ch;
	unsigned int c;
	if (strlen(nin)>=128) return 1;
	
    // sometimes the string has quotes. Unless of course we are in the debugger. Another MS bug!
	for (c=0;c<strlen(nin);c++)
	{

		ch=i[c];
		
		if ((ch!=34)&&(ch>32))    //may need testing.......
				{
					o1[0]=ch;
					o2[0]=ch;
					o1++;
					o2++;
				}
	
		o1[1]=0;
		o2[1]=0;
		
	}




	c=strlen(dir)-1;

	do
	{
		if (dir[c-1]=='\\')
					{
						dir[c]=0;
						break;
					}
		c--;

	}
	while (c>0);

	return 0;
}



/*
			
void xwaitframe(void) // Debugging code....

{

 _asm
 {


	 pushad
;Wait_FlyBack:
	  	mov	dx,03dah
b3:
		in     al,dx
		test   al,8	  ;wait for end of current fly back if in border
		jnz b3
b4:
		in     al,dx
		test   al,8	  ;wait for end of display time
		jz b4

b5:
		in     al,dx
		test   al,8	  ;wait for start of next of display time
		jnz b5

		popad		

 }

}

*/
void sectorcopy(char* dest,char *source, int num)

{

 _asm
 {
 pushad
 mov edi,[dest]
 mov esi,[source]
 mov ecx,[num]
 shl ecx,9		//*512
 sar ecx,4		//16 in pass...
cpylp:
 mov eax,[esi]
 mov ebx,[esi+4]
 mov [edi],eax
 mov [edi+4],ebx
 mov eax,[esi+8]
 mov ebx,[esi+12]
 mov [edi+8],eax
 mov [edi+12],ebx
 add edi,16
 add esi,16
 dec ecx
 jnz cpylp
 popad
 }

}





  
void borderflash(void) // Debugging aid code....

{
	_asm

	{
		pushad
		mov eax,[border]
        add [border],0x01010101
		push edx
        push eax
		mov dx,0x3c6
		mov al,255
		out dx,al
		mov dl,0c8h
		xor ax,ax
		out dx,al
		inc dx
		pop eax

		shr al,2
		out dx,al
		shr eax,8
		out dx,al
		shr eax,8
		out dx,al
		pop edx
		
		popad

     }

}


void InitializeCipher(char *blin,short keylen,cryptvol *cv) // cv->index);  //DISK....
{

  unsigned char blowkey[]="abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz   ";
  if (cv==&cv1) cv->index=0;
  if (cv==&cv2) cv->index=1;
  if (cv==&cv3) cv->index=2;
  if (cv==&cv4) cv->index=3;
  
  memset (&blowkey[0],0,36);
  memcpy(&blowkey[0],blin,keylen);
  if (cv->cipher==BLOWFISH) InitializeBlowfish (blowkey,keylen,cv->index);
  if (cv->cipher==TEA16) inittea((unsigned long *) &blowkey,cv->index,16);
  if (cv->cipher==TEA32) inittea((unsigned long *) &blowkey,cv->index,32);
  if (cv->cipher==IDEA) ideainitialize ((unsigned long *) &blowkey,cv->index);
  if (cv->cipher==DES56) desinitialise((char *) &blowkey,cv->index);
  if (cv->cipher==SQUARE) squareinitialise((char *)&blowkey,cv->index);
  if (cv->cipher==MISTY1) mistyinitialize((unsigned long *)&blowkey,cv->index);
  if (cv->cipher==THREEDES) threedesinitialise((char *) &blowkey,cv->index);
}

// The main biz code....
void scramble (int wr,cryptvol* cv,char * buffer,char *keys,unsigned int temp_block,unsigned int num_sectors)

{
		
	if (cv->cipher!=SUMMEROLD)// 00 is old summer
	{
		cipherblock(wr,cv,(unsigned long *)buffer,keys,temp_block,num_sectors);
		return;

	}

	// Only come here, if using fast but simple summer scrambler (#0)
_asm
    {   
	 pushfd
     pushad

keylpv31:

	push ebp
	mov eax,[buffer]
	push eax
	mov ecx,[temp_block]
    inc [temp_block]
	mov esi,[keys]

	;ecx=sector number.....
	xor eax,eax
	xor edx,edx
	xor ebp,ebp
	xor edi,edi

		 
	mov ebx,32
		

formkey:
	
	push esi
	shr ecx,1
	jnc nohigh
	add esi,16
nohigh:


	add eax,[esi]			  
	adc edx,[esi+4]
	adc ebp,[esi+8]	  		  
	adc edi,[esi+12]
	pop esi
	add esi,32
	dec ebx
	jnz formkey	

	mov ecx,512/16 ;4
	
	pop esi   ;address of buffer.....


	;rnd
		
	  add eax,eax
	  adc edi,eax
	  adc ebp,edi
	  adc edx,ebp
	  xor eax,edx

again3:	      
	add eax,eax
	adc edi,eax
	adc ebp,edi
	adc edx,ebp
	xor eax,edx

	xor [esi],edx

	add eax,eax
	adc edi,eax
	adc ebp,edi
	adc edx,ebp
	xor eax,edx	

	xor [esi+4],edx
	
	add eax,eax
	adc edi,eax
	adc ebp,edi
	adc edx,ebp
	xor eax,edx

	xor [esi+8],edx
	
	add eax,eax
	adc edi,eax
	adc ebp,edi
	adc edx,ebp
	xor eax,edx
	xor [esi+12],edx
	add esi,16
	dec ecx
	jnz again3
    
	POP EBP
	add [buffer],512
	dec [num_sectors]
	jnz keylpv31
	
	popad
	popfd

   }//asm

}







#pragma VxD_LOCKED_CODE_SEG
void readanddecodeblock(PIOP iop,int temp_block,int num_sectors,char *buffer,cryptvol *cv)
{
  unsigned short *mainkeypointer=(unsigned short*) &(cv->mainkeys);
  unsigned int onekey=temp_block;
  temp_block+=16;
  dophysblock(iop,(temp_block+cv->cryptsectorfirst),num_sectors,buffer,cv,IOR_READ);
  scramble(SCRAMBLE_READ,cv,buffer,(char *)mainkeypointer,onekey,num_sectors);

}




#pragma VxD_LOCKED_CODE_SEG
void readlogical(PIOP iop,int sectorstart,int sectorcount,char *buffer, cryptvol * cv)

{
		 readanddecodeblock(iop,sectorstart,sectorcount,buffer,cv);
}

/**** write code ****/

#pragma VxD_LOCKED_CODE_SEG
int encodeandwriteblock(PIOP iop,int temp_block,int num_sectors,char* buffer,cryptvol* cv)
{
  unsigned short *mainkeypointer=(unsigned short*) &(cv->mainkeys);
  unsigned int onekey=temp_block;
  int numsectwrite=num_sectors;
  char * outbuffer=buffer;  
  PDCB mydcb= (PDCB) iop->IOP_physical_dcb;
  temp_block+=16;
  scramble(SCRAMBLE_WRITE,cv,buffer,(char *) mainkeypointer,onekey,num_sectors);
  dophysblock(iop,(temp_block+cv->cryptsectorfirst),numsectwrite,outbuffer,cv,IOR_WRITE);
  return 0;
}


#pragma VxD_LOCKED_CODE_SEG

void writelogical(PIOP iop,int sectorstart,int sectorcount,char *buffer, cryptvol * cv)

/*data must have been copied into a cryptvol buffer before scrambling........*/

{
	   encodeandwriteblock(iop,sectorstart,sectorcount,buffer,cv);	   
} /*  end write/scramble routine*/


#pragma VxD_LOCKED_CODE_SEG

void mangle_passwords(char * passwordptr)
//What happens to the password texts before they are used ?
// Here's what!
// This is only used for the simple Summer scrambler.
// Other algorithms use a SHA1 digest value posted from the WIN32 App
// Scramdisk.exe....
{
unsigned int * shc=(unsigned int *) &shift_constants;
	
	_asm
	{
		mov ebx,[passwordptr] ; pointer to current password under test
		xor ax,ax
		mov ecx,160/2
mplp:		
		add ax,[ebx]	    ;
		add ebx,2
		dec ecx
		jnz mplp
		
		or ax,ax	    ;null password
		jz mpout

		and eax,01fffh
		add eax,2000h
mplp2:
		push eax
		call big_shift
		pop  eax
		dec eax
		jnz mplp2
		or ax,1
mpout:			
		jmp bsdone
	
BIG_SHIFT:
        MOV EBX,[passwordptr]		
		MOV ECX,40
		CLC
mpMORE:				
		MOV EAX,[EBX]
		ADC EAX,EAX
		MOV [EBX],EAX
		INC EBX
		INC EBX
		INC EBX
		INC EBX
		DEC ECX
		JNZ mpMORE				
		JNC mpxOUT
        MOV EBX,[passwordptr]
		MOV ESI,[shc]
		MOV ECX,40
mpxXOR:	
		MOV EAX,[EBX]
		XOR EAX,[ESI]
		MOV [EBX],EAX
		ADD EBX,4
		ADD ESI,4
		DEC ECX
		JNZ mpxXOR
		
mpxOUT:
		ret
					
bsdone:

	}

}

#pragma VxD_LOCKED_CODE_SEG

/* compare two sector buffers for equality*/
int cmpsector(char * ba,char * bb)
{
  int x=1;
  int c;
  for (c=0;c<512;c++)
     {
	  if ((*ba)!=(*bb)) 
	  x=0;
      ba++;
	  bb++;
	 }
  return x;
}

#pragma VxD_LOCKED_CODE_SEG
/*clear a sector. Used for returning null boot sector when no password*/
void clsec(PIOP iop,char * sec)
{
  int c;
  for (c=0;c<512;c++) *(sec+c)=0;
  iop->IOP_ior.IOR_status=0; 
}



void copyvolname(bpb* b,cryptvol * cv)
{
int c;
char *i;
char *o;
//char ch;

i=(char *)&b->volname;
o=(char *) &cv->volname;

memcpy (o,i,11);

for (c=1;c<12;c++)
	{
	if ( (o[c]>='A')&&(o[c]<='Z') ) o[c]|=32;
	}

for (c=10;c>=0;c--)
	{
	if (o[c]!=32) break;
	else o[c]=0;
	}

}


typedef struct infostruct
{
char infotext[256];
int accessed;
int preferredletter;
int magiclow;
int magichigh;
int reserved[60];

}infostruct;
  

  void incrementaccesscount(PIOP iop,char *sectorbuffer,cryptvol *cv)
  {
  	  
	  infostruct* i=(infostruct *)sectorbuffer;
	  initialiseWPerror=0;
	  readlogical (iop,3,1,sectorbuffer,cv);
	  prefdrive=-1;

	  if ((i->magiclow==0xa852c732)&&(i->magichigh==0xb1593286))
	  {

		  i->accessed++;
		  prefdrive=i->preferredletter;

	  }

	  else // This is done, if the disk isn't initialised...

	  {
         i->magiclow=0xa852c732;
         i->magichigh=0xb1593286;
		 i->accessed=1;
         i->preferredletter=0-'A';
		 strcpy((char *)&i->infotext,"No information entered");
       
	  }
 writelogical (iop,3,1,sectorbuffer,cv);


}

void DeCipherKeys(unsigned long * buffer,cryptvol* cv)
{
// The opposite of this can be found in the WIN32 APP format code
// This deciphers the whitening table, and the ENCRYPTION KEY
// with the chosen cipher
int ivl2;
int ivr2;
int n;				
int ivr=0; //CBC starts at 0 on this occasion
int ivl=0;
int bl=2;

	if (cv->cipher==SQUARE) bl=4;


		   // 128= 512 bytes We are doing 2Kbytes
	for (n=0;n<128*4;n=n+bl) // was n+2 sector scrambler...
			{
			ivl2=buffer[n];
			ivr2=buffer[n+1];

		
			if (cv->cipher==BLOWFISH)
			      Blowfish_decipher(&buffer[n],&buffer[n+1],cv->index);

			if ( (cv->cipher==TEA16)|| (cv->cipher==TEA32))
			      teadecipher(&buffer[n],cv->index);

			 if(cv->cipher==IDEA)
				   ideadecipher(&buffer[n],cv->index);

			 if (cv->cipher==DES56)
				 desdecipher(&buffer[n],cv->index);

			 if (cv->cipher==SQUARE)
				 squaredecipher(&buffer[n],cv->index);

			 if (cv->cipher==MISTY1)
				 mistydecipher(&buffer[n],cv->index);
 
			 if (cv->cipher==THREEDES)
				 threedesdecipher(&buffer[n],cv->index);
			
			buffer[n]=ivl^buffer[n];
			buffer[n+1]=ivr^buffer[n+1];
		
			ivl=ivl2;
			ivr=ivr2;
		}

    }


/*this  reads the keys, decrypts with password, and tests the volume.
 returns true, if successfull, to allow trying more than one password
 The digest value is given by WIN32 app
 The extcritical data (including the ciphers decryption key can be pointed
 from elswhere, this allowing the disk to be deciphered from data OTHER than
 the password it was formatted with. It assumes that a deciphered copy of
 the critical data, has been presented to it, rather than a digest of 
 passwords, or the passwords themselves, in the case of simple summer
*/

#pragma VxD_LOCKED_CODE_SEG
int decodeintialkeys(PIOP iop,cryptvol *cv, char* passwordptr,char *digestptr,char *extcritical)
{

int ci;
unsigned char tkey[36]="abcdefghijklmnopqrstuvwxyz123456"; //blowfish only
char *buffer=tempkeybuffer;	//TEMP.........
char* ukey=(char*) &ptbuffer;
unsigned char* sec=(char *) iop->IOP_ior.IOR_buffer_ptr;  
bpb * b;
char * z=sectorbuffer+11;
b=(bpb *) z;

   if (cv->booted) return 1;
   
   /* read in 4 sectors (2k) of keys from start of crypted partition */
 
   // Did the user post any SHA1 digests/passwords ?

	if (keysposted)
    {
     dophysblock(iop,cv->cryptsectorfirst,4,buffer,cv,IOR_READ);
			
	if (extcritical!=0)	memcpy(buffer,extcritical,2048); 

	for (ci=0;ci<MAXCIPHER;ci++) // Try EVERY cipher.....

	   {
	   buffer=tempkeybuffer; // reset buffer.......
	   cv->cipher=ci;        // cet cipher
	   memcpy((char *) &cv->mainkeys,buffer,2048);   
	   buffer=(char *) &cv->mainkeys;  // NOW buffer=cv structure

	   if (extcritical==0) // Only deal with passwords and digests
						  // if there is no external critical data set
	   {

     
      if ( ci==0 ) // ci= 0 ONLY on the simple summer scrambler.....
        {
        memcpy(ukey,passwordptr,40*4);
        mangle_passwords(ukey);
	   _asm
		  {
		   mov ah,32
		   mov esi,[buffer] ;address of keytable in cv structure
		   mov ebx,[ukey]   ;address of passwords after mangling
		   mov ecx,2048
		   xor edx,edx
dkeyloop:
		   mov al,[esi]
		   xor al,[edx+ebx]
		   mov [esi],al
		   inc esi
		   inc dl
		   cmp dl,ah
		   jl dkok
		   xor dl,dl
dkok:
		   dec ecx
		   jnz dkeyloop
		   }

	     }

         else // An industry standard cipher is being tried....
        {
	     memcpy(&tkey[0],digestptr,20); 
	     InitializeCipher( (char *) &tkey,20,cv) ;//cv->index);  //DISK..
         DeCipherKeys((unsigned long *)buffer,cv);
	     memcpy(&tkey[0],(char *) &cv->mainkeys+1024,32); // (160-32),32); 
	     InitializeCipher( (char *) &tkey,32,cv); // The key....
        }

	}	// if (!extcritical)


	else		// external data posted in from key disk....
	{
		 if (ci!=0)
		 {
		 memcpy(&tkey[0],(char *) &cv->mainkeys+1024,32); // (160-32),32); 
	     InitializeCipher( (char *) &tkey,32,cv); // The key....
		 }

	}

        iop->IOP_ior.IOR_status=0;
        buffer+=1024+512;
        readlogical(iop,0,1,buffer,cv);
        if (1)  // modified
        {
	     readlogical (iop,1,1,sectorbuffer,cv);
          if (cmpsector(sectorbuffer,buffer)!=0) 
            { 
			 readlogical (iop,2,1,sectorbuffer,cv);
              if (cmpsector(sectorbuffer,buffer)!=0) 
			    {
				      // now increase the encrypted count of how many
				      // times we have opened the disk drive...
				      // Available in RH mouse click on disk icon...
               		  incrementaccesscount(iop,sectorbuffer,cv);
					   cv->booted=1; // initial boot state to cryptvol struct
					   //now read boot sector to get volname and perhaps BPB
					  readlogical (iop,4,1,sectorbuffer,cv); //boot sector.	I hope!
					  copyvolname(b,cv);
                      return 1;  // Signal can mount a new volume
			     }
 
		    }
		 
		}
   }// for cipher..
   
}//keys posted
return 0;     // Signal no volume mounted.....
}

