
/*********************blowfish.c*********************/


/* TODO: test with zero length key */
/* TODO: test with a through z as key and plain text */
/* TODO: make this byte order independent */

#include <stdio.h>		/* used for debugging */
#ifdef MACINTOSH
   #include <Types.h>		/* FIXME: do we need this? */
#endif

#include "blowfish.h"
#include "bf_tab.h"		/* P-box P-array, S-box  */




#define S(x,i,d) (bf_S[d][i][x.w.byte##i])

//#define S(x,i) (bf_Sa[i][x.w.byte##i])
// d=disk

#define bf_F(x,d) (((S(x,0,d) + S(x,1,d)) ^ S(x,2,d)) + S(x,3,d))

#define ROUND(a,b,n,d) (a.word ^= bf_F(b,d) ^ bf_P[d][n])

//inline
void Blowfish_encipher(UWORD_32bits *xl, UWORD_32bits *xr,int slot)
{
  union aword  Xl;
  union aword  Xr;
  register int d=slot;

  
  //disk=slot;
 
  Xl.word = *xl;
  Xr.word = *xr;

  Xl.word ^= bf_P[d][0];
  ROUND (Xr, Xl, 1,d);  
  ROUND (Xl, Xr, 2,d);
  ROUND (Xr, Xl, 3,d);  
  ROUND (Xl, Xr, 4,d);
  ROUND (Xr, Xl, 5,d);  
  ROUND (Xl, Xr, 6,d);
  ROUND (Xr, Xl, 7,d); 
  ROUND (Xl, Xr, 8,d);
  ROUND (Xr, Xl, 9,d); 
  ROUND (Xl, Xr, 10,d);
  ROUND (Xr, Xl, 11,d);
  ROUND (Xl, Xr, 12,d);
  ROUND (Xr, Xl, 13,d); 
  ROUND (Xl, Xr, 14,d);
  ROUND (Xr, Xl, 15,d); 
  ROUND (Xl, Xr, 16,d);
  Xr.word ^= bf_P[d][17];

  *xr = Xl.word;
  *xl = Xr.word;
}

void Blowfish_decipher(UWORD_32bits *xl, UWORD_32bits *xr,int slot)
{
   union aword  Xl;
   union aword  Xr;
	register int d=slot;

    Xl.word = *xl;
    Xr.word = *xr;  // had to add ".word" to each of these...
	//disk=slot;
	
   Xl.word ^= bf_P[d][17];
   ROUND (Xr, Xl, 16,d);  ROUND (Xl, Xr, 15,d);
   ROUND (Xr, Xl, 14,d);  ROUND (Xl, Xr, 13,d);
   ROUND (Xr, Xl, 12,d);  ROUND (Xl, Xr, 11,d);
   ROUND (Xr, Xl, 10,d);  ROUND (Xl, Xr, 9,d);
   ROUND (Xr, Xl, 8,d);   ROUND (Xl, Xr, 7,d);
   ROUND (Xr, Xl, 6,d);   ROUND (Xl, Xr, 5,d);
   ROUND (Xr, Xl, 4,d);   ROUND (Xl, Xr, 3,d);
   ROUND (Xr, Xl, 2,d);   ROUND (Xl, Xr, 1,d);
   Xr.word ^= bf_P[d][0];

   *xl = Xr.word;
   *xr = Xl.word;
}

/* FIXME: Blowfish_Initialize() ??? */
short InitializeBlowfish(UBYTE_08bits key[], short keybytes,int d)
{
  short          i;		/* FIXME: unsigned int, char? */
  short          j;		/* FIXME: unsigned int, char? */
  UWORD_32bits  data;
  UWORD_32bits  datal;
  UWORD_32bits  datar;
  union aword temp;

/*  fprintf (stderr, "0x%x 0x%x ", bf_P[0], bf_P[1]); /* DEBUG */
/*  fprintf (stderr, "%d %d\n", bf_P[0], bf_P[1]); /* DEBUG */
 
  memcpy ((char *) &bf_P[d] [0],(char *)&bf_P[4] [0],18*4);
  memcpy ((char *) &bf_S[d] [0],(char *)&bf_S[4] [0], 4*256*4); 

  //disk=slot;
  j = 0;
  for (i = 0; i < bf_N + 2; ++i) {
    temp.word = 0;
    temp.w.byte0 = key[j];
    temp.w.byte1 = key[(j+1)%keybytes];
    temp.w.byte2 = key[(j+2)%keybytes];
    temp.w.byte3 = key[(j+3)%keybytes];
    data = temp.word;
    
	bf_P[d][i] = bf_P[d][i] ^ data;
    j = (j + 4) % keybytes;
  }

  datal = 0x00000000;
  datar = 0x00000000;

  for (i = 0; i < bf_N + 2; i += 2) {
    Blowfish_encipher(&datal, &datar,d);

    bf_P[d][i] = datal;
    bf_P[d][i + 1] = datar;
  }

  for (i = 0; i < 4; ++i) {
    for (j = 0; j < 256; j += 2) {

      Blowfish_encipher(&datal, &datar,d);
   
      bf_S[d][i][j] = datal;
      bf_S[d][i][j + 1] = datar;
    }
  }
  return 0;
}
//=============== bf_tab.h ==============

//************** TEST VECTORS ***********************************
//
//This is a test vector.
//Plaintext is "BLOWFISH".
//The key is "abcdefghijklmnopqrstuvwxyz".

#define PL 0x424c4f57l
#define PR 0x46495348l
#define CL 0x324ed0fel
#define CR 0xf413a203l
	static char keey[]="abcdefghijklmnopqrstuvwxyz";

//This is another test vector.
//The key is "Who is John Galt?"

//#define PL 0xfedcba98l
//#define PR 0x76543210l
//#define CL 0xcc91732bl
//#define CR 0x8022f684l


void blomain (void)
{

//	int l=0x1234;
//	int r=0x4567;

    unsigned int ivl,ivl2;
	unsigned int ivr,ivr2;
	int n,x;
//char key[]="hello world2";
 int l=0x424c4f57l;
 int r=0x46495348l;
//#define CL 0x324ed0fel
//#define CR 0xf413a203l
	
unsigned char key[]="abcdefghijklmnopqrstuvwxyz";

UWORD_32bits data [128]= 
{
	0,1,2,3,4,5,6,7,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,


};


int	mydisk=1;

	//InitializeBlowfish( (char * )&key,(short) strlen(key),mydisk);

	InitializeBlowfish( key,1,mydisk);

	Blowfish_encipher((UWORD_32bits *)&l,(UWORD_32bits *)&r,mydisk);
//Blowfish_encipher(&l,&r);
	Blowfish_decipher((unsigned long *)&l,(unsigned long *)&r,mydisk);
//Blowfish_decipher(&l,&r);
   

	for (x=0; x<20000000/512;x++)
	
	{

		ivl=0x1234;
		ivr=0x666;

	  for (n=0;n<128;n=n+2) // sector scrambler...
	   {
		data[n]=ivl^data[n];
		data[n+1]=ivr^data[n+1];
		Blowfish_encipher( (UWORD_32bits*) &data[n],(UWORD_32bits*)&data[n+1],mydisk);
		ivl=data[n];
		ivr=data[n+1];
	  }


	

  

		ivl=0x1234;
		ivr=0x666;

	for (n=0;n<128;n=n+2)  //sector descrambler....
		{
			ivl2=data[n];
			ivr2=data[n+1];

			Blowfish_decipher((UWORD_32bits *)&data[n],(UWORD_32bits *)&data[n+1],mydisk);
		
			data[n]=ivl^data[n];
			data[n+1]=ivr^data[n+1];
		
			ivl=ivl2;
			ivr=ivr2;

		}


	}

	n++;




}




void getiv64(int *l,int *r,int *cbccl,int *cbccr,int temp_block,char *keys)
{


_asm
    {




	mov ecx,[temp_block]
    //inc [temp_block]
	mov esi,[keys]

	;ecx=sector number.....

	pushad
	push ebp

	xor eax,eax
	xor edx,edx
	xor ebp,ebp
	xor edi,edi

		 
	mov ebx,32
		

formkey:
	
	push esi
	shr ecx,1
	jnc nohigh
	add esi,16
nohigh:


	add eax,[esi]			  ;96 bits........
	adc edx,[esi+4]
	adc ebp,[esi+8]	  		  ;....
	adc edi,[esi+12]
	
	pop esi
	add esi,32
	dec ebx
	jnz formkey	
	
    mov ecx,ebp
	pop ebp

	mov esi,[cbccl]
	mov [esi],ecx


	mov esi,[cbccr]
	mov [esi],edi


	mov esi,[l]
	mov [esi],eax
	
	mov esi,[r]
	mov [esi],edx

	popad
	}


}


	void cipherblock(unsigned long * buffer,char *keys,int tempblock,int numsectors)

	{

		unsigned char tkey[]="abcdefghijklmnopqrstuvwxyz123456   ";

		char *temp;

		int ivl,ivr;
		int cbccl,cbccr;

		int n;

		int bl=2;

		if (cipher==SQUARE) bl=4; //square is 4 bytes per round

		while (numsectors)
		{

			getiv64(&ivl,&ivr,&cbccl,&cbccr,tempblock,keys);

			//ivl=1;  //TEST
			//ivr=2;


			for (n=0;n<128;n=n+bl) // sector scrambler...
				{
				buffer[n]=ivl^buffer[n];
				buffer[n+1]=ivr^buffer[n+1];
			
				switch (cipher)
				{
					case BLOWFISH:
					Blowfish_encipher(&buffer[n],&buffer[n+1],0);
					break;
					case TEA16:
					case TEA32:
					teaencipher(&buffer[n],0); //16/32 round Tea set on teainit
					break;
					case IDEA:
					ideaencipher(&buffer[n],0);
					break;
				
					case DES:
					desencipher(&buffer[n],0);
				    break;

					case SQUARE:
					squareencipher(&buffer[n],0);
					break;

					case MISTY1:
					mistyencipher(&buffer[n],0);
					break;
				
					case THREEDES:
					threedesencipher(&buffer[n],0);
				    break;


				}


				ivl=buffer[n];
				ivr=buffer[n+1];

				buffer[n]^=cbccl;
				buffer[n+1]^=cbccr;			
				}
		 tempblock++;
		 numsectors--;
		 
		 temp=(char *)buffer;
		 temp+=512;
		 buffer=(unsigned long *) temp;

		}

	}

