#ifndef EC_INCL_EACCID_H
#define EC_INCL_EACCID_H
/* beginning of eaccid.h */


	/* ecashlib public headers */
#include "eaccid.fh"
#include "emintid.fh"
#include "eerrno.fh"

	/* debug info header */
#ifdef DC_DEBUG_INFO
#include "eaccid.ih"
#endif


	/* EC_AccountID functions */

/*
 * Create a new EC_AccountID.
 *
 * parameters:
 *	mintID: the ID uniquely identifying the mint
 *	acc_name_str: a string (usually an e-mail address) uniquely (within
 *		the context of the mint) identifying the account
 *
 * return values:
 *	pointer to the new EC_AccountID on success, NULL pointer on failure
 */
EC_EXPORT EC_AccountID *EC_accID_new(EC_MintID mintID, const Char *acc_name_str);


/*
 * Free the EC_AccountID.
 *
 * return values:
 *	standard EC_Errno
 */
EC_EXPORT EC_Errno EC_accID_free(EC_AccountID *this_accID_ptr);


/*
 * Duplicate an EC_AccountID.
 *
 * return values:
 *	pointer to the new EC_AccountID on success, NULL pointer on failure
 */
EC_EXPORT EC_AccountID *EC_accID_dup(const EC_AccountID *this_accID_lnk);


/*
 * Get the contents of an EC_AccountID.
 */
EC_EXPORT EC_MintID EC_accID_get_mintID(const EC_AccountID *this_accID_lnk);

EC_EXPORT Char *EC_accID_get_acct_name(const EC_AccountID *this_accID_lnk);



/* end of eaccid.h */
#endif

