#ifndef _ONL_TCP_H_
#define _ONL_TCP_H_


/*
 *
 * Copyright (c) 1993, 1994 DigiCash
 * All rights reserved.
 *
 * $Id: onl_tcp.h,v 1.9 1996/06/10 16:01:09 bryce Exp $
 */


extern void (*tcp_show_conn)(char *, int);

extern int ec_tcp_timeout;

struct tcp_conn {
	int s;		/* socket file descriptor */
	char *host;
	int port;
	char *proxy_url;

	/* buffering */
	unsigned char * buf, * ptr;
	int cnt;

	unsigned long ipaddr;
	int flags;
	struct tcp_conn *next;
};

/* tcp_open_conn() flags */
#define	TCP_BANK	1
#define	TCP_INCOMING	2
#define	TCP_CCLOSED	4
#define	TCP_HTTPSERV	8
#define	TCP_NOPROXY	16
#define	TCP_HTTPDONE	32

/* tcp_bindsock() flags */
#define	EC_REUSEPORT	1
#define	EC_FINDPORT	2

/* onl_tcp.c prototypes */

int tcp_set_proxy(char * host, int port);
char * tcp_get_proxy(void);
int tcp_bindsock(int *, int);
int tcp_listen(int (*)(struct tcp_conn *, char *), int, int (*)(void));
int tcp_init(void);
void tcp_exit(void);
void ec_tcperr(char *m);
struct tcp_conn * new_conn(char *host, int flags);
struct tcp_conn * tcp_accept_conn(int s);
int tcp_get_remote_host(struct tcp_conn * conn);

/* forward declaration */
struct msg;

struct tcp_conn * tcp_open_conn(char *, int, int);
int tcp_close_conn(struct tcp_conn *);
int tcp_recv_msg(struct msg *, struct tcp_conn *);
int tcp_send_msg(struct msg *, struct tcp_conn *);
char * tcp_hostname(void);

#ifdef _Windows
int tcp_set_notify( int, int, int, long );
void tcp_set_select( int );
#define SELECT_SPRY		1
#define SELECT_NETCOM	2
#define SELECT_AOL		3
#endif


/*
 * read n bytes from conn, will try to read all of the requested data and
 * returns -1 if this fails.
 */
int
tcp_read(struct tcp_conn * conn, char * buf, int cnt);

long
tcp_rwrite(struct tcp_conn * conn, char * buf, long cnt);



#endif /* #ifndef wrapper to prevent double-includes */
