/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

#define AFLAG       'a'
#define BFLAG       'b'

baconian::baconian(){
  int i;

  balphabet[0] = "aaaaa";
  balphabet[1] = "aaaab";
  balphabet[2] = "aaaba";
  balphabet[3] = "aaabb";
  balphabet[4] = "aabaa";
  balphabet[5] = "aabab";
  balphabet[6] = "aabba";
  balphabet[7] = "aabbb";
  balphabet[8] = "abaaa";
  balphabet[9] = "abaaa";
  balphabet[10] = "abaab";
  balphabet[11] = "ababa";
  balphabet[12] = "ababb";
  balphabet[13] = "abbaa";
  balphabet[14] = "abbab";
  balphabet[15] = "abbba";
  balphabet[16] = "abbbb";
  balphabet[17] = "baaaa";
  balphabet[18] = "baaab";
  balphabet[19] = "baaba";
  balphabet[20] = "baabb";
  balphabet[21] = "babaa";
  balphabet[22] = "babaa";
  balphabet[23] = "babab";
  balphabet[24] = "babba";
  balphabet[25] = "babbb";
  period = 5;
  for(i = 0; i < 26; i++)
    key[i] = BLANK;
}

int baconian::execute_option(char option){
  switch(option){
    case SUBSTITUTE:
      substitute();
      break; 
    case UNDO:
      undo();
      break;
    case GROUPSUB:
      groupsub();
      break;
    default:
      base_exec_option(option);
      break;
  }

  return TRUE;
}

int baconian::set_period(int newperiod){
  period = 5;
  return TRUE;
}

void baconian::substitute(){
  char letter, bletter;

  prompt("What is the ct letter? ");
  letter = get_char();
  if(!isalpha(letter))
    msgerror("Value must be a letter.");
  else{
    prompt("What is the baconian value (a or b)? ");
    bletter = get_char();
    if(bletter != 'a' && bletter != 'b'){
      msgerror("Value must be either 'a' or 'b'.");
    }
    else
      sub_key(letter, bletter);
  }
}

void baconian::sub_key(char letter, char flag){
  if(isalpha(letter) && (flag == AFLAG || flag == BFLAG)){
    if(key[letter - 'a'] != BLANK && key[letter - 'a'] != flag){
      msgerror("Bad substitution");
    }
    else
      key[letter - 'a'] = flag;
  }
}

void baconian::groupsub(){
  char tmp_str[STRINGLENGTH];
  char *c, letter;

  prompt("What is the group? ");
  read_line(tmp_str);
  if(strlen(tmp_str) != 5)
    msgerror("Group must be 5 characters long.");
  else if(strstr(cipher, tmp_str) == NULL)
    msgerror("Group does not appear in cipher.");
  else{
    c = strstr(cipher, tmp_str);
    if( (c - cipher)%5 != 0){
      msgerror("Bad group position.");
    }
    else{
      prompt("What letter does this group represent? ");
      letter = get_char();
      if(!isalpha(letter))
	msgerror("Letter must be a letter from a to z.");
      else
	sub_string(letter, tmp_str);
    }
  }
}

void baconian::undo(){
  char letter;

  prompt("Which letter would you like to undo? ");
  letter = get_char();
  if(!isalpha(letter))
    msgerror("Bad letter.");
  else
    undo_letter(letter);
}

void baconian::show_menu(){
  menu(1, "Options: (S)ubstite letter  (G)roup substitution  (U)ndo  (W)rite  (Q)uit");
}

void baconian::show_key(){
  int i;

  /* Show the baconian substitutes that the user
  ** has already made.
  */

  for(i = 0; i < 26; i++){
    put_char(key[i], i*3, 0);
    put_char(toupper(i+ 'a'), i*3, 1);
    msgprint(33, 2, "Baconian Key");
  }

  /* For kicks (and helpfulness), show the entire baconian alphabet.
  */

  for(i = 0; i < 13; i++){
    msgprint(i*6,   4, balphabet[i]);
    put_char(i + 'A', i*6+2, 5);
    msgprint(i*6,   7, balphabet[i+13]);
    put_char(i +13 + 'A', i*6+2, 8);
  }
  msgprint(31, 9, "Baconian Alphabet");
}

void baconian::show_cipher(){
  int i, line_length, period = 5;
  char tmp_str[20];

  line_length = 80 / (period+1);
  i = 0;
  while(i < length){

    /* First put the ciphertext on a line
    */

    strncpy(tmp_str, cipher+i, period);
    tmp_str[period] = '\0';
    msgprint((i*(period+1)/period)%(line_length*(period+1)), (i/(line_length*period))*3 + 13, tmp_str);

    /* Now put the baconian a/b units above the ciphertext
    */

    stringtob(tmp_str);
    msgprint((i*(period+1)/period)%(line_length*(period+1)), (i/(line_length*period))*3 + 12, tmp_str);

    /* Now decode the baconian string into the corresponding letter.
    */

    bstringtochar(tmp_str);
    msgprint((i*(period+1)/period)%(line_length*(period+1)), (i/(line_length*period))*3 + 11, tmp_str);

    i += period; 
  }
}
  
void baconian::sub_string(char letter, char group[6]){
  int i;
  char btext[6];

  bconv(letter, btext);
  for(i = 0; i < strlen(group); i++)
    sub_key(group[i], btext[i]);
}

void baconian::undo_letter(char letter){
  if(isalpha(letter))
    key[letter - 'a'] = BLANK;
}

void baconian::clear_key(){
  int i;

  for(i = 0; i < 26; i++)
    key[i] = BLANK;
}

void baconian::bconv(char letter, char btext[6]){
  strcpy(btext, balphabet[letter - 'a']);
}

void baconian::stringtob(char *string){
  while(*string){
    *string = key[*string - 'a'];
    string++;
  }
}

void baconian::bstringtochar(char *string){
  int i, letter_inserted = FALSE;

  /* convert the 5 letter string to it's baconian equivalent (if it
  ** exists).  Put the letter in the middle of the string, surrounded by
  ** spaces.
  */

  for(i = 0; i < 26; i++){
    if(strcmp(balphabet[i], string) == 0){
      sprintf(string, "  %c  ", toupper(i+'a'));
      letter_inserted = TRUE;
    }
  }

  if(!letter_inserted)
    strcpy(string, "     ");
}

void baconian::copy_key(char *string){
  strcpy(string, key);
}

void baconian::decipher(char *string){
  char temp_str[STRINGLENGTH];
  int i;

  for(i = 0; i < length; i+=period){
    strncpy(temp_str, cipher+i, 5);
    temp_str[5] = '\0';

    stringtob(temp_str);
    bstringtochar(temp_str);
    *string++ = temp_str[2];
  }
  *string = '\0';
}

void baconian::read_key(FILE *fptr){
  fgets(key, 28, fptr);
  key[26] = '\0';
}
