/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

columnar::columnar(){
  *cipher = '\0';
  period=0;
  maxcollen=0;
  length = 0;
  clen = NULL;
  block = NULL;
  period_set = FALSE;
}

int columnar::execute_option(char option){
  switch(option){
    case UNDO:
      undo();
      break;
    case MOVE:
      move_stuff();
      break;
    case CHANGEPERIOD:
      change_period();
      break;
    default:
      base_exec_option(option);
      break;
  }

  return TRUE;
}

void columnar::setup_key(){
  delete key;
  key = new int[period*2];
  init_key();
}

void columnar::undo(){
  init_key();
  fill_block();
}

void columnar::change_period(){
  period_set = FALSE;
  set_period();
  init_cipher();
  clear_to_prompt();
}

void columnar::init_cipher(){
  int i;

  length = strlen(cipher);

  delete clen;
  delete block;
  /* re-Allocate the block
  */
  maxcollen = (length%period == 0)?length/period:length/period + 1;
  clen = new int[period];
  block = new char *[period];
  for(i = 0; i < period; i++)
    block[i] = new char[maxcollen];

  /* Initilize the column lengths
  */
  for(i = 0; i < period; i++){
    if(period*(maxcollen-1) + i < length)
      clen[i] = maxcollen;
    else
      clen[i] = maxcollen-1;
  }

  /* Now fill in the block.
  */

  fill_block();
}

void columnar::init_key(){
  int i;

  for(i = 0; i < period; i++)
    key[i] = i+1;
}

void columnar::fill_block(){
  int i, maxlen, position;
  int *cptr, *tptr;
  char *cipherptr = cipher;

  /* Loop through each column
  */

  for(i = 1; i <= period; i++){

    /* Find out which columns are associated with that rail
    */

    cptr = find_columns(i);
    maxlen = 0;

    /* Find the length of the longest column
    */

    for(tptr = cptr; *tptr >= 0; tptr++){
      if(clen[*tptr] > maxlen)
	maxlen = clen[*tptr];
    }

    /* Loop through each column and fill it
    */

    position = 0;
    while(position < maxlen){
      for(tptr = cptr; *tptr >= 0; tptr++){
	if(position < clen[*tptr]){
	  block[*tptr][position] = *cipherptr;
	  cipherptr++;
	}
      }
      position++;
    }
  }
}

int *columnar::find_columns(int index){
  int i, position=0;
  static int *list;

  delete list;
  list = new int[period+1];

  /* We are assuming that there is a variable (int *)key that has
  ** a list of non-negative integers.  There is also a variable
  ** (int)period that gives the number of elements in key.
  */

  for(i = 0; i < period; i++){
    if(key[i] == index){
      list[position++] = i;
    }
  }
  list[position] = -1;

  return list;
}

void columnar::show_menu(){
  menu(1, "(M)ove columns  (C)hange period   (U)ndo   (W)rite   (Q)uit");
}

void columnar::show_cipher(){
  int i, j, column, row;

  for(i = 0; i < period; i++){
    /* Label the columns
    */
    if(key[i]/10 > 0)
      put_char((key[i])/10+'0', i+3, 0);
    else
      put_char(BLANK, i+3, 0);
    put_char((key[i])%10+'0', i+3, 1);

    /* If the columns are too long then we have to continue them 
    ** beside the first one.
    */
    if(maxcollen > 16){
      if(key[i]/10 > 0)
	put_char((key[i])/10+'0', i+3+period+4, 0);
      put_char((key[i])%10+'0', i+3+period+4, 1);
    }

    /* Now show the cipher
    */
    for(j = 0; j < clen[i]; j++){
      column = i+3;
      row = j+2;

      /* Do we have columns that are too long?
      */
      if(row > 17){
	row -= 16;
	column += period+4;
      }

      put_char(block[i][j], column, row);
    }
  }
}

void columnar::show_key(){
}

void columnar::move_stuff(){
  char temp_str[STRINGLENGTH];
  int column1, column2, i;

  prompt("Interchange which two columns/rows? (ex: 1,2) ");
  read_line(temp_str);
  if(sscanf(temp_str, "%d,%d", &column1, &column2) != 2);
  else if(column1 <= period && column2 <= period && column1 > 0 && column2 > 0){

    for(i = 0; i < period; i++){
      if(key[i] == column2)
	key[i] = column1;
      else if(key[i] == column1)
	key[i] = column2;
    }

    fill_block();
  }
  
  else{
    msgerror("Bad column number.");
  }
}

void columnar::decipher(char *string){
  int i, j;

  for(i = 0; i < maxcollen; i++){
    for(j = 0; j < period; j++){
      if(i < clen[j])
	*string++ = block[j][i];
    }
  }
  *string = '\0';
}

void columnar::copy_key(char *string){
  int i;

  for(i = 0; i < period; i++)
    string[i] = (char) (key[i] + '0');
  
  string[period] = '\0';
}

void columnar::read_key(FILE *fptr){
  char temp_str[STRINGLENGTH];
  int i;

  fgets(temp_str, STRINGLENGTH, fptr);

  i = 0;
  while(temp_str[i] != '\n'){
    key[i] = temp_str[i] - '0';
    i++;
  }
  period = i;
}
