/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

#define S1          {1, 2, 3, 4, 5}
#define S2          {2, 1, 3, 4, 5}
#define S3          {2, 3, 1, 4, 5}
#define S4          {2, 3, 4, 1, 5}
#define S5          {2, 3, 4, 5, 1}
#define S6          {3, 2, 4, 5, 1}
#define S7          {3, 4, 2, 5, 1}
#define S8          {3, 4, 5, 2, 1}

phillips::phillips(){
  int i, j;

  cipher[0] = '\0';
  period = 5;
  period_set = TRUE;
  for(i = 0; i < period; i++)
    for(j = 0; j < period; j++)
      key[i][j] = BLANK;
}

int phillips::set_period(){
  period = 5;
  period_set = TRUE;

  return period_set;
}

void phillips::init_cipher(){
  length = strlen(cipher);
  period = 5;
}

int phillips::execute_option(char option){
  switch(option){
    case SUBSTITUTE:
      substitute();
      break; 
    case UNDO:
      undo();
      break;
    default:
      base_exec_option(option);
      break;
  }

  return TRUE;
}

void phillips::substitute(){
  int row, column;
  char letter, tmp_str[STRINGLENGTH];

  prompt("What are the coordinates of the letter? (row,column) ");
  read_line(tmp_str);
  sscanf(tmp_str, "%d,%d", &row, &column);
  if(row < 1 || row > 5 || column < 1 || column > 5)
    msgerror("Bad position.");
  else{
    prompt("What is the new letter? ");
    letter = get_char();
    if(!isalpha(letter))
      msgerror("Bad letter.");
    else{
      row--, column--;
      key[row][column] = letter;
    }
  }
}

void phillips::undo(){
  char letter;

  prompt("Undo which letter? (* for all) ");
  letter = get_char();
  if(letter == '*')
    clear_key();
  else
    undo_letter(letter);
}

void phillips::show_menu(){
  menu(1, "Options:  (S)ubstitute      (U)ndo letter    (W)rite    (Q)uit");
}

void phillips::show_key(){
  const int squares[8][5] = { S1, S2, S3, S4, S5, S6, S7, S8};
  int i, j, k;

  /* Loop through rows...  */
  for(i = 0; i < 5; i++){
    /* Loop through the 4 squares in each row... */
    for(j = 0; j < 4; j++){
      /* Label each row */
      put_char(squares[j][i]+'0', j*14, i);
      put_char('>', j*14+1, i);
      put_char(squares[j+4][i]+'0', j*14, i+6);
      put_char('>', j*14+1, i+6);
      /* Loop through the 5 letters in each row... */
      for(k = 0; k < 5; k++){
	put_char(key[squares[j][i]-1][k], j*14+2*k+2, i);
	put_char(key[squares[j+4][i]-1][k], j*14+2*k+2, i+6);
      }
    }
  }
}

void phillips::show_cipher(){
  int i=0;
  char tmp_str[STRINGLENGTH];

  while(i < length){
    strncpy(tmp_str, cipher+i, 5);
    msgprint((i*6/5)%72, 12+(i/60)*3, tmp_str);
    decrypt(tmp_str, ((i/5)%8));
    msgprint((i*6/5)%72, 11+(i/60)*3, tmp_str);
    put_char( ((i/5)%8)+'1', (i*6/5)%72+2, 13+(i/60)*3);
    i += 5;
  }
}
  
void phillips::read_key(FILE *fptr){
  int i=0, j=0, position=0;
  char temp_str[STRINGLENGTH];
  char c;

  fgets(temp_str, STRINGLENGTH, fptr);

  while(position < 25){
    c = temp_str[position];
    key[i][j++] = c;
    if(j == 5){
      j = 0;
      i++;
    }
    position++;
  }
}

void phillips::decrypt(char *message, int snum){
  int skey[8][5] = { S1, S2, S3, S4, S5, S6, S7, S8};
  int i, j, k;
  int letter_replaced;
  char c;

  /* Loop through each letter... */
  for(i = 0; i < 5; i++){
    letter_replaced = FALSE;
    /* If the letter exists in the keysquare then find it's partner.
    ** Otherwise, (or if the partner doesn't exist) leave it blank.
    */
    if(message[i] != ' '){
      for(j = 0; j < 5; j++){
	for(k = 0; k < 5; k++){
	  if(message[i] == key[skey[snum][j]-1][k] && letter_replaced == FALSE){
	    letter_replaced = TRUE;
	    c = key[skey[snum][((j==0)?4:j-1)]-1][((k==0)?4:k-1)];
	    if(c != BLANK)
	      message[i] = c;
	    else
	      message[i] = ' ';
	  }
	}
      }
      if(!letter_replaced)
	message[i] = ' ';
    }
  }
}

void phillips::clear_key(){
  int i, j;

  for(i = 0; i < 5; i++){
    for(j = 0; j < 5; j++){
      key[i][j] = BLANK;
    }
  }
}

void phillips::undo_letter(char letter){
  int j, k;
  
  if(isalpha(letter)){
    for(j = 0; j < 5; j++){
      for(k = 0; k < 5; k++){
	if(letter == key[j][k]){
	  key[j][k] = BLANK;
	}
      }
    }
  }
}

void phillips::decipher(char *string){
  int i=0;
  char tmp_str[STRINGLENGTH];

  *string = '\0';
  while(i < length){
    strncpy(tmp_str, cipher+i, 5);
    tmp_str[5] = '\0';
    decrypt(tmp_str, ((i/5)%8));
    strcat(string, tmp_str);
    put_char( ((i/5)%8)+'1', (i*6/5)%72+2, 13+(i/60)*3);
    i += 5;
  }
}

void phillips::copy_key(char *string){
  int i, j;

  for(i = 0; i < 5; i++){
    for(j = 0; j < 5; j++){
      string[i*5+j] = key[i][j];
    }
  }
}
