/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

quag2::quag2(){
  period = 0;
  period_set = FALSE;
  *cipher = '\0';
  key = okey = NULL;
  clen = 0;
  length = 0;
}

int quag2::execute_option(char option){
  switch(option){
    case SUBSTITUTE:
      substitute();
      break; 
    case UNDO:
      undo();
      break;
    default:
      base_exec_option(option);
      break;
  }

  return TRUE;
}

void quag2::substitute(){
  char ct_letter, pt_letter;
  char tmp_str[STRINGLENGTH];
  int column;

  prompt("What column is the letter in? ");
  column = (int) (get_char() - '0');

  if(column < 1 || column > period){
    msgerror("Bad position.");
  }
  else{
    prompt("What is the new letter? (ct,pt) ");
    read_line(tmp_str);
    if(sscanf(tmp_str, "%c,%c", &ct_letter, &pt_letter) != 2){
      msgerror("Bad format.");
    }
    else if(!isalpha(ct_letter) || !isalpha(pt_letter)){
      msgerror("Bad letter.");
    }
    else{
      if(alter_key(column-1, ct_letter, pt_letter) == 0)
	msgerror("That position is already occupied.");
    }
  }
}

void quag2::undo(){
  int column, i;
  char ct_letter;

  prompt("Which column? (* for all) ");
  column = get_char();
  prompt("Undo which letter? (* for all) ");
  ct_letter = get_char();
  if(ct_letter == '*' && column == '*'){
    for(i = 0; i < period; i++){
      clear_key(i);
    }
  }
  else if(ct_letter == '*' && isdigit(column)){
    clear_key(column-'1');
  }
  else if(column == '*' && isalpha(ct_letter)){
    for(i = 0; i < period; i++){
      undo_letter(i, ct_letter);
    }
  }
  else if(isdigit(column) && isalpha(ct_letter)){
    undo_letter(column - '1', ct_letter);
  }
  else if(!isdigit(column)){
    msgerror("Bad column.");
  }
  else if(!isalpha(ct_letter)){
    msgerror("Bad letter.");
  }
}

void quag2::show_menu(){
  menu(1, "Options:  (S)ubstitute    (U)ndo letter    (W)rite    (Q)uit");
}

void quag2::show_cipher(){
  int i, line_length;
  char tmp_str[20];

  line_length = 80 / (period+1);
  i = 0;
  while(i < length){
    strncpy(tmp_str, cipher+i, period);
    tmp_str[period] = '\0';
    msgprint((i*(period+1)/period)%(line_length*(period+1)), (i/(line_length*period))*2 + 1, tmp_str);
    decode(tmp_str);
    msgprint((i*(period+1)/period)%(line_length*(period+1)), (i/(line_length*period))*2 + 0, tmp_str);
    i += period; 
  }
}

void quag2::decode(char *message){
  int i, j, letter_replaced;

  for(i = 0; i < strlen(message); i++){
    letter_replaced = FALSE;
    for(j = 0; j < 26 && !letter_replaced; j++){
      if( okey[i][j] != BLANK && message[i] == okey[i][j]){
	message[i] = j + 'a';
	letter_replaced = TRUE;
      }
    }
    if(!letter_replaced)
      message[i] = BLANK;
  }
}

void quag2::show_key(){
  register int i, j, k, l, m, n;
  register char c, d;

  /* The first step is to combine the separate keys so that if there
  ** is a repetition in two keys the data will be combined.
  */

  for(i = 0; i < period; i++){
    for(j = 0; j < 26; j++){
      okey[i][j] = key[i][j];
    }
  }

  /* Make period passes for each key so that second order repetitions
  ** will be taken into account.
  */
  for(j = 0; j < period; j++){
    /* Loop through each of the 'period' keys.
    */
    for(i = 0; i < period; i++){
      /* For each key, loop through each of the other 'period' keys.
      */
      for(k = 0; k < period; k++){
	for(l = 0; l < 26; l++){
	if(okey[i][l] != BLANK){
	  for(m = 0; m < 26; m++){
	    /* do the keys overlap?
	    */
	    if(okey[k][m] == okey[i][l]){
	      for(n = 0; n < 26; n++){
		c = okey[i][(l+n)%26];
		d = okey[k][(m+n)%26];
		if(c != BLANK && d != BLANK && c!=d){
		  msgerror("Caution:  Bad substitution.");
		}
		if(d != BLANK){
		  okey[i][(l+n)%26] = okey[k][(m+n)%26];
		  okey[k][(m+n)%26] = okey[k][(m+n)%26];
		}
		else if(c != BLANK){
		  okey[k][(m+n)%26] = okey[i][(l+n)%26];
		  okey[i][(l+n)%26] = okey[i][(l+n)%26];
		}
	      }
	    }
	  }
	}
	}
      }
    }
  }

  msgprint(0, 9, "Pt: a b c d e f g h i j k l m n o p q r s t u v w x y z");
  for(i = 0; i < period; i++){
    put_char(i%10+'1', 0, i+11);
    for(j = 0; j < 26; j++){
      put_char(okey[i][j], j*2+4, i+11);
    }
  }
}

void quag2::undo_letter(int keynum, char letter){
  int i;

  for(i = 0; i < 26; i++){
    if(key[keynum][i] == letter){
      key[keynum][i] = BLANK;
    }
  }
}

void quag2::clear_key(int keynum){
  int i;

  for(i = 0; i < 26; i++)
    key[keynum][i] = BLANK;
}

int quag2::alter_key(int keynum, char ct_letter, char pt_letter){
  int valid = TRUE;

  if(isalpha(ct_letter) && isalpha(pt_letter)){
    if(key[keynum][((pt_letter) | ' ') - 'a'] == BLANK){
      key[keynum][((pt_letter) | ' ') - 'a'] = tolower(ct_letter);
    }
    else
      valid = FALSE;
  }
  else
    valid = FALSE;
  
  return valid;
}

void quag2::setup_key(){
  int i, j;

  delete key;
  delete okey;
  key = (new char *[period]);
  okey = (new char *[period]);

  for(i = 0; i < period; i++){
    key[i] = new char[26];
    okey[i] = new char[26];
    for(j = 0; j < 26; j++){
      key[i][j] = BLANK;
      okey[i][j] = BLANK;
    }
  }
}

void quag2::init_cipher(){
  length = strlen(cipher);
}

void quag2::decipher(char *string){
  int i;
  char temp_str[STRINGLENGTH];

  *string = '\0';
  for(i = 0; i < length; i+=period){
    strncpy(temp_str, cipher+i, period);
    temp_str[period] = '\0';
    decode(temp_str);
    strcat(string, temp_str);
  }
}

void quag2::copy_key(char *string){
  int i;

  *string = '\0';

  for(i = 0; i < period; i++){
    strcat(string, key[i]);
    strcat(string, "\n");
  }
  *strrchr(string, '\n') = '\0';
}

void quag2::read_key(FILE *fptr){
  int i;

  for(i = 0; i < period; i++){
    fgets(key[i], 28, fptr);
    key[i][26] = '\0';
  }
}
