/*
**	ssh_compress.h	-- ssh compression header file
**
**	Copyright 1998 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
*/

#include "ssh.h"

#ifndef __SSH_COMPRESS_H
#define __SSH_COMPRESS_H

/*
**	define the minimum and maximum compression levels as per
**	the SSH 1.5 draft (which also correlate with the fastest and
**	slowest zlib compression levels).  We #define ours here for
**	uniformity
*/
#define SSH_COMPRESS_MIN_LEVEL		1	/* min level of compression */
#define SSH_COMPRESS_MAX_LEVEL		9	/* max level of compression */

/*
**	default compression level
*/
#define SSH_COMPRESS_DEFAULT_LEVEL	6


/*
**	define the current state of compression (yes or no)
*/
#define SSH_COMPRESS_YES		1	/* use compression */
#define SSH_COMPRESS_NO			0	/* don't use compression */

/*
**	macro to return a non-zero number if compression is activated
**	
**	struct ssh_struct * ssh_info
*/
#define ssh_compression_active(ssh_info)	( \
		((((ssh_info)->compress_info).do_compress) \
		== (SSH_COMPRESS_YES)))

/*
**	initialize compression to none
*/
int ssh_compression_none(struct ssh_struct * ssh_info);

/*
**	activate compression
*/
int ssh_compression_set(struct ssh_struct * ssh_info, int level);

/*
**	deactivate compression
*/
int ssh_compression_unset(struct ssh_struct * ssh_info);

/*
**	compress and uncompress data
*/
int ssh_compression_compress(struct ssh_struct * ssh_info,
	uint8_t * input_str, uint8_t * output_str, int input_len,
	int output_len, int * final_len);
int ssh_compression_uncompress(struct ssh_struct * ssh_info,
	uint8_t * input_str, uint8_t * output_str, int input_len,
	int output_len, int * final_len);

#endif	/* __SSH_COMPRESS_H */

