/*
**	Used so we don't echo keys.  I don't think this would even
**	be copyrightable if we wanted to.  Still, there is not warrenties.
**	See the LICENSE file.
*/

/*
	Rob Braun (bbraun) 5/17/97
	I've put this together for an easy way to do unbuffered io to the
	tty the user is at.  This is by no means efficient.

	char unbuf_noecho_getc()
	This retrieves a character from stdin, but does not allow it to be
	echoed to the screen.

	char unbuf_getc()
	This retrieves a character from stdin and that is the return value
*/

#ifndef lint
static char *RCSid="$Header: /home/kohno/LibSSH/libssh.0.0.1beta/unix_ssh/RCS/unbuf_io.c,v 1.3 1998/03/14 22:31:06 kohno Exp $";
#endif


#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>

#include <stdio.h>

#include "unbuf_io.h"



/*
**	should really restore state after control-C
*/
int start_unbuf_io()
{
	FILE *input ;
	struct termios orig_settings, my_settings;

	if ((input = fopen(ctermid(NULL), "r+")) == NULL)
	{
		return(-1);
	}
	setbuf(input, NULL);

	tcgetattr(fileno(input), &orig_settings);
	my_settings = orig_settings;
	my_settings.c_lflag &= ~ICANON;
	my_settings.c_lflag &= ~ECHO;
	my_settings.c_cc[VMIN] = 1;
	my_settings.c_cc[VTIME] = 0;
	if(tcsetattr(fileno(input), TCSANOW, &my_settings) != 0)
	{
		fprintf(stderr, "could not set attributes\n");
		return(-1);
	}
	return(0);
}

int noecho_getc()
{
/*
	FILE * input;

	input = fopen("/dev/tty", "r+");

	return(fgetc(input));
	fclose(input);
*/
	return(fgetc(stdin));

}

char unbuf_noecho_getc()
{
	char temp;
	FILE *input ;
	struct termios orig_settings, my_settings;

	input = fopen("/dev/tty", "r");
	if(!input)
	{
		fprintf(stderr, "Unable to open /dev/tty\n");
		exit(1);
	}

	tcgetattr(fileno(input), &orig_settings);
	my_settings = orig_settings;
	my_settings.c_lflag &= ~ICANON;
	my_settings.c_lflag &= ~ECHO;
	my_settings.c_cc[VMIN] = 1;
	my_settings.c_cc[VTIME] = 0;
	if(tcsetattr(fileno(input), TCSANOW, &my_settings) != 0)
	{
		fprintf(stderr, "could not set attributes\n");
	}

	temp = fgetc(input);

	tcsetattr(fileno(input), TCSANOW, &orig_settings);
	return temp;
}

char unbuf_getc()
{
	char temp;
	FILE *input ;
	FILE *output ;
	struct termios orig_settings, my_settings;

	input = fopen("/dev/tty", "r");
	output = fopen("/dev/tty", "w");
	if(!input || !output)
	{
		fprintf(stderr, "Unable to open /dev/tty\n");
		exit(1);
	}

	tcgetattr(fileno(input), &orig_settings);
	my_settings = orig_settings;
	my_settings.c_lflag &= ~ICANON;
	my_settings.c_cc[VMIN] = 1;
	my_settings.c_cc[VTIME] = 0;
	if(tcsetattr(fileno(input), TCSANOW, &my_settings) != 0)
	{
		fprintf(stderr, "could not set attributes\n");
	}

	temp = fgetc(input);

	tcsetattr(fileno(input), TCSANOW, &orig_settings);
	return temp;
}

