/*
 * Copyright (C) 1995, 1996 Systemics Ltd (http://www.systemics.com/)
 * All rights reserved.
 *
 */

package cryptix.pgp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import cryptix.util.Streamable;

public final class CompressedData extends Packet
{
	private byte alg;
	private byte compressed_data[];

	public CompressedData( byte data[] )
	{
		this( (byte)1, data );
	}

	public CompressedData( byte alg_, byte data[] )
	{
		alg = alg_;
		compressed_data = data;
	}

	public CompressedData( DataInput in, int length )
		throws IOException
	{
		super( in, length );
	}

	public byte alg() { return alg; }

	public byte[]
	data()
	{
		int len;
		byte tmp[] = new byte[len = compressed_data.length];
		System.arraycopy( compressed_data, 0, tmp, 0, len );
		return tmp;
	}

	public void 
	read( DataInput in, int length )
		throws IOException
	{
		if (length < 1 )
			throw new FormatException( "Length too short" );
		alg = in.readByte(); // alg
		compressed_data = new byte[length-1];
		in.readFully( compressed_data );
	}

	public int
	write( DataOutput out )
		throws IOException
	{
		out.writeByte( (byte)alg );
		out.write( compressed_data );
		return 1 + compressed_data.length;
	}
}
