import java.io.*;
import java.util.Random;

public class PGPConvKey {
static final int RHEADERSIZE = 10;
byte key[];
Idea bt;


/**
 * Create an object to hold a PGP conventional key
 * @param key Idea key to use as a byte array
 */
public PGPConvKey(byte key[])
{
    this.key = key;
}

/**
 * Create an object to hold a PGP conventional key from a pass phrase
 * @param pass String holding PGP pass phrase (for pgp -c encryption)
 */
public PGPConvKey(String pass)
{
    MD5 md5 = new MD5();
    int len = pass.length();
    byte bpass[] = new byte[len];
    pass.getBytes(0, len, bpass, 0);
    md5.update(bpass);
    key = md5.getDigest();
}
    


/* PGP conventionally encrypt the buffer, outputting to OutputStream */
void encrypt(InputStream is, OutputStream os, Random rnd)
    throws IOException
{
    DataOutputStream out = (os instanceof DataOutputStream)?
                (DataOutputStream)os : new DataOutputStream(os);
    int length = is.available() + 6;
    ByteArrayOutputStream hdb = new ByteArrayOutputStream();
    DataOutputStream hd = new DataOutputStream(hdb);
    PGPCTB.writectbLength(PGPCTB.LIT, length, hd);
    hd.write('t');
    hd.write(0);
    hd.writeInt(0);
    length = is.available() + hdb.size() + RHEADERSIZE;
    PGPCTB.writectbLength(PGPCTB.CKE, length, out);
    bt = new Idea(key, Idea.ENCRYPTION);
    byte IV[] = new byte[bt.blockSize()];
    CFBEncryption pgpe = new CFBEncryption(bt, IV, 0);
    byte rbuf[] = new byte[RHEADERSIZE];
    for (int i=0; i<RHEADERSIZE-2; ++i)
        rbuf[i] = (byte)rnd.nextInt();
    rbuf[RHEADERSIZE-2] = rbuf[RHEADERSIZE-4];
    rbuf[RHEADERSIZE-1] = rbuf[RHEADERSIZE-3];
    pgpe.processBytes(rbuf);
    out.write(rbuf);
    pgpe.sync();
    byte buf[] = hdb.toByteArray();
    pgpe.processBytes(buf);
    out.write(buf);
    buf = new byte[128];
    while ((length = is.read(buf)) >= 0) {
        pgpe.processBytes(buf, 0, length);
        out.write (buf, 0, length);
    }
}    


}
