/* December 16, 1995 */
/* MD5 hash */
/* Based on md5.cpp - modified by Wei Dai from Eric Young's md5_dgst.c */
/* Assumes little-endian conventions */

public class MD5 extends Digest {

protected static int MD5_LAST_BLOCK = 56;
public static int DATASIZE = 64;
public static int DIGESTSIZE = 16;
public int digest[];              // output array
protected byte bdata[];
protected int data[];
protected long count;             // in bits, of data in bdata, mult of 8
protected boolean needpadding;

public Digest Clone()
{
    MD5 md5 = new MD5();
    System.arraycopy(digest, 0, md5.digest, 0, digest.length);
    System.arraycopy(bdata, 0, md5.bdata, 0, bdata.length);
    md5.count = count;
    md5.needpadding = needpadding;
    return md5;
}

public int outputLen()
{
    return DIGESTSIZE;
}

public String algName()
{
    return "MD5";
}

public String toString()
{
    return "MD5";
}


public MD5 ()
{
        reset();
}

public void reset()
{
    count = 0;

    digest = new int[DIGESTSIZE/4];
    bdata = new byte[DATASIZE];
    data = new int[DATASIZE/4];

    digest[0] = 0x67452301;
    digest[1] = 0xefcdab89;
    digest[2] = 0x98badcfe;
    digest[3] = 0x10325476;
    needpadding = true;
}

// Fill baDest with a constant value at specified offset and length
protected void byteset (byte bAdest[], int iDoff, byte val, int len)
{
    int i;
    for (i=0; i<len; ++i)
        bAdest[i+iDoff] = val;
}

// Copy byte array bArr to int array iArr at offsets and (int) length
protected void byte2int (int iArr[], int iOff, byte bArr[], int bOff,
                         int icnt)
{
    int i;
    for (i=0; i<icnt; ++i) {
        iArr[i+iOff] = ((bArr[bOff+0]&0xff)<<0)  | ((bArr[bOff+1]&0xff)<<8) |
                       ((bArr[bOff+2]&0xff)<<16) | ((bArr[bOff+3]&0xff)<<24);
        bOff += 4;
    }
}

// Copy bdata to data
protected void bdata2data()
{
    byte2int(data, 0, bdata, 0, DATASIZE/4);
}

// Transform bArr, fixed length DATASIZE, at specified offset
protected void do_block(byte bArr[], int off)
{
    byte2int (data, 0, bArr, off, DATASIZE/4);
    Transform(data);
}

// MD5 transform a single byte
public void update (byte b)
{
    byte ba[] = new byte[1];
    ba[0] = b;
    update(ba, 0, 1);
}



// MD5 transform byte array at specified offset and length
public void update (byte input[], int offset, int len)
{
    int num;

    num = ((int)count >> 3) & 0x3F;
    count += len << 3;

    if (num != 0) {
        if ((num+len) >= DATASIZE) {
            System.arraycopy(input, offset, bdata, num, DATASIZE-num);
            do_block(bdata, 0);
            offset += (DATASIZE-num);
            len-=(DATASIZE - num);
            num=0;
            // drop through and do the rest
        } else {
            System.arraycopy (input, offset, bdata, num, len);
            return;
        }
    }

    // we now can process the input data in blocks of DATASIZE
    // chars and save the leftovers to this->data.
    if (len >= DATASIZE)
    {
        do {
            do_block(input, offset);
            offset+=DATASIZE;
            len-=DATASIZE;
        } while (len >= DATASIZE);
    }

    System.arraycopy (input, offset, bdata, num, len);
}       // Update


// Finish MD5, leaves result in digest
public void insertPadding()
{
    int num = ((int)count >> 3) & 0x3F;
    // bdata should definitly have room for at least one more byte.
    bdata[num++] = (byte)0x80;
    if (num > MD5_LAST_BLOCK) {
        byteset(bdata, num, (byte)0, DATASIZE-num);
        do_block(bdata, 0);
        byteset(bdata, 0, (byte)0, MD5_LAST_BLOCK);
    } else {
        byteset(bdata, num, (byte)0, MD5_LAST_BLOCK-num);
    }

    bdata2data();
    data[14] = (int)count;
    data[15] = (int)(count>>32);
    Transform(data);

    needpadding = false;
}       // Final


public void getDigest(byte bArr[], int off)
{
    if (needpadding)
        insertPadding();
    for (int i=0; i<DIGESTSIZE/4; ++i) {
        int d = digest[i];
        bArr[off++] = (byte)(d>>0);
        bArr[off++] = (byte)(d>>8);
        bArr[off++] = (byte)(d>>16);
        bArr[off++] = (byte)(d>>24);
    }
}       // getDigest


// MD5 transform routines

static protected int F(int x,int y,int z) { return (z ^ (x & (y^z))); }
static protected int G(int x,int y,int z) { return (y ^ (z & (x^y))); }
static protected int H(int x,int y,int z) { return (x ^ y ^ z); }
static protected int I(int x,int y,int z) { return (y  ^  (x | ~z)); }
static protected int ROTATE(int a,int n) {
        return (a<<n)|(a>>>(32-n));
}

static protected int R0(int a,int b,int c,int d,int k,int s,int t) {
        a+=(k+t+F(b,c,d));
        a&=0xffffffff;
        a=ROTATE(a,s); 
        a+=b;
        return a;
}

static protected int R1(int a,int b,int c,int d,int k,int s,int t) {
        a+=(k+t+G(b,c,d));
        a&=0xffffffff;
        a=ROTATE(a,s);
        a+=b;
        return a;
}

static protected int R2(int a,int b,int c,int d,int k,int s,int t) {
        a+=(k+t+H(b,c,d));
        a&=0xffffffff;
        a=ROTATE(a,s); 
        a+=b;
        return a;
}

static protected int R3(int a,int b,int c,int d,int k,int s,int t) {
        a+=(k+t+I(b,c,d));
        a&=0xffffffff;
        a=ROTATE(a,s);
        a+=b;
        return a;
}


protected void Transform (int X[])
{
    int A,B,C,D;

    A=digest[0];
    B=digest[1];
    C=digest[2];
    D=digest[3];

    /* Round 0 */
    A=R0(A,B,C,D,X[ 0], 7,0xd76aa478);
    D=R0(D,A,B,C,X[ 1],12,0xe8c7b756);
    C=R0(C,D,A,B,X[ 2],17,0x242070db);
    B=R0(B,C,D,A,X[ 3],22,0xc1bdceee);
    A=R0(A,B,C,D,X[ 4], 7,0xf57c0faf);
    D=R0(D,A,B,C,X[ 5],12,0x4787c62a);
    C=R0(C,D,A,B,X[ 6],17,0xa8304613);
    B=R0(B,C,D,A,X[ 7],22,0xfd469501);
    A=R0(A,B,C,D,X[ 8], 7,0x698098d8);
    D=R0(D,A,B,C,X[ 9],12,0x8b44f7af);
    C=R0(C,D,A,B,X[10],17,0xffff5bb1);
    B=R0(B,C,D,A,X[11],22,0x895cd7be);
    A=R0(A,B,C,D,X[12], 7,0x6b901122);
    D=R0(D,A,B,C,X[13],12,0xfd987193);
    C=R0(C,D,A,B,X[14],17,0xa679438e);
    B=R0(B,C,D,A,X[15],22,0x49b40821);
    /* Round 1 */
    A=R1(A,B,C,D,X[ 1], 5,0xf61e2562);
    D=R1(D,A,B,C,X[ 6], 9,0xc040b340);
    C=R1(C,D,A,B,X[11],14,0x265e5a51);
    B=R1(B,C,D,A,X[ 0],20,0xe9b6c7aa);
    A=R1(A,B,C,D,X[ 5], 5,0xd62f105d);
    D=R1(D,A,B,C,X[10], 9,0x02441453);
    C=R1(C,D,A,B,X[15],14,0xd8a1e681);
    B=R1(B,C,D,A,X[ 4],20,0xe7d3fbc8);
    A=R1(A,B,C,D,X[ 9], 5,0x21e1cde6);
    D=R1(D,A,B,C,X[14], 9,0xc33707d6);
    C=R1(C,D,A,B,X[ 3],14,0xf4d50d87);
    B=R1(B,C,D,A,X[ 8],20,0x455a14ed);
    A=R1(A,B,C,D,X[13], 5,0xa9e3e905);
    D=R1(D,A,B,C,X[ 2], 9,0xfcefa3f8);
    C=R1(C,D,A,B,X[ 7],14,0x676f02d9);
    B=R1(B,C,D,A,X[12],20,0x8d2a4c8a);
    /* Round 2 */
    A=R2(A,B,C,D,X[ 5], 4,0xfffa3942);
    D=R2(D,A,B,C,X[ 8],11,0x8771f681);
    C=R2(C,D,A,B,X[11],16,0x6d9d6122);
    B=R2(B,C,D,A,X[14],23,0xfde5380c);
    A=R2(A,B,C,D,X[ 1], 4,0xa4beea44);
    D=R2(D,A,B,C,X[ 4],11,0x4bdecfa9);
    C=R2(C,D,A,B,X[ 7],16,0xf6bb4b60);
    B=R2(B,C,D,A,X[10],23,0xbebfbc70);
    A=R2(A,B,C,D,X[13], 4,0x289b7ec6);
    D=R2(D,A,B,C,X[ 0],11,0xeaa127fa);
    C=R2(C,D,A,B,X[ 3],16,0xd4ef3085);
    B=R2(B,C,D,A,X[ 6],23,0x04881d05);
    A=R2(A,B,C,D,X[ 9], 4,0xd9d4d039);
    D=R2(D,A,B,C,X[12],11,0xe6db99e5);
    C=R2(C,D,A,B,X[15],16,0x1fa27cf8);
    B=R2(B,C,D,A,X[ 2],23,0xc4ac5665);
    /* Round 3 */
    A=R3(A,B,C,D,X[ 0], 6,0xf4292244);
    D=R3(D,A,B,C,X[ 7],10,0x432aff97);
    C=R3(C,D,A,B,X[14],15,0xab9423a7);
    B=R3(B,C,D,A,X[ 5],21,0xfc93a039);
    A=R3(A,B,C,D,X[12], 6,0x655b59c3);
    D=R3(D,A,B,C,X[ 3],10,0x8f0ccc92);
    C=R3(C,D,A,B,X[10],15,0xffeff47d);
    B=R3(B,C,D,A,X[ 1],21,0x85845dd1);
    A=R3(A,B,C,D,X[ 8], 6,0x6fa87e4f);
    D=R3(D,A,B,C,X[15],10,0xfe2ce6e0);
    C=R3(C,D,A,B,X[ 6],15,0xa3014314);
    B=R3(B,C,D,A,X[13],21,0x4e0811a1);
    A=R3(A,B,C,D,X[ 4], 6,0xf7537e82);
    D=R3(D,A,B,C,X[11],10,0xbd3af235);
    C=R3(C,D,A,B,X[ 2],15,0x2ad7d2bb);
    B=R3(B,C,D,A,X[ 9],21,0xeb86d391);

    digest[0]+=A;
    digest[1]+=B;
    digest[2]+=C;
    digest[3]+=D;
} // Transform

} // class MD5
