/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.mime;

import cryptix.util.checksum.PRZ24;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Checksum;

public class Base64OutputStream
extends FilterOutputStream {
    private Checksum crc;
    private int crcLength;
    private byte[] inBuf;
    private int inOff;
    private int lineLength;
    private static final int MAX_LINE_LENGTH = 64;
    private static final char[] BASE64_CHARSET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char PADDING = '=';

    public Base64OutputStream(OutputStream outputStream, boolean bl) {
        super(outputStream);
        this.init(bl ? new PRZ24() : null, 3);
    }

    public Base64OutputStream(OutputStream outputStream) {
        super(outputStream);
        this.init(null, 0);
    }

    public Base64OutputStream(OutputStream outputStream, Checksum checksum, int n) {
        super(outputStream);
        checksum.reset();
        this.init(checksum, n);
    }

    public synchronized void write(int n) throws IOException {
        this.inBuf[this.inOff++] = (byte)n;
        if (this.crc != null) {
            this.crc.update(n);
        }
        if (this.inOff == 3) {
            this.writeQuadruplet();
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.write(byArray[n++]);
            ++n3;
        }
    }

    public synchronized void close() throws IOException {
        this.writePadding();
        if (this.lineLength != 0) {
            this.writeln();
        }
        if (this.crc != null) {
            long l = this.crc.getValue();
            super.write(61);
            this.crc = null;
            int n = this.crcLength - 1;
            while (n >= 0) {
                this.write((int)(l >>> n * 8) & 0xFF);
                --n;
            }
            this.writePadding();
            this.writeln();
        }
        super.flush();
        super.close();
    }

    private void init(Checksum checksum, int n) {
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException("length < 0 || length > 8");
        }
        this.inOff = 0;
        this.lineLength = 0;
        this.inBuf = new byte[3];
        this.crc = checksum;
        this.crcLength = n;
    }

    private void writePadding() throws IOException {
        if (this.inOff != 0) {
            int n = this.inOff;
            while (n < 3) {
                this.inBuf[n] = 0;
                ++n;
            }
            this.writeQuadruplet();
        }
    }

    private void writeQuadruplet() throws IOException {
        int n = BASE64_CHARSET[(this.inBuf[0] & 0xFF) >> 2];
        super.write(n);
        n = BASE64_CHARSET[(this.inBuf[0] & 3) << 4 | (this.inBuf[1] & 0xFF) >> 4];
        super.write(n);
        n = this.inOff > 1 ? BASE64_CHARSET[(this.inBuf[1] & 0xF) << 2 | (this.inBuf[2] & 0xCF) >> 6] : 61;
        super.write(n);
        n = this.inOff > 2 ? BASE64_CHARSET[this.inBuf[2] & 0x3F] : 61;
        super.write(n);
        this.inOff = 0;
        this.lineLength += 4;
        if (this.lineLength >= 64) {
            this.writeln();
        }
    }

    private void writeln() throws IOException {
        super.write(13);
        super.write(10);
        this.lineLength = 0;
    }
}

