/* 

        Copyright (C) 1999
        Free Software Foundation, Inc.

   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

*/


/*****************************************************************************/
/*                                                                           */
/* File: encrypt.c                                                           */
/*                                                                           */
/*****************************************************************************/

#include "cf.defs.h"
#include "cf.extern.h"
#include "../pub/global.h"
#include "../pub/md5.h"


#if defined(HAVE_LIBCRYPTO) || defined(HAVE_OPENSSL_DES_H)
      /* must be des.h from OpenSSL */
# include <openssl/des.h>
# define USE_SSL 1
#endif

/*********************************************************************/

void LoadSecretKeys()

{ char filename[maxvarsize];
  struct stat statbuf;
  char seed[8],digest[16];
  FILE *fp;
 
sprintf(filename,"%s/keys",VLOCKDIR);

if (stat(filename,&statbuf) == -1)
   {
   return;
   }

if (statbuf.st_mode & 077)
   {
   sprintf(OUTPUT,"Secret key file %s has public access! Copying is not secure",filename);
   CfLog(cferror,OUTPUT,"");
   }
 
bzero(CFDES1,8);
bzero(CFDES2,8);
bzero(CFDES3,8);
 
if ((fp = fopen(filename,"r")) == NULL)
   {
   return;
   }

fscanf(fp,"%8s%8s%8s",CFDES1,CFDES2,CFDES3);
fclose(fp);

Verbose("Loaded DES secret keys from %s\n",filename);

#ifdef USE_SSL
DESMD5Random(digest);
bcopy(digest,seed,8);
des_random_seed((des_cblock *)seed);
#endif 
}

/**************************************************************/

void DESMD5Random(digest)

char digest[16];

   /* Make a decent random number by crunching some system states through
      MD5. We can use this as a seed for pseudo random generator */

{ MD5_CTX context;
  unsigned char buffer[bufsize];
  FILE *pp;
  char pscomm[maxlinksize];

Verbose("Looking for a good random number seed...\n");
cfMD5Init (&context);
sprintf(buffer,"%d%d",(int)CFSTARTTIME,(int)digest);
cfMD5Update (&context, buffer,bufsize);

sprintf(pscomm,"%s %s",VPSCOMM[VSYSTEMHARDCLASS],VPSOPTS[VSYSTEMHARDCLASS]);

if ((pp = cfpopen(pscomm,"r")) == NULL)
   {
   sprintf(OUTPUT,"Couldn't open the process list with command %s\n",pscomm);
   CfLog(cferror,OUTPUT,"popen");
   }

while (!feof(pp))
   {
   ReadLine(buffer,bufsize,pp);
   cfMD5Update (&context,buffer,bufsize);
   }

cfpclose(pp);
 
cfMD5Final (digest, &context);
}

/*********************************************************************/

#ifdef USE_SSL

void cfencrypt(in,out,key1,key2,key3,len)

char *in,*out;
char key1[8],key2[8],key3[8];
int len;

{ char workvec[bufsize];
  des_key_schedule ks1,ks2,ks3;

des_set_key((C_Block *)key1,ks1);
des_set_key((C_Block *)key2,ks2);
des_set_key((C_Block *)key3,ks3);

memset(workvec,0,bufsize);

des_ede3_cbc_encrypt(in,out,(long)len,ks1,ks2,ks3,(C_Block *)workvec,DES_ENCRYPT);
}

/*********************************************************************/

void cfdecrypt(in,out,key1,key2,key3,len)

char *in,*out;
char key1[8],key2[8],key3[8];
int len;

{ char workvec[bufsize];
  des_key_schedule ks1,ks2,ks3;

memset(workvec,0,bufsize);
des_set_key((C_Block *)key1,ks1);
des_set_key((C_Block *)key2,ks2);
des_set_key((C_Block *)key3,ks3);

des_ede3_cbc_encrypt(in,out,(long)len,ks1,ks2,ks3,(C_Block *)workvec,DES_DECRYPT);

out[len] = '\0';

Debug("Decrypted %d to [%d]\n",len,strlen(out)); 
}

#else

void cfencrypt(in,out,key1,key2,key3,len)

char *in,*out;
char key1[8],key2[8],key3[8];
int len;

{
Debug("No encryption available...\n");
}

/*********************************************************************/

void cfdecrypt(in,out,key1,key2,key3,len)

char *in,*out;
char key1[8],key2[8],key3[8];
int len;

{
Debug("No decryption available...\n");
}

#endif
