/* LocaleInformation_eo.java --
   Copyright (C) 2005  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_eo extends ListResourceBundle
{
  private static final String[] shortMonths = {
    "jan",
    "feb",
    "mar",
    "apr",
    "maj",
    "jun",
    "jul",
    "a\u016dg",
    "sep",
    "okt",
    "nov",
    "dec",
    null,
  };

  private static final String[] months = {
    "januaro",
    "februaro",
    "marto",
    "aprilo",
    "majo",
    "junio",
    "julio",
    "a\u016dgusto",
    "septembro",
    "oktobro",
    "novembro",
    "decembro",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "di",
    "lu",
    "ma",
    "me",
    "\u0135a",
    "ve",
    "sa",
  };

  private static final String[] weekdays = {
    null,
    "diman\u0109o",
    "lundo",
    "mardo",
    "merkredo",
    "\u0135a\u016ddo",
    "vendredo",
    "sabato",
  };

  private static final String[] eras = {
    "aK",
    "pK",
  };

  private static final String[] ampms = {
    "atm",
    "ptm",
  };

  private static final String territoriesKeys = "TJ\u00A6TH\u00A6TG\u00A6GY\u00A6TD\u00A6GW\u00A6GU\u00A6GT\u00A6GS\u00A6GR\u00A6GQ\u00A6GP\u00A6SZ\u00A6SY\u00A6GN\u00A6GM\u00A6GL\u00A6SV\u00A6ST\u00A6GI\u00A6GH\u00A6SR\u00A6GF\u00A6GE\u00A6SO\u00A6GD\u00A6SN\u00A6SM\u00A6GB\u00A6SL\u00A6GA\u00A6SK\u00A6SJ\u00A6SI\u00A6SH\u00A6SG\u00A6SE\u00A6SD\u00A6SC\u00A6SB\u00A6SA\u00A6FR\u00A6FO\u00A6FM\u00A6RW\u00A6RU\u00A6FJ\u00A6FI\u00A6RO\u00A6RE\u00A6ET\u00A6ES\u00A6ER\u00A6EH\u00A6EG\u00A6EE\u00A6EC\u00A6DZ\u00A6QA\u00A6DO\u00A6PY\u00A6DM\u00A6PW\u00A6DK\u00A6DJ\u00A6PT\u00A6PR\u00A6DE\u00A6PN\u00A6PM\u00A6PL\u00A6PK\u00A6PH\u00A6PG\u00A6PF\u00A6CZ\u00A6PE\u00A6CY\u00A6CV\u00A6PA\u00A6CU\u00A6CR\u00A6CO\u00A6CN\u00A6CM\u00A6CL\u00A6CK\u00A6CI\u00A6CH\u00A6CG\u00A6CF\u00A6OM\u00A6CA\u00A6BZ\u00A6BY\u00A6BW\u00A6BT\u00A6BS\u00A6BR\u00A6NZ\u00A6BO\u00A6BN\u00A6BM\u00A6NU\u00A6BJ\u00A6BI\u00A6BH\u00A6NR\u00A6BG\u00A6BF\u00A6NP\u00A6BE\u00A6NO\u00A6BD\u00A6BB\u00A6ZW\u00A6NL\u00A6BA\u00A6NI\u00A6NG\u00A6NF\u00A6AZ\u00A6NE\u00A6NC\u00A6AW\u00A6ZM\u00A6AU\u00A6NA\u00A6AT\u00A6AR\u00A6AQ\u00A6MZ\u00A6AO\u00A6MY\u00A6AN\u00A6MX\u00A6AM\u00A6MW\u00A6AL\u00A6MV\u00A6ZA\u00A6MU\u00A6MT\u00A6AI\u00A6MR\u00A6AG\u00A6MQ\u00A6AF\u00A6MP\u00A6AE\u00A6AD\u00A6MN\u00A6MM\u00A6ML\u00A6MK\u00A6YU\u00A6YT\u00A6MH\u00A6MG\u00A6MD\u00A6MC\u00A6MA\u00A6YE\u00A6LY\u00A6LV\u00A6LU\u00A6LT\u00A6LS\u00A6LR\u00A6LK\u00A6LI\u00A6LC\u00A6LB\u00A6LA\u00A6KZ\u00A6KY\u00A6KW\u00A6KR\u00A6KP\u00A6KN\u00A6KM\u00A6KI\u00A6WS\u00A6KH\u00A6KG\u00A6KE\u00A6WF\u00A6JP\u00A6JO\u00A6JM\u00A6VU\u00A6VN\u00A6VI\u00A6VG\u00A6VE\u00A6VC\u00A6VA\u00A6IT\u00A6IS\u00A6IR\u00A6IQ\u00A6UZ\u00A6IO\u00A6UY\u00A6IN\u00A6IL\u00A6US\u00A6IE\u00A6ID\u00A6UM\u00A6UG\u00A6UA\u00A6HU\u00A6HT\u00A6HR\u00A6TZ\u00A6HN\u00A6HM\u00A6TW\u00A6TV\u00A6TT\u00A6TR\u00A6TO\u00A6TN\u00A6TM";

  private static final String territoriesValues = "Ta\u011dikujo\u00A6Tajlando\u00A6Togolo\u00A6Gujano\u00A6\u0108ado\u00A6Gvineo-Bisa\u016do\u00A6Gvamo\u00A6Gvatemalo\u00A6Sud-Georgio kaj Sud-Sandvi\u0109insuloj\u00A6Grekujo\u00A6Ekvatora Gvineo\u00A6Gvadelupo\u00A6Svazilando\u00A6Sirio\u00A6Gvineo\u00A6Gambio\u00A6Gronlando\u00A6Salvadoro\u00A6Sao-Tomeo kaj Principeo\u00A6\u011cibraltaro\u00A6Ganao\u00A6Surinamo\u00A6Franca Gviano\u00A6Kartvelujo\u00A6Somalujo\u00A6Grenado\u00A6Senegalo\u00A6San-Marino\u00A6Unui\u011dinta Re\u011dlando\u00A6Siera-Leono\u00A6Gabono\u00A6Slovakujo\u00A6Svalbardo kaj Jan-Majen-insulo\u00A6Slovenujo\u00A6Sent-Heleno\u00A6Singapuro\u00A6Svedujo\u00A6Sudano\u00A6Sej\u015deloj\u00A6Salomonoj\u00A6Sa\u016dda Arabujo\u00A6Francujo\u00A6Ferooj\u00A6Mikronezio\u00A6Ruando\u00A6Rusujo\u00A6Fi\u011doj\u00A6Finnlando\u00A6Rumanujo\u00A6Reunio\u00A6Etiopujo\u00A6Hispanujo\u00A6Eritreo\u00A6Okcidenta Saharo\u00A6Egipto\u00A6Estonujo\u00A6Ekvadoro\u00A6Al\u011derio\u00A6Kataro\u00A6Domingo\u00A6Paragvajo\u00A6Dominiko\u00A6Bela\u016do\u00A6Danujo\u00A6\u011cibutio\u00A6Portugalujo\u00A6Puerto-Riko\u00A6Germanujo\u00A6Pitkarna Insulo\u00A6Sent-Piero kaj Mikelono\u00A6Pollando\u00A6Pakistano\u00A6Filipinoj\u00A6Papuo-Nov-Gvineo\u00A6Franca Polinezio\u00A6\u0108e\u0125ujo\u00A6Peruo\u00A6Kipro\u00A6Kabo-Verdo\u00A6Panamo\u00A6Kubo\u00A6Kostariko\u00A6Kolombio\u00A6\u0108inujo\u00A6Kameruno\u00A6\u0108ilio\u00A6Kukinsuloj\u00A6Ebur-Bordo\u00A6Svisujo\u00A6Kongolo\u00A6Centr-Afrika Respubliko\u00A6Omano\u00A6Kanado\u00A6Belizo\u00A6Belorusujo\u00A6Bocvano\u00A6Butano\u00A6Bahamoj\u00A6Brazilo\u00A6Nov-Zelando\u00A6Bolivio\u00A6Brunejo\u00A6Bermudoj\u00A6Niuo\u00A6Benino\u00A6Burundo\u00A6Barejno\u00A6Nauro\u00A6Bulgarujo\u00A6Burkino\u00A6Nepalo\u00A6Belgujo\u00A6Norvegujo\u00A6Banglade\u015do\u00A6Barbado\u00A6Zimbabvo\u00A6Nederlando\u00A6Bosnio-Hercegovino\u00A6Nikaragvo\u00A6Ni\u011derio\u00A6Norfolkinsulo\u00A6Azerbaj\u011dano\u00A6Ni\u011dero\u00A6Nov-Kaledonio\u00A6Arubo\u00A6Zambio\u00A6A\u016dstralio\u00A6Namibio\u00A6A\u016dstrujo\u00A6Argentino\u00A6Antarkto\u00A6Mozambiko\u00A6Angolo\u00A6Malajzio\u00A6Nederlandaj Antiloj\u00A6Meksiko\u00A6Armenujo\u00A6Malavio\u00A6Albanujo\u00A6Maldivoj\u00A6Sud-Afriko\u00A6Ma\u016dricio\u00A6Malto\u00A6Angvilo\u00A6Ma\u016dritanujo\u00A6Antigvo-Barbudo\u00A6Martiniko\u00A6Afganujo\u00A6Nord-Marianoj\u00A6Unui\u011dintaj Arabaj Emirlandos\u00A6Andoro\u00A6Mongolujo\u00A6Mjanmao\u00A6Malio\u00A6Makedonujo\u00A6Serbujo\u00A6Majoto\u00A6Mar\u015daloj\u00A6Madagaskaro\u00A6Moldavujo\u00A6Monako\u00A6Maroko\u00A6Jemeno\u00A6Libio\u00A6Latvujo\u00A6Luksemburgo\u00A6Litovujo\u00A6Lesoto\u00A6Liberio\u00A6Sri-Lanko\u00A6Li\u0125ten\u015dtejno\u00A6Sent-Lucio\u00A6Libano\u00A6Laoso\u00A6Kaza\u0125stano\u00A6Kejmanoj\u00A6Kuvajto\u00A6Sud-Koreo\u00A6Nord-Koreo\u00A6Sent-Kristofo kaj Neviso\u00A6Komoroj\u00A6Kiribato\u00A6Samoo\u00A6Kambo\u011do\u00A6Kirgizistano\u00A6Kenjo\u00A6Valiso kaj Futuno\u00A6Japanujo\u00A6Jordanio\u00A6Jamajko\u00A6Vanuatuo\u00A6Vjetnamo\u00A6Usonaj Virgulininsuloj\u00A6Britaj Virgulininsuloj\u00A6Venezuelo\u00A6Sent-Vincento kaj la Grenadinoj\u00A6Vatikano\u00A6Italujo\u00A6Islando\u00A6Irano\u00A6Irako\u00A6Uzbekujo\u00A6Brita Hindoceana Teritorio\u00A6Urugvajo\u00A6Hindujo\u00A6Israelo\u00A6Usono\u00A6Irlando\u00A6Indonezio\u00A6Usonaj malgrandaj insuloj\u00A6Ugando\u00A6Ukrajno\u00A6Hungarujo\u00A6Haitio\u00A6Kroatujo\u00A6Tanzanio\u00A6Honduro\u00A6Herda kaj Makdonaldaj Insuloj\u00A6Tajvano\u00A6Tuvalo\u00A6Trinidado kaj Tobago\u00A6Turkujo\u00A6Tongo\u00A6Tunizio\u00A6Turkmenujo";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(territoriesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es\u00A6ku\u00A6eo\u00A6ks\u00A6en\u00A6el\u00A6qu\u00A6ko\u00A6kn\u00A6km\u00A6kl\u00A6kk\u00A6wo\u00A6ka\u00A6dz\u00A6jv\u00A6pt\u00A6ps\u00A6de\u00A6pl\u00A6da\u00A6vo\u00A6ja\u00A6vi\u00A6cy\u00A6pa\u00A6cs\u00A6iu\u00A6it\u00A6co\u00A6is\u00A6uz\u00A6or\u00A6ik\u00A6ur\u00A6om\u00A6ca\u00A6ie\u00A6id\u00A6uk\u00A6ia\u00A6oc\u00A6ug\u00A6hy\u00A6br\u00A6hu\u00A6bo\u00A6bn\u00A6hr\u00A6bi\u00A6tw\u00A6bh\u00A6bg\u00A6tt\u00A6no\u00A6be\u00A6ts\u00A6hi\u00A6tr\u00A6nl\u00A6zu\u00A6ba\u00A6to\u00A6he\u00A6tn\u00A6tl\u00A6tk\u00A6ha\u00A6ne\u00A6az\u00A6ti\u00A6ay\u00A6th\u00A6tg\u00A6na\u00A6te\u00A6zh\u00A6as\u00A6ar\u00A6ta\u00A6gu\u00A6my\u00A6am\u00A6za\u00A6mt\u00A6ms\u00A6gn\u00A6sw\u00A6mr\u00A6sv\u00A6gl\u00A6su\u00A6af\u00A6st\u00A6ss\u00A6mn\u00A6sr\u00A6sq\u00A6ml\u00A6ab\u00A6mk\u00A6aa\u00A6so\u00A6sn\u00A6mi\u00A6gd\u00A6sm\u00A6sl\u00A6mg\u00A6sk\u00A6ga\u00A6yo\u00A6si\u00A6sh\u00A6sg\u00A6yi\u00A6sd\u00A6fy\u00A6sa\u00A6fr\u00A6lv\u00A6lt\u00A6fo\u00A6rw\u00A6ru\u00A6lo\u00A6fj\u00A6ln\u00A6fi\u00A6ro\u00A6rn\u00A6rm\u00A6fa\u00A6la\u00A6xh\u00A6eu\u00A6ky\u00A6et";

  private static final String languagesValues = "hispana\u00A6kurda\u00A6esperanto\u00A6ka\u015dmira\u00A6angla\u00A6greka\u00A6ke\u0109ua\u00A6korea\u00A6kanara\u00A6kmera\u00A6gronlanda\u00A6kaza\u0125a\u00A6volofa\u00A6kartvela\u00A6dzonko\u00A6java\u00A6portugala\u00A6pa\u015dtua\u00A6germana\u00A6pola\u00A6dana\u00A6volapuko\u00A6japana\u00A6vjetnama\u00A6kimra\u00A6pan\u011daba\u00A6\u0109e\u0125a\u00A6inuita\u00A6itala\u00A6korsika\u00A6islanda\u00A6uzbeka\u00A6orijo\u00A6eskima\u00A6urduo\u00A6oroma\u00A6kataluna\u00A6okcidentalo\u00A6indonezia\u00A6ukraina\u00A6interlingvao\u00A6okcitana\u00A6ujgura\u00A6armena\u00A6bretona\u00A6hungara\u00A6tibeta\u00A6bengala\u00A6kroata\u00A6bislamo\u00A6akana\u00A6bihara\u00A6bulgara\u00A6tatara\u00A6norvega\u00A6belorusa\u00A6conga\u00A6hinda\u00A6turka\u00A6nederlanda\u00A6zulua\u00A6ba\u015dkira\u00A6tongaa\u00A6hebrea\u00A6cvana\u00A6filipina\u00A6turkmena\u00A6ha\u016dsa\u00A6nepala\u00A6azerbaj\u011dana\u00A6tigraja\u00A6ajmara\u00A6taja\u00A6ta\u011dika\u00A6naura\u00A6telugua\u00A6\u0109ina\u00A6asama\u00A6araba\u00A6tamila\u00A6gu\u011darata\u00A6birma\u00A6amhara\u00A6\u011duanga\u00A6malta\u00A6malaja\u00A6gvarania\u00A6svahila\u00A6marata\u00A6sveda\u00A6galega\u00A6sunda\u00A6afrikansa\u00A6sota\u00A6svazia\u00A6mongola\u00A6serba\u00A6albana\u00A6malajalama\u00A6ab\u0125aza\u00A6makedona\u00A6afara\u00A6somala\u00A6\u015dona\u00A6maoria\u00A6gaela\u00A6samoa\u00A6slovena\u00A6malagasa\u00A6slovaka\u00A6irlanda\u00A6joruba\u00A6sinhala\u00A6serbo-Kroata\u00A6sangoa\u00A6jida\u00A6sinda\u00A6frisa\u00A6sanskrito\u00A6franca\u00A6latva\u00A6litova\u00A6feroa\u00A6ruanda\u00A6rusa\u00A6la\u016da\u00A6fi\u011dia\u00A6lingala\u00A6finna\u00A6rumana\u00A6burunda\u00A6roman\u0109a\u00A6persa\u00A6latino\u00A6ksosa\u00A6e\u016dska\u00A6kirgiza\u00A6estona";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(languagesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "localPatternChars", "GjMtkHmslTDUSnahKzJdugAZ" },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "minNumberOfDaysInFirstWeek", "4" },
    { "firstDayOfWeek", "mon" },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "yy-MM-dd" },
    { "mediumDateFormat", "yyyy-MMM-dd" },
    { "longDateFormat", "yyyy-MMMM-dd" },
    { "fullDateFormat", "EEEE, d'-a de 'MMMM yyyy" },
    { "fullTimeFormat", "H'-a horo kaj 'm z" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
