%{
/*
 * Copyright (C) 1999, 2000 Lorenzo Bettini, lorenzo.bettini@penteres.it
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */                         

int lineno = 1 ; /* numero di linee scandite */
char linebuf[1024] ; /* linea di codice attuale */
int tokenpos = 0 ; /* posizione del token corrente nella linea corrente */

#include "tags.h"
#include "tokens.h"
#include "colors.h"

#include "genfun.h"

%}


nl \n
cr \r
STRING \"[^\"\n]*\"
not_alpha [^a-zA-Z0-9]

%s COMMENT_STATE
%s SINGLELINE_COMMENT
%s STRING_STATE
%s CHAR_STATE

IDE [a-zA-Z_]([a-zA-Z0-9_])*
wspace [ \t\n\r]
templspec \<({wspace}|{IDE})*\>


keyword1 (asm|auto|break|case|catch|class|const|const_cast|continue|default)
keyword2 (delete|do|dynamic_cast|else|enum|explicit|export|extern|false|for)
keyword3 (friend|goto|if|inline|mutable|namespace|new|operator|private)
keyword4 (protected|public|register|reinterpret_cast|return|sizeof|static)
keyword5 (static_cast|struct|switch|template|throw|this|true|try|typedef)
keyword6 (typeid|typename|union|using|virtual|volatile|while)

keyword ({keyword1}|{keyword2}|{keyword3}|{keyword4}|{keyword5}|{keyword6})
basetype (bool|char|double|float|int|long|short|signed|unsigned|void|wchar_t)
symbol [\~\!\%\^\*\(\)\-\+\=\[\]\|\\\:\;\,\.\/\?\&\<\>]
cbracket [\{\}]

funccall {IDE}/{wspace}*({templspec}){0,1}{wspace}*\(

%%

<INITIAL>"/*" { BEGIN COMMENT_STATE ;
       startComment( yytext ) ;      
     }
<INITIAL>"/*".*"*/" { generateComment( yytext ) ;  }

<COMMENT_STATE>"*/" { endComment(yytext) ;
                      BEGIN INITIAL ; /* end of the comment */ }

<INITIAL>"//" { BEGIN SINGLELINE_COMMENT ; startComment( yytext ) ; }
<SINGLELINE_COMMENT>"//" { generate_preproc( yytext ) ; }
<SINGLELINE_COMMENT>\n { 
   BEGIN INITIAL ; 
   yyless (0); // put the \n back
   endComment( yytext ) ; 
   /* if we encounter another // during a comment we simply
      treat it as a ordinary string */
 }

<INITIAL>\" { BEGIN STRING_STATE ; startString( yytext );  }
<STRING_STATE>\\\\ {  generate_preproc( yytext ) ; }
<STRING_STATE>"\\\"" {  generate_preproc( yytext ) ; }
<STRING_STATE>\" { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>\' { BEGIN CHAR_STATE ; startString( yytext );  }
<CHAR_STATE>\\\\ {  generate_preproc( yytext ) ; }
<CHAR_STATE>"\\\'" {  generate_preproc( yytext ) ; }
<CHAR_STATE>\' { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>\#[ \t]*[^\"\n\t ]* { generatePreProc( yytext) ; }

<INITIAL>{keyword} { generateKeyWord( yytext ) ; }
<INITIAL>{basetype} { generateBaseType( yytext ) ; }
<INITIAL>{symbol} { generateSymbol( yytext ); }
<INITIAL>[\{\}] { generateCBracket ( yytext ); }

<INITIAL>{keyword}/{wspace}*\( { generateKeyWord( yytext ) ; }
<INITIAL>{basetype}/{wspace}*\( { generateBaseType( yytext ) ; }
<INITIAL>{funccall} { generateFunction ( yytext ); }

<INITIAL>0[xX][0-9a-fA-F]* { generateNumber( yytext ) ; }
<INITIAL>[0-9][0-9]*(\.[0-9]*[eE]?[-+]?[0-9]*)? { generateNumber( yytext ) ; }

<INITIAL>\<[^\"\n ]*\> { generateString (yytext); }

[a-zA-Z_]([a-zA-Z0-9_])* { generate( yytext ) ; }


. { generate_preproc( yytext ) ; /* anything else */ }

\n { 
       ++lineno;
       generateNewLine() ;
}

%%

void yyerror( char *s ) ;

void yyerror( char *s )
{  
  fprintf( stderr, "%d: %s: %s\n%s\n", lineno, s, yytext, linebuf ) ;
  fprintf( stderr, "%*s\n", tokenpos, "^" ) ;
}
