/*
 * Copyright (C) 1999, 2000, 2001  Lorenzo Bettini, bettini@gnu.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "chartranslator.h"

#include <string.h>

CharTranslator::CharTranslator()
{
  for (int i = 0; i < NUM_OF_CHARS; ++i)
    characters[i] = 0;
}

void
CharTranslator::set_translation(char to_translate, 
                                const char *translate_into)
{
  characters[to_translate] = strdup (translate_into);
}

// s must be a NULL terminated string
void
CharTranslator::translate(ostream *sout, const char *s)
{
  for (unsigned int i = 0; i < strlen (s); ++i)
    {
      if (characters[s[i]])
        (*sout) << characters[s[i]];
      else
        (*sout) << s[i];
    }
}
